/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.storage.impl.routing;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.clients.impl.internal.api.StorageServerClientManager;
import org.apache.bookkeeper.clients.impl.routing.RangeRouter;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.router.BytesHashRouter;
import org.apache.bookkeeper.common.router.HashRouter;
import org.apache.bookkeeper.stream.proto.RangeProperties;
import org.apache.bookkeeper.stream.storage.impl.routing.RangeRoutingTable;
import org.apache.bookkeeper.util.collections.ConcurrentLongHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeRoutingTableImpl
implements RangeRoutingTable {
    private static final Logger log = LoggerFactory.getLogger(RangeRoutingTableImpl.class);
    private final StorageServerClientManager manager;
    private final ConcurrentLongHashMap<RangeRouter<byte[]>> ranges;
    private final ConcurrentLongHashMap<CompletableFuture<RangeRouter<byte[]>>> outstandingUpdates;

    public RangeRoutingTableImpl(StorageServerClientManager manager) {
        this.manager = manager;
        this.ranges = new ConcurrentLongHashMap();
        this.outstandingUpdates = new ConcurrentLongHashMap();
    }

    @VisibleForTesting
    RangeRouter<byte[]> getRangeRouter(long streamId) {
        return (RangeRouter)this.ranges.get(streamId);
    }

    @Override
    public RangeProperties getRange(long streamId, byte[] routingKey) {
        RangeRouter router = (RangeRouter)this.ranges.get(streamId);
        if (null == router) {
            this.fetchStreamRanges(streamId);
            return null;
        }
        return router.getRangeProperties((Object)routingKey);
    }

    @VisibleForTesting
    CompletableFuture<RangeRouter<byte[]>> getOutstandingFetchRequest(long streamId) {
        return (CompletableFuture)this.outstandingUpdates.get(streamId);
    }

    private void fetchStreamRanges(long streamId) {
        if (null != this.outstandingUpdates.get(streamId)) {
            return;
        }
        CompletableFuture newFetchFuture = new CompletableFuture();
        if (null != this.outstandingUpdates.put(streamId, newFetchFuture)) {
            return;
        }
        FutureUtils.proxyTo((CompletableFuture)((CompletableFuture)((CompletableFuture)this.manager.openMetaRangeClient(streamId).thenCompose(metaRangeClient -> metaRangeClient.getActiveDataRanges())).thenApply(hashStreamRanges -> {
            RangeRouter router = new RangeRouter((HashRouter)BytesHashRouter.of());
            router.setRanges(hashStreamRanges);
            return router;
        })).whenComplete((router, cause) -> {
            if (null == cause) {
                this.ranges.put(streamId, router);
            }
            this.outstandingUpdates.remove(streamId, (Object)newFetchFuture);
        }), newFetchFuture);
    }
}

