/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.storage.impl;

import io.grpc.Channel;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import java.io.IOException;
import org.apache.bookkeeper.common.component.AbstractLifecycleComponent;
import org.apache.bookkeeper.common.conf.ComponentConfiguration;
import org.apache.bookkeeper.common.grpc.netty.LongBinaryMarshaller;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stream.storage.api.StorageContainerStore;
import org.apache.bookkeeper.stream.storage.api.sc.StorageContainer;
import org.apache.bookkeeper.stream.storage.api.sc.StorageContainerManager;
import org.apache.bookkeeper.stream.storage.api.sc.StorageContainerManagerFactory;
import org.apache.bookkeeper.stream.storage.api.sc.StorageContainerRegistry;
import org.apache.bookkeeper.stream.storage.api.sc.StorageContainerRoutingService;
import org.apache.bookkeeper.stream.storage.api.sc.StorageContainerServiceFactory;
import org.apache.bookkeeper.stream.storage.conf.StorageConfiguration;
import org.apache.bookkeeper.stream.storage.impl.sc.DefaultStorageContainerFactory;
import org.apache.bookkeeper.stream.storage.impl.sc.StorageContainerRegistryImpl;

public class StorageContainerStoreImpl
extends AbstractLifecycleComponent<StorageConfiguration>
implements StorageContainerStore {
    private final StorageContainerManagerFactory scmFactory;
    private final StorageContainerRegistryImpl scRegistry;
    private final StorageContainerManager scManager;
    private final StorageContainerServiceFactory serviceFactory;
    private final Metadata.Key<Long> scIdKey;

    public StorageContainerStoreImpl(StorageConfiguration conf, StorageContainerManagerFactory managerFactory, StorageContainerServiceFactory serviceFactory, StatsLogger statsLogger) {
        super("range-service", (ComponentConfiguration)conf, statsLogger);
        this.scmFactory = managerFactory;
        this.scRegistry = new StorageContainerRegistryImpl(new DefaultStorageContainerFactory(serviceFactory));
        this.scManager = this.scmFactory.create(conf, (StorageContainerRegistry)this.scRegistry);
        this.serviceFactory = serviceFactory;
        this.scIdKey = Metadata.Key.of((String)"sc-id-bin", (Metadata.BinaryMarshaller)LongBinaryMarshaller.of());
    }

    public StorageContainerRegistryImpl getRegistry() {
        return this.scRegistry;
    }

    public StorageContainerRoutingService getRoutingService() {
        return this.scManager;
    }

    protected void doStart() {
        this.scManager.start();
    }

    protected void doStop() {
        this.scManager.stop();
        this.scRegistry.close();
    }

    protected void doClose() throws IOException {
        this.scManager.close();
        this.serviceFactory.close();
    }

    StorageContainer getStorageContainer(long scId) {
        return this.scRegistry.getStorageContainer(scId);
    }

    public Channel findChannel(ServerCall<?, ?> serverCall, Metadata headers) {
        Long scId = (Long)headers.get(this.scIdKey);
        if (null == scId) {
            scId = -1L;
        }
        return this.getStorageContainer(scId).getChannel();
    }
}

