/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.storage.impl.cluster;

import com.google.common.base.Strings;
import java.net.URI;
import java.util.Optional;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.stream.proto.cluster.ClusterMetadata;
import org.apache.bookkeeper.stream.storage.api.cluster.ClusterInitializer;
import org.apache.bookkeeper.stream.storage.exceptions.StorageRuntimeException;
import org.apache.bookkeeper.stream.storage.impl.cluster.ZkClusterMetadataStore;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkClusterInitializer
implements ClusterInitializer {
    private static final Logger log = LoggerFactory.getLogger(ZkClusterInitializer.class);
    private final String zkExternalConnectString;

    public ZkClusterInitializer(String zkServers) {
        this.zkExternalConnectString = zkServers;
    }

    public boolean acceptsURI(URI metadataServiceUri) {
        return metadataServiceUri.getScheme().toLowerCase().startsWith("zk");
    }

    public void initializeCluster(URI metadataServiceUri, int numStorageContainers) {
        block15: {
            String zkInternalConnectString = ZKMetadataDriverBase.getZKServersFromServiceUri((URI)metadataServiceUri);
            try (CuratorFramework client = CuratorFrameworkFactory.newClient((String)this.zkExternalConnectString, (RetryPolicy)new ExponentialBackoffRetry(100, Integer.MAX_VALUE, 10000));){
                client.start();
                ZkClusterMetadataStore store = new ZkClusterMetadataStore(client, zkInternalConnectString, "/stream");
                try {
                    ClusterMetadata metadata = store.getClusterMetadata();
                    log.info("Loaded cluster metadata : \n{}", (Object)metadata);
                }
                catch (StorageRuntimeException sre) {
                    if (sre.getCause() instanceof KeeperException.NoNodeException) {
                        log.info("Initializing the stream cluster with {} storage containers with segment store path {}.", (Object)numStorageContainers);
                        String ledgersPath = metadataServiceUri.getPath();
                        Optional<Object> segmentStorePath = Strings.isNullOrEmpty((String)ledgersPath) || "/" == ledgersPath ? Optional.empty() : Optional.of(ledgersPath);
                        store.initializeCluster(numStorageContainers, segmentStorePath);
                        log.info("Successfully initialized the stream cluster : \n{}", (Object)store.getClusterMetadata());
                        break block15;
                    }
                    throw sre;
                }
            }
        }
    }
}

