/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.storage;

public class StorageResourcesSpec {
    private int numSchedulerThreads;
    private int numIOWriteThreads;
    private int numIOReadThreads;
    private int numCheckpointThreads;

    private static int $default$numSchedulerThreads() {
        return Runtime.getRuntime().availableProcessors() * 2;
    }

    private static int $default$numIOWriteThreads() {
        return Runtime.getRuntime().availableProcessors() * 2;
    }

    private static int $default$numIOReadThreads() {
        return Runtime.getRuntime().availableProcessors() * 2;
    }

    private static int $default$numCheckpointThreads() {
        return Runtime.getRuntime().availableProcessors() * 2;
    }

    StorageResourcesSpec(int numSchedulerThreads, int numIOWriteThreads, int numIOReadThreads, int numCheckpointThreads) {
        this.numSchedulerThreads = numSchedulerThreads;
        this.numIOWriteThreads = numIOWriteThreads;
        this.numIOReadThreads = numIOReadThreads;
        this.numCheckpointThreads = numCheckpointThreads;
    }

    public static StorageResourcesSpecBuilder builder() {
        return new StorageResourcesSpecBuilder();
    }

    public int numSchedulerThreads() {
        return this.numSchedulerThreads;
    }

    public int numIOWriteThreads() {
        return this.numIOWriteThreads;
    }

    public int numIOReadThreads() {
        return this.numIOReadThreads;
    }

    public int numCheckpointThreads() {
        return this.numCheckpointThreads;
    }

    public StorageResourcesSpec numSchedulerThreads(int numSchedulerThreads) {
        this.numSchedulerThreads = numSchedulerThreads;
        return this;
    }

    public StorageResourcesSpec numIOWriteThreads(int numIOWriteThreads) {
        this.numIOWriteThreads = numIOWriteThreads;
        return this;
    }

    public StorageResourcesSpec numIOReadThreads(int numIOReadThreads) {
        this.numIOReadThreads = numIOReadThreads;
        return this;
    }

    public StorageResourcesSpec numCheckpointThreads(int numCheckpointThreads) {
        this.numCheckpointThreads = numCheckpointThreads;
        return this;
    }

    public static class StorageResourcesSpecBuilder {
        private boolean numSchedulerThreads$set;
        private int numSchedulerThreads;
        private boolean numIOWriteThreads$set;
        private int numIOWriteThreads;
        private boolean numIOReadThreads$set;
        private int numIOReadThreads;
        private boolean numCheckpointThreads$set;
        private int numCheckpointThreads;

        StorageResourcesSpecBuilder() {
        }

        public StorageResourcesSpecBuilder numSchedulerThreads(int numSchedulerThreads) {
            this.numSchedulerThreads = numSchedulerThreads;
            this.numSchedulerThreads$set = true;
            return this;
        }

        public StorageResourcesSpecBuilder numIOWriteThreads(int numIOWriteThreads) {
            this.numIOWriteThreads = numIOWriteThreads;
            this.numIOWriteThreads$set = true;
            return this;
        }

        public StorageResourcesSpecBuilder numIOReadThreads(int numIOReadThreads) {
            this.numIOReadThreads = numIOReadThreads;
            this.numIOReadThreads$set = true;
            return this;
        }

        public StorageResourcesSpecBuilder numCheckpointThreads(int numCheckpointThreads) {
            this.numCheckpointThreads = numCheckpointThreads;
            this.numCheckpointThreads$set = true;
            return this;
        }

        public StorageResourcesSpec build() {
            int numSchedulerThreads = this.numSchedulerThreads;
            if (!this.numSchedulerThreads$set) {
                numSchedulerThreads = StorageResourcesSpec.$default$numSchedulerThreads();
            }
            int numIOWriteThreads = this.numIOWriteThreads;
            if (!this.numIOWriteThreads$set) {
                numIOWriteThreads = StorageResourcesSpec.$default$numIOWriteThreads();
            }
            int numIOReadThreads = this.numIOReadThreads;
            if (!this.numIOReadThreads$set) {
                numIOReadThreads = StorageResourcesSpec.$default$numIOReadThreads();
            }
            int numCheckpointThreads = this.numCheckpointThreads;
            if (!this.numCheckpointThreads$set) {
                numCheckpointThreads = StorageResourcesSpec.$default$numCheckpointThreads();
            }
            return new StorageResourcesSpec(numSchedulerThreads, numIOWriteThreads, numIOReadThreads, numCheckpointThreads);
        }

        public String toString() {
            return "StorageResourcesSpec.StorageResourcesSpecBuilder(numSchedulerThreads=" + this.numSchedulerThreads + ", numIOWriteThreads=" + this.numIOWriteThreads + ", numIOReadThreads=" + this.numIOReadThreads + ", numCheckpointThreads=" + this.numCheckpointThreads + ")";
        }
    }
}

