/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.maven2.mojos;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.cactus.integration.api.version.Version;
import org.apache.cactus.maven2.mojos.CactifyWarMojo;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.assembly.archive.ArchiveExpansionException;
import org.apache.maven.plugin.assembly.utils.AssemblyFileUtils;
import org.apache.maven.project.MavenProject;
import org.codehaus.cargo.module.application.ApplicationXml;
import org.codehaus.cargo.module.application.ApplicationXmlIo;
import org.codehaus.cargo.module.application.DefaultEarArchive;
import org.codehaus.cargo.module.ejb.EjbArchive;
import org.codehaus.cargo.module.ejb.EjbJarXml;
import org.codehaus.cargo.module.ejb.Entity;
import org.codehaus.cargo.module.ejb.Session;
import org.codehaus.cargo.module.webapp.EjbRef;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.ear.EarArchiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.war.WarArchiver;
import org.codehaus.plexus.util.FileUtils;
import org.jdom.JDOMException;

public class CactifyEarMojo
extends AbstractMojo {
    private CactifyWarMojo cactusWar;
    private File srcFile;
    private File destFile;
    private boolean addEjbReferences;
    private EarArchiver earArchiver;
    private WarArchiver warArchiver;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    private MavenProject project;
    private ArchiverManager archiverManager;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.cactusWar == null) {
            this.cactusWar = this.createCactusWarConfig();
        }
        if (this.getSrcFile() == null) {
            throw new MojoExecutionException("You need to specify [srcFile] attribute for cactification!");
        }
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver((JarArchiver)this.earArchiver);
        File tempLocation = null;
        tempLocation = FileUtils.createTempFile((String)"cactus", (String)"explode.tmp.dir", (File)this.getProject().getBasedir());
        tempLocation.mkdirs();
        tempLocation.deleteOnExit();
        try {
            if (this.srcFile != null) {
                AssemblyFileUtils.unpack((File)this.srcFile, (File)tempLocation, (ArchiverManager)this.archiverManager);
            }
        }
        catch (ArchiveExpansionException e) {
            throw new MojoExecutionException("Error extracting the archive.", (Exception)((Object)e));
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Problem reading the source archive.", (Exception)((Object)e));
        }
        try {
            this.earArchiver.addDirectory(tempLocation);
        }
        catch (ArchiverException e1) {
            throw new MojoExecutionException("Problem adding the source files to the dest. archive ", (Exception)((Object)e1));
        }
        ApplicationXml appXml = null;
        try {
            appXml = this.getOriginalApplicationXml();
        }
        catch (JDOMException e) {
            throw new MojoExecutionException("Unable to get the original application.xml", (Exception)((Object)e));
        }
        File tmpAppXml = this.cactifyApplicationXml(appXml);
        try {
            try {
                this.earArchiver.addDirectory(tempLocation);
                this.earArchiver.setAppxml(tmpAppXml);
                archiver.setOutputFile(this.getDestFile());
                File cactusWarFile = this.createCactusWarFile();
                this.addFileToEar(cactusWarFile, this.cactusWar.getFileName());
                archiver.createArchive(this.getProject(), this.getArchive());
            }
            catch (ArchiverException aex) {
                throw new MojoExecutionException("Error while performing the cactified archive.", (Exception)((Object)aex));
            }
            catch (ManifestException me) {
                throw new MojoExecutionException("Error reading the manifest data in the original file.", (Exception)((Object)me));
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Input/output exception occured ", (Exception)ioe);
            }
            catch (DependencyResolutionRequiredException de) {
                throw new MojoExecutionException("Problem with resolving the dependencies of the project. ", (Exception)((Object)de));
            }
            Object var7_14 = null;
        }
        catch (Throwable throwable) {
            Object var7_15 = null;
            try {
                if (tempLocation == null) throw throwable;
                FileUtils.deleteDirectory((File)tempLocation);
                throw throwable;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error deleting temporary folder", (Exception)e);
            }
        }
        try {}
        catch (IOException e) {
            throw new MojoExecutionException("Error deleting temporary folder", (Exception)e);
        }
        if (tempLocation == null) return;
        FileUtils.deleteDirectory((File)tempLocation);
    }

    private File createCactusWarFile() throws MojoExecutionException, MojoFailureException {
        File tmpCactusWar = FileUtils.createTempFile((String)"cactus", (String)"cactus.war", (File)this.getProject().getBasedir());
        tmpCactusWar.deleteOnExit();
        this.cactusWar.setDestFile(tmpCactusWar);
        this.cactusWar.setWarArchiver(this.warArchiver);
        this.cactusWar.setProject(this.project);
        if (this.addEjbReferences) {
            try {
                this.addEjbReferencesToWar(tmpCactusWar);
            }
            catch (JDOMException e) {
                throw new MojoExecutionException("Unable to add ejb-references", (Exception)((Object)e));
            }
        }
        this.cactusWar.execute();
        return tmpCactusWar;
    }

    private File cactifyApplicationXml(ApplicationXml theAppXml) throws MojoExecutionException {
        theAppXml.addWebModule(this.cactusWar.getFileName(), this.cactusWar.getContext());
        File tmpAppXml = FileUtils.createTempFile((String)"cactus", (String)"application.xml", (File)this.getProject().getBasedir());
        tmpAppXml.deleteOnExit();
        try {
            ApplicationXmlIo.writeApplicationXml((ApplicationXml)theAppXml, (File)tmpAppXml, null, (boolean)true);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Could not write temporary deployment descriptor", (Exception)ioe);
        }
        return tmpAppXml;
    }

    private ApplicationXml getOriginalApplicationXml() throws JDOMException, MojoExecutionException {
        ApplicationXml appXml = null;
        try {
            DefaultEarArchive ear = new DefaultEarArchive((InputStream)new FileInputStream(this.srcFile));
            appXml = ear.getApplicationXml();
            if (appXml == null) {
                throw new MojoExecutionException("The EAR source file does not contain a META-INF/application.xml deployment descriptor");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to open EAR", (Exception)e);
        }
        return appXml;
    }

    private void addFileToEar(File theFile, String theFullPath) throws ArchiverException {
        this.earArchiver.addFile(theFile, theFullPath);
    }

    private void addEjbReferencesToWar(File theWar) throws JDOMException, MojoExecutionException {
        try {
            DefaultEarArchive ear = new DefaultEarArchive((InputStream)new FileInputStream(this.srcFile));
            ApplicationXml appXml = ear.getApplicationXml();
            Iterator ejbModules = appXml.getEjbModules();
            while (ejbModules.hasNext()) {
                EjbRef ref;
                String localHome;
                String local;
                String name;
                Session ejb;
                String module = (String)ejbModules.next();
                EjbArchive ejbArchive = ear.getEjbModule(module);
                EjbJarXml descr = ejbArchive.getEjbJarXml();
                Iterator vendorDescrIterator = descr.getVendorDescriptors();
                if (vendorDescrIterator == null || !vendorDescrIterator.hasNext()) {
                    throw new MojoExecutionException("Failed to find vendor deployment descriptor for ejb jar " + module);
                }
                Iterator ejbs = descr.getSessionEjbs();
                while (ejbs.hasNext()) {
                    ejb = (Session)ejbs.next();
                    name = ejb.getName();
                    local = ejb.getLocal();
                    localHome = ejb.getLocalHome();
                    if (local == null) continue;
                    this.getLog().debug((CharSequence)("Adding ejb-ref for local session ejb " + ejb.getName()));
                    ref = new EjbRef();
                    ref.setType("Session");
                    ref.setEjbName(name);
                    ref.setName("ejb/" + name);
                    ref.setEjbInterface(local);
                    ref.setEjbHomeInterface(localHome);
                    ref.setLocal(true);
                    this.cactusWar.addConfiguredEjbref(ref);
                }
                ejbs = descr.getEntityEjbs();
                while (ejbs.hasNext()) {
                    ejb = (Entity)ejbs.next();
                    name = ejb.getName();
                    local = ejb.getLocal();
                    localHome = ejb.getLocalHome();
                    if (local == null) continue;
                    this.getLog().debug((CharSequence)("Adding ejb-ref for local entity ejb " + ejb.getName()));
                    ref = new EjbRef();
                    ref.setType("Entity");
                    ref.setEjbName(name);
                    ref.setName("ejb/" + name);
                    ref.setEjbInterface(local);
                    ref.setEjbHomeInterface(localHome);
                    ref.setLocal(true);
                    this.cactusWar.addConfiguredEjbref(ref);
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not merge deployment descriptors", (Exception)e);
        }
    }

    private CactifyWarMojo createCactusWarConfig() {
        CactifyWarMojo cactusWarConfig = new CactifyWarMojo();
        Version version = new Version();
        version.setValue("2.3");
        cactusWarConfig.setVersion(version);
        cactusWarConfig.setContext("/cactus");
        cactusWarConfig.setWarArchiver(this.warArchiver);
        cactusWarConfig.setProject(this.getProject());
        return cactusWarConfig;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public MavenArchiveConfiguration getArchive() {
        return this.archive;
    }

    public File getDestFile() {
        return this.destFile;
    }

    public File getSrcFile() {
        return this.srcFile;
    }
}

