/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cactus.maven2.mojos;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.cactus.integration.api.cactify.CactifyUtils;
import org.apache.cactus.integration.api.version.Version;
import org.apache.cactus.maven2.mojos.Dependency;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.assembly.archive.ArchiveExpansionException;
import org.apache.maven.plugin.assembly.utils.AssemblyFileUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.tools.ant.types.XMLCatalog;
import org.codehaus.cargo.container.internal.util.ResourceUtils;
import org.codehaus.cargo.maven2.log.MavenLogger;
import org.codehaus.cargo.module.Descriptor;
import org.codehaus.cargo.module.J2eeDescriptor;
import org.codehaus.cargo.module.webapp.DefaultWarArchive;
import org.codehaus.cargo.module.webapp.EjbRef;
import org.codehaus.cargo.module.webapp.WebXml;
import org.codehaus.cargo.module.webapp.WebXmlIo;
import org.codehaus.cargo.module.webapp.WebXmlUtils;
import org.codehaus.cargo.module.webapp.WebXmlVersion;
import org.codehaus.cargo.module.webapp.merge.WebXmlMerger;
import org.codehaus.cargo.util.log.Logger;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.archiver.war.WarArchiver;
import org.codehaus.plexus.util.FileUtils;
import org.jdom.JDOMException;
import org.xml.sax.EntityResolver;

public class CactifyWarMojo
extends AbstractMojo {
    private String FILE_NAME = "cactus.war";
    private String context;
    private static Random rand = new Random(System.currentTimeMillis() + Runtime.getRuntime().freeMemory());
    private ArtifactFactory artifactFactory;
    private XMLCatalog xmlCatalog = null;
    private File srcFile;
    private FileSet testClasses;
    private WarArchiver warArchiver;
    private MavenProject project;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    private File mergeWebXml;
    private final List redirectors = new ArrayList();
    private final List ejbRefs = new ArrayList();
    private ResourceUtils utils = new ResourceUtils();
    private ArchiverManager archiverManager;
    private final List libDependencies = new ArrayList();
    private ArtifactFactory factory;
    protected ArtifactInstaller installer;
    private File destFile;
    protected ArtifactRepository localRepository;
    protected String groupId;
    protected String artifactId;
    protected String projectVersion;
    protected String version = null;
    protected String packaging;
    protected String classifier;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.srcFile != null) {
            this.getLog().info((CharSequence)("Analyzing war: " + this.srcFile.getAbsolutePath()));
        }
        WebXml webXml = null;
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver((JarArchiver)this.warArchiver);
        archiver.setOutputFile(this.destFile);
        File tmpWebXml = null;
        File tempLocation = null;
        try {
            try {
                WebXmlVersion webXmlVersion;
                if (this.srcFile != null) {
                    webXml = this.getOriginalWebXml();
                    if (webXml == null) {
                        if (this.version == null) {
                            throw new MojoExecutionException("Your source file does not contain a web.xml. Please provide a war with a web.xml or specify the [version] attribute.");
                        }
                        webXmlVersion = null;
                        webXmlVersion = this.version.equals("2.2") ? WebXmlVersion.V2_2 : (this.version.equals("2.3") ? WebXmlVersion.V2_3 : WebXmlVersion.V2_4);
                        webXml = WebXmlIo.newWebXml((WebXmlVersion)webXmlVersion);
                    }
                } else {
                    if (this.version == null) {
                        throw new MojoExecutionException("You need to specify either the [srcFile] or the [version] attribute");
                    }
                    webXmlVersion = null;
                    webXmlVersion = this.version.equals("2.2") ? WebXmlVersion.V2_2 : (this.version.equals("2.3") ? WebXmlVersion.V2_3 : WebXmlVersion.V2_4);
                    webXml = WebXmlIo.newWebXml((WebXmlVersion)webXmlVersion);
                }
                tmpWebXml = this.cactifyWebXml(webXml);
                this.addJarWithClass("org.aspectj.lang.JoinPoint", "AspectJ Runtime");
                this.addJarWithClass("org.apache.cactus.ServletTestCase", "Cactus Framework");
                this.addJarWithClass("org.apache.commons.logging.Log", "Commons-Logging");
                this.addJarWithClass("org.apache.commons.httpclient.HttpClient", "Commons-HttpClient");
                this.addJarWithClass("junit.framework.TestCase", "JUnit");
                tempLocation = this.createTempFile("cactus", "explode.tmp.dir", this.getProject().getBasedir(), true);
                tempLocation.mkdirs();
                tempLocation.deleteOnExit();
                if (this.testClasses != null) {
                    this.warArchiver.addClasses(new File(this.testClasses.getDirectory()), this.testClasses.getIncludesArray(), this.testClasses.getExcludesArray());
                }
                Iterator iter = this.libDependencies.iterator();
                while (iter.hasNext()) {
                    Dependency dependency = (Dependency)((Object)iter.next());
                    this.warArchiver.addLib(new File(dependency.getDependencyPath(this.project, this.getLog())));
                }
                try {
                    if (this.srcFile != null) {
                        AssemblyFileUtils.unpack((File)this.srcFile, (File)tempLocation, (ArchiverManager)this.archiverManager);
                    }
                }
                catch (ArchiveExpansionException e) {
                    throw new MojoExecutionException("Error extracting the archive.", (Exception)((Object)e));
                }
                catch (NoSuchArchiverException e) {
                    throw new MojoExecutionException("Problem reading the source archive.", (Exception)((Object)e));
                }
                this.warArchiver.addDirectory(tempLocation);
                this.warArchiver.setWebxml(tmpWebXml);
                archiver.createArchive(this.getProject(), this.getArchive());
            }
            catch (ArchiverException e) {
                throw new MojoExecutionException("Problem reading the source archive.", (Exception)((Object)e));
            }
            catch (JDOMException e) {
                throw new MojoExecutionException("Unable to cactify your web.xml.", (Exception)((Object)e));
            }
            catch (ManifestException e) {
                throw new MojoExecutionException("Problem reading the source archive.", (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Input/output error reading thesource archive.", (Exception)e);
            }
            catch (DependencyResolutionRequiredException e) {
                throw new MojoExecutionException("Error resolving your dependencies", (Exception)((Object)e));
            }
            Object var8_14 = null;
        }
        catch (Throwable throwable) {
            Object var8_15 = null;
            try {
                if (tempLocation == null) throw throwable;
                FileUtils.deleteDirectory(tempLocation);
                throw throwable;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error deleting temporary folder", (Exception)e);
            }
        }
        try {}
        catch (IOException e) {
            throw new MojoExecutionException("Error deleting temporary folder", (Exception)e);
        }
        if (tempLocation == null) return;
        FileUtils.deleteDirectory((File)tempLocation);
    }

    private File cactifyWebXml(WebXml theWebXml) throws JDOMException, MojoExecutionException {
        CactifyUtils utils = new CactifyUtils();
        utils.setLogger(this.createLogger());
        utils.addRedirectorDefinitions(theWebXml, this.redirectors);
        this.addJspRedirector();
        this.addEjbRefs(theWebXml);
        if (this.mergeWebXml != null) {
            try {
                WebXml parsedMergeWebXml = WebXmlIo.parseWebXmlFromFile((File)this.mergeWebXml, (EntityResolver)this.xmlCatalog);
                WebXmlMerger merger = new WebXmlMerger((Descriptor)theWebXml);
                merger.setLogger(utils.getLogger());
                merger.merge((Descriptor)parsedMergeWebXml);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not merge deployment descriptors", (Exception)e);
            }
        }
        File tmpDir = this.createTempFile("cactus", "tmp.dir", new File("."), true);
        tmpDir.mkdirs();
        tmpDir.deleteOnExit();
        File webXmlFile = null;
        try {
            tmpDir.mkdir();
            File[] files = WebXmlIo.writeAll((J2eeDescriptor)theWebXml, (String)tmpDir.getAbsolutePath());
            ArrayList<String> includes = new ArrayList<String>();
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                f.deleteOnExit();
                if (f.getName().equals("web.xml")) {
                    webXmlFile = f;
                    continue;
                }
                includes.add(f.getName());
            }
            String[] strIncludes = new String[includes.size()];
            int i = 0;
            Iterator iter = includes.iterator();
            while (iter.hasNext()) {
                strIncludes[i] = iter.next().toString();
                ++i;
            }
            try {
                this.warArchiver.addWebinf(tmpDir, strIncludes, null);
            }
            catch (ArchiverException e) {
                throw new MojoExecutionException("Error reading the source archive.", (Exception)((Object)e));
            }
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Could not write temporary deployment descriptor", (Exception)ioe);
        }
        return webXmlFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createTempFile(String thePrefix, String theSuffix, File theParentDir, boolean isDeleteOnExit) {
        File result = null;
        String parent = theParentDir == null ? System.getProperty("java.io.tmpdir") : theParentDir.getPath();
        DecimalFormat fmt = new DecimalFormat("#####");
        Random random = rand;
        synchronized (random) {
            while ((result = new File(parent, thePrefix + fmt.format(Math.abs(rand.nextInt())) + theSuffix)).exists()) {
            }
        }
        if (isDeleteOnExit) {
            result.deleteOnExit();
        }
        return result;
    }

    private void addJspRedirector() throws MojoExecutionException {
        File jspRedirectorFile = new File(new File(System.getProperty("java.io.tmpdir")), "jspRedirector.jsp");
        jspRedirectorFile.deleteOnExit();
        try {
            this.utils.copyResource("/org/apache/cactus/server/jspRedirector.jsp", jspRedirectorFile);
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("Could not copy the JSP redirector (" + e.getMessage() + ")"));
        }
        try {
            this.warArchiver.addFile(jspRedirectorFile, jspRedirectorFile.getName());
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Failed to add jsp redirector", (Exception)((Object)e));
        }
    }

    private File addJarWithClass(String theClassName, String theDescription) throws ArchiverException {
        File file;
        String resourceName = "/" + theClassName.replace('.', '/') + ".class";
        if (this.srcFile != null) {
            try {
                DefaultWarArchive srcWar = new DefaultWarArchive((InputStream)new FileInputStream(this.srcFile));
                this.getLog().info((CharSequence)"Inspecting..");
                if (srcWar.containsClass(theClassName)) {
                    this.getLog().info((CharSequence)("The " + theDescription + " JAR is " + "already present in the WAR. Will skip."));
                    return null;
                }
            }
            catch (IOException ioe) {
                this.getLog().warn((CharSequence)("Problem reading source WAR to when trying to detect already present JAR files (" + ioe + ")"));
            }
        }
        if ((file = this.utils.getResourceLocation(resourceName)) != null) {
            this.getLog().info((CharSequence)("Adding: " + file.getName()));
            this.warArchiver.addLib(file);
        }
        return file;
    }

    private WebXml getOriginalWebXml() throws MojoExecutionException, JDOMException {
        DefaultWarArchive war = null;
        try {
            war = new DefaultWarArchive((InputStream)new FileInputStream(this.srcFile));
            WebXml webXml = war.getWebXml();
            return webXml;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to get the original web.xml", (Exception)e);
        }
    }

    private void addEjbRefs(WebXml theWebXml) {
        Iterator i = this.ejbRefs.iterator();
        while (i.hasNext()) {
            EjbRef ref = (EjbRef)i.next();
            WebXmlUtils.addEjbRef((WebXml)theWebXml, (EjbRef)ref);
        }
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject theProject) {
        this.project = theProject;
    }

    public MavenArchiveConfiguration getArchive() {
        return this.archive;
    }

    protected Logger createLogger() {
        MavenLogger logger = new MavenLogger(this.getLog());
        return logger;
    }

    public String getContext() {
        return this.context;
    }

    public File getSrcFile() {
        return this.srcFile;
    }

    public void setContext(String theContext) {
        this.context = theContext;
    }

    public final void setVersion(Version theVersion) {
        this.version = theVersion.getValue();
    }

    public final void setSrcFile(File theSrcFile) {
        this.srcFile = theSrcFile;
    }

    public String getFileName() {
        return this.FILE_NAME;
    }

    public void setDestFile(File theDestFile) {
        this.destFile = theDestFile;
    }

    public final void addConfiguredEjbref(EjbRef theEjbRef) {
        this.ejbRefs.add(theEjbRef);
    }

    public void setWarArchiver(WarArchiver theWarArchiver) {
        this.warArchiver = theWarArchiver;
    }
}

