/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.server;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ThreadFactory;
import javax.security.auth.Subject;

class SubjectPreservingPrivilegedThreadFactory
implements ThreadFactory {
    SubjectPreservingPrivilegedThreadFactory() {
    }

    @Override
    public Thread newThread(final Runnable runnable) {
        final Subject subject = Subject.getSubject(AccessController.getContext());
        return AccessController.doPrivileged(new PrivilegedAction<Thread>(){

            @Override
            public Thread run() {
                return Subject.doAs(subject, new PrivilegedAction<Thread>(){

                    @Override
                    public Thread run() {
                        Thread thread = new Thread(runnable);
                        thread.setDaemon(true);
                        thread.setName("avatica_qtp" + this.hashCode() + "-" + thread.getId());
                        thread.setContextClassLoader(this.getClass().getClassLoader());
                        return thread;
                    }
                });
            }
        });
    }
}

