/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.server;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.calcite.avatica.remote.JsonHandler;
import org.apache.calcite.avatica.remote.Service;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class AvaticaHandler
extends AbstractHandler {
    private static final Log LOG = LogFactory.getLog(AvaticaHandler.class);
    final JsonHandler jsonHandler;

    public AvaticaHandler(Service service) {
        this.jsonHandler = new JsonHandler(service);
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("text/html;charset=utf-8");
        response.setStatus(200);
        if (request.getMethod().equals("POST")) {
            String jsonRequest = request.getHeader("request");
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("request: " + jsonRequest));
            }
            String jsonResponse = this.jsonHandler.apply(jsonRequest);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("response: " + jsonResponse));
            }
            baseRequest.setHandled(true);
            response.getWriter().println(jsonResponse);
        }
    }
}

