/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.calcite.avatica.remote.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JsonService
implements Service {
    protected static final ObjectMapper MAPPER = new ObjectMapper();

    public abstract String apply(String var1);

    private <T> T decode(String response, Class<T> valueType) throws IOException {
        return (T)MAPPER.readValue(response, valueType);
    }

    private <T> String encode(T request) throws IOException {
        StringWriter w = new StringWriter();
        MAPPER.writeValue((Writer)w, request);
        return w.toString();
    }

    protected RuntimeException handle(IOException e) {
        return new RuntimeException(e);
    }

    @Override
    public Service.ResultSetResponse apply(Service.CatalogsRequest request) {
        try {
            return this.decode(this.apply(this.encode(request)), Service.ResultSetResponse.class);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.ResultSetResponse apply(Service.SchemasRequest request) {
        try {
            return this.decode(this.apply(this.encode(request)), Service.ResultSetResponse.class);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.PrepareResponse apply(Service.PrepareRequest request) {
        try {
            return this.decode(this.apply(this.encode(request)), Service.PrepareResponse.class);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.ResultSetResponse apply(Service.PrepareAndExecuteRequest request) {
        try {
            return this.decode(this.apply(this.encode(request)), Service.ResultSetResponse.class);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.CreateStatementResponse apply(Service.CreateStatementRequest request) {
        try {
            return this.decode(this.apply(this.encode(request)), Service.CreateStatementResponse.class);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    static {
        MAPPER.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        MAPPER.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
    }
}

