/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.cassandra;

import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.calcite.sql.type.SqlTypeName;

public class CqlToSqlTypeConversionRules {
    private static final CqlToSqlTypeConversionRules INSTANCE = new CqlToSqlTypeConversionRules();
    private final Map<DataType, SqlTypeName> rules = ImmutableMap.builder().put((Object)DataTypes.UUID, (Object)SqlTypeName.CHAR).put((Object)DataTypes.TIMEUUID, (Object)SqlTypeName.CHAR).put((Object)DataTypes.ASCII, (Object)SqlTypeName.VARCHAR).put((Object)DataTypes.TEXT, (Object)SqlTypeName.VARCHAR).put((Object)DataTypes.INT, (Object)SqlTypeName.INTEGER).put((Object)DataTypes.VARINT, (Object)SqlTypeName.INTEGER).put((Object)DataTypes.BIGINT, (Object)SqlTypeName.BIGINT).put((Object)DataTypes.TINYINT, (Object)SqlTypeName.TINYINT).put((Object)DataTypes.SMALLINT, (Object)SqlTypeName.SMALLINT).put((Object)DataTypes.DOUBLE, (Object)SqlTypeName.DOUBLE).put((Object)DataTypes.FLOAT, (Object)SqlTypeName.REAL).put((Object)DataTypes.DECIMAL, (Object)SqlTypeName.DOUBLE).put((Object)DataTypes.BLOB, (Object)SqlTypeName.VARBINARY).put((Object)DataTypes.BOOLEAN, (Object)SqlTypeName.BOOLEAN).put((Object)DataTypes.COUNTER, (Object)SqlTypeName.BIGINT).put((Object)DataTypes.TIME, (Object)SqlTypeName.BIGINT).put((Object)DataTypes.DATE, (Object)SqlTypeName.DATE).put((Object)DataTypes.TIMESTAMP, (Object)SqlTypeName.TIMESTAMP).build();

    public static CqlToSqlTypeConversionRules instance() {
        return INSTANCE;
    }

    public SqlTypeName lookup(DataType name) {
        return this.rules.getOrDefault(name, SqlTypeName.ANY);
    }
}

