/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.csv;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.csv.CsvEnumerator;
import org.apache.calcite.adapter.csv.CsvFieldType;
import org.apache.calcite.adapter.csv.CsvScannableTable;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.StreamableTable;
import org.apache.calcite.schema.Table;
import org.apache.calcite.util.Source;

public class CsvStreamScannableTable
extends CsvScannableTable
implements StreamableTable {
    CsvStreamScannableTable(Source source, RelProtoDataType protoRowType) {
        super(source, protoRowType);
    }

    @Override
    protected boolean isStream() {
        return true;
    }

    @Override
    public String toString() {
        return "CsvStreamScannableTable";
    }

    @Override
    public Enumerable<Object[]> scan(DataContext root) {
        final List<CsvFieldType> fieldTypes = this.getFieldTypes((RelDataTypeFactory)root.getTypeFactory());
        final int[] fields = CsvEnumerator.identityList(fieldTypes.size());
        final AtomicBoolean cancelFlag = (AtomicBoolean)DataContext.Variable.CANCEL_FLAG.get(root);
        return new AbstractEnumerable<Object[]>(){

            public Enumerator<Object[]> enumerator() {
                return new CsvEnumerator<Object[]>(CsvStreamScannableTable.this.source, cancelFlag, true, null, new CsvEnumerator.ArrayRowConverter(fieldTypes, fields, true));
            }
        };
    }

    public Table stream() {
        return this;
    }
}

