/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.csv;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.csv.CsvTable;
import org.apache.calcite.adapter.file.CsvEnumerator;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.FilterableTable;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Source;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CsvFilterableTable
extends CsvTable
implements FilterableTable {
    public CsvFilterableTable(Source source, @Nullable RelProtoDataType protoRowType) {
        super(source, protoRowType);
    }

    public String toString() {
        return "CsvFilterableTable";
    }

    public Enumerable<@Nullable Object[]> scan(DataContext root, List<RexNode> filters) {
        JavaTypeFactory typeFactory = root.getTypeFactory();
        final List<RelDataType> fieldTypes = this.getFieldTypes((RelDataTypeFactory)typeFactory);
        final @Nullable String[] filterValues = new String[fieldTypes.size()];
        filters.removeIf(filter -> CsvFilterableTable.addFilter(filter, filterValues));
        ImmutableIntList fields = ImmutableIntList.identity((int)fieldTypes.size());
        final AtomicBoolean cancelFlag = (AtomicBoolean)DataContext.Variable.CANCEL_FLAG.get(root);
        return new AbstractEnumerable<Object[]>((List)fields){
            final /* synthetic */ List val$fields;
            {
                this.val$fields = list2;
            }

            public Enumerator<@Nullable Object[]> enumerator() {
                return new CsvEnumerator(CsvFilterableTable.this.source, cancelFlag, false, filterValues, CsvEnumerator.arrayConverter((List)fieldTypes, (List)this.val$fields, (boolean)false));
            }
        };
    }

    private static boolean addFilter(RexNode filter, @Nullable Object[] filterValues) {
        if (filter.isA(SqlKind.AND)) {
            ((RexCall)filter).getOperands().forEach(subFilter -> CsvFilterableTable.addFilter(subFilter, filterValues));
        } else if (filter.isA(SqlKind.EQUALS)) {
            int index;
            RexCall call = (RexCall)filter;
            RexNode left = (RexNode)call.getOperands().get(0);
            if (left.isA(SqlKind.CAST)) {
                left = (RexNode)((RexCall)left).operands.get(0);
            }
            RexNode right = (RexNode)call.getOperands().get(1);
            if (left instanceof RexInputRef && right instanceof RexLiteral && filterValues[index = ((RexInputRef)left).getIndex()] == null) {
                filterValues[index] = ((RexLiteral)right).getValue2().toString();
                return true;
            }
        }
        return false;
    }
}

