/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.csv;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.adapter.file.CsvEnumerator;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.calcite.util.Source;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class CsvTable
extends AbstractTable {
    protected final Source source;
    protected final @Nullable RelProtoDataType protoRowType;
    private @Nullable RelDataType rowType;
    private @Nullable List<RelDataType> fieldTypes;

    CsvTable(Source source, @Nullable RelProtoDataType protoRowType) {
        this.source = source;
        this.protoRowType = protoRowType;
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        if (this.protoRowType != null) {
            return (RelDataType)this.protoRowType.apply((Object)typeFactory);
        }
        if (this.rowType == null) {
            this.rowType = CsvEnumerator.deduceRowType((JavaTypeFactory)((JavaTypeFactory)typeFactory), (Source)this.source, null, (Boolean)this.isStream());
        }
        return this.rowType;
    }

    public List<RelDataType> getFieldTypes(RelDataTypeFactory typeFactory) {
        if (this.fieldTypes == null) {
            this.fieldTypes = new ArrayList<RelDataType>();
            CsvEnumerator.deduceRowType((JavaTypeFactory)((JavaTypeFactory)typeFactory), (Source)this.source, this.fieldTypes, (Boolean)this.isStream());
        }
        return this.fieldTypes;
    }

    protected boolean isStream() {
        return false;
    }

    public static enum Flavor {
        SCANNABLE,
        FILTERABLE,
        TRANSLATABLE;

    }
}

