/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.test.CalciteAssert;
import org.apache.calcite.util.Util;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class DruidAdapterIT {
    public static final URL FOODMART = DruidAdapterIT.class.getResource("/druid-foodmart-model.json");
    public static final URL WIKI = DruidAdapterIT.class.getResource("/druid-wiki-model.json");
    public static final URL WIKI_AUTO = DruidAdapterIT.class.getResource("/druid-wiki-no-columns-model.json");
    public static final URL WIKI_AUTO2 = DruidAdapterIT.class.getResource("/druid-wiki-no-tables-model.json");
    public static final boolean ENABLED = Util.getBooleanProperty((String)"calcite.test.druid", (boolean)true);

    protected boolean enabled() {
        return ENABLED;
    }

    private static Function<List, Void> druidChecker(final String ... lines) {
        return new Function<List, Void>(){

            public Void apply(List list) {
                Assert.assertThat((Object)list.size(), (Matcher)CoreMatchers.is((Object)1));
                DruidQuery.QuerySpec querySpec = (DruidQuery.QuerySpec)list.get(0);
                for (String line : lines) {
                    String s = line.replace('\'', '\"');
                    Assert.assertThat((Object)querySpec.getQueryString(null, -1), (Matcher)CoreMatchers.containsString((String)s));
                }
                return null;
            }
        };
    }

    private CalciteAssert.AssertQuery sql(String sql, URL url) {
        return CalciteAssert.that().enable(this.enabled()).with((Map)ImmutableMap.of((Object)"model", (Object)url.getPath())).query(sql);
    }

    private CalciteAssert.AssertQuery sql(String sql) {
        return this.sql(sql, FOODMART);
    }

    @Test
    public void testSelectDistinctWiki() {
        String explain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[wiki, wiki]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[=(CAST($13):VARCHAR(13) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\", 'Jeremy Corbyn')], groups=[{5}], aggs=[[]])\n";
        this.checkSelectDistinctWiki(WIKI, "wiki").explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[wiki, wiki]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[=(CAST($13):VARCHAR(13) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\", 'Jeremy Corbyn')], groups=[{5}], aggs=[[]])\n");
    }

    @Test
    public void testSelectDistinctWikiNoColumns() {
        String explain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[wiki, wiki]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[=(CAST($17):VARCHAR(13) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\", 'Jeremy Corbyn')], groups=[{7}], aggs=[[]])\n";
        this.checkSelectDistinctWiki(WIKI_AUTO, "wiki").explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[wiki, wiki]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[=(CAST($17):VARCHAR(13) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\", 'Jeremy Corbyn')], groups=[{7}], aggs=[[]])\n");
    }

    @Test
    public void testSelectDistinctWikiNoTables() {
        String sql = "select distinct \"countryName\"\nfrom \"wikiticker\"\nwhere \"page\" = 'Jeremy Corbyn'";
        String explain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[wiki, wikiticker]], intervals=[[1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z]], filter=[=(CAST($17):VARCHAR(13) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\", 'Jeremy Corbyn')], groups=[{7}], aggs=[[]])\n";
        String druidQuery = "{'queryType':'groupBy','dataSource':'wikiticker','granularity':'all','dimensions':['countryName'],'limitSpec':{'type':'default'},'filter':{'type':'selector','dimension':'page','value':'Jeremy Corbyn'},'aggregations':[{'type':'longSum','name':'dummy_agg','fieldName':'dummy_agg'}],'intervals':['1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z']}";
        this.sql("select distinct \"countryName\"\nfrom \"wikiticker\"\nwhere \"page\" = 'Jeremy Corbyn'", WIKI_AUTO2).returnsUnordered(new String[]{"countryName=United Kingdom", "countryName=null"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[wiki, wikiticker]], intervals=[[1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z]], filter=[=(CAST($17):VARCHAR(13) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\", 'Jeremy Corbyn')], groups=[{7}], aggs=[[]])\n").queryContains(DruidAdapterIT.druidChecker("{'queryType':'groupBy','dataSource':'wikiticker','granularity':'all','dimensions':['countryName'],'limitSpec':{'type':'default'},'filter':{'type':'selector','dimension':'page','value':'Jeremy Corbyn'},'aggregations':[{'type':'longSum','name':'dummy_agg','fieldName':'dummy_agg'}],'intervals':['1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z']}"));
        this.sql("select count(*) as c from \"foodmart\"", WIKI_AUTO2).returnsUnordered(new String[]{"C=86829"});
    }

    @Test
    public void testSelectTimestampColumnNoTables1() {
        String sql = "select sum(\"added\")\nfrom \"wikiticker\"\ngroup by floor(\"__time\" to DAY)";
        String explain = "PLAN=EnumerableInterpreter\n  BindableProject(EXPR$0=[$1])\n    DruidQuery(table=[[wiki, wikiticker]], intervals=[[1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z]], projects=[[FLOOR($0, FLAG(DAY)), $1]], groups=[{0}], aggs=[[SUM($1)]])\n";
        String druidQuery = "{'queryType':'timeseries','dataSource':'wikiticker','descending':false,'granularity':'DAY','aggregations':[{'type':'longSum','name':'EXPR$0','fieldName':'added'}],'intervals':['1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z']}";
        this.sql("select sum(\"added\")\nfrom \"wikiticker\"\ngroup by floor(\"__time\" to DAY)", WIKI_AUTO2).explainContains("PLAN=EnumerableInterpreter\n  BindableProject(EXPR$0=[$1])\n    DruidQuery(table=[[wiki, wikiticker]], intervals=[[1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z]], projects=[[FLOOR($0, FLAG(DAY)), $1]], groups=[{0}], aggs=[[SUM($1)]])\n").queryContains(DruidAdapterIT.druidChecker("{'queryType':'timeseries','dataSource':'wikiticker','descending':false,'granularity':'DAY','aggregations':[{'type':'longSum','name':'EXPR$0','fieldName':'added'}],'intervals':['1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z']}"));
    }

    @Test
    public void testSelectTimestampColumnNoTables2() {
        String sql = "select \"__time\"\nfrom \"wikiticker\"\nlimit 1\n";
        String explain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[wiki, wikiticker]], intervals=[[1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z]], projects=[[$0]], fetch=[1])\n";
        String druidQuery = "{'queryType':'select','dataSource':'wikiticker','descending':false,'intervals':['1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z'],'dimensions':[],'metrics':[],'granularity':'all','pagingSpec':{'threshold':1},'context':{'druid.query.fetch':true}}";
        this.sql("select \"__time\"\nfrom \"wikiticker\"\nlimit 1\n", WIKI_AUTO2).returnsUnordered(new String[]{"__time=2015-09-12 00:46:58"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[wiki, wikiticker]], intervals=[[1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z]], projects=[[$0]], fetch=[1])\n").queryContains(DruidAdapterIT.druidChecker("{'queryType':'select','dataSource':'wikiticker','descending':false,'intervals':['1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z'],'dimensions':[],'metrics':[],'granularity':'all','pagingSpec':{'threshold':1},'context':{'druid.query.fetch':true}}"));
    }

    @Test
    public void testSelectTimestampColumnNoTables3() {
        String sql = "select floor(\"__time\" to DAY) as \"day\", sum(\"added\")\nfrom \"wikiticker\"\ngroup by floor(\"__time\" to DAY)";
        String explain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[wiki, wikiticker]], intervals=[[1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z]], projects=[[FLOOR($0, FLAG(DAY)), $1]], groups=[{0}], aggs=[[SUM($1)]])\n";
        String druidQuery = "{'queryType':'timeseries','dataSource':'wikiticker','descending':false,'granularity':'DAY','aggregations':[{'type':'longSum','name':'EXPR$1','fieldName':'added'}],'intervals':['1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z']}";
        this.sql("select floor(\"__time\" to DAY) as \"day\", sum(\"added\")\nfrom \"wikiticker\"\ngroup by floor(\"__time\" to DAY)", WIKI_AUTO2).returnsUnordered(new String[]{"day=2015-09-12 00:00:00; EXPR$1=9385573"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[wiki, wikiticker]], intervals=[[1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z]], projects=[[FLOOR($0, FLAG(DAY)), $1]], groups=[{0}], aggs=[[SUM($1)]])\n").queryContains(DruidAdapterIT.druidChecker("{'queryType':'timeseries','dataSource':'wikiticker','descending':false,'granularity':'DAY','aggregations':[{'type':'longSum','name':'EXPR$1','fieldName':'added'}],'intervals':['1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z']}"));
    }

    @Test
    public void testSelectTimestampColumnNoTables4() {
        String sql = "select sum(\"added\") as \"s\", \"page\", floor(\"__time\" to DAY) as \"day\"\nfrom \"wikiticker\"\ngroup by \"page\", floor(\"__time\" to DAY)\norder by \"s\" desc";
        String explain = "PLAN=EnumerableInterpreter\n  BindableSort(sort0=[$0], dir0=[DESC])\n    BindableProject(s=[$2], page=[$0], day=[$1])\n      DruidQuery(table=[[wiki, wikiticker]], intervals=[[1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z]], projects=[[$17, FLOOR($0, FLAG(DAY)), $1]], groups=[{0, 1}], aggs=[[SUM($2)]])\n";
        String druidQuery = "{'queryType':'groupBy','dataSource':'wikiticker','granularity':'DAY','dimensions':['page'],'limitSpec':{'type':'default'},'aggregations':[{'type':'longSum','name':'s','fieldName':'added'}],'intervals':['1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z']}";
        this.sql("select sum(\"added\") as \"s\", \"page\", floor(\"__time\" to DAY) as \"day\"\nfrom \"wikiticker\"\ngroup by \"page\", floor(\"__time\" to DAY)\norder by \"s\" desc", WIKI_AUTO2).limit(1).returnsUnordered(new String[]{"s=199818; page=User:QuackGuru/Electronic cigarettes 1; day=2015-09-12 00:00:00"}).explainContains("PLAN=EnumerableInterpreter\n  BindableSort(sort0=[$0], dir0=[DESC])\n    BindableProject(s=[$2], page=[$0], day=[$1])\n      DruidQuery(table=[[wiki, wikiticker]], intervals=[[1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z]], projects=[[$17, FLOOR($0, FLAG(DAY)), $1]], groups=[{0, 1}], aggs=[[SUM($2)]])\n").queryContains(DruidAdapterIT.druidChecker("{'queryType':'groupBy','dataSource':'wikiticker','granularity':'DAY','dimensions':['page'],'limitSpec':{'type':'default'},'aggregations':[{'type':'longSum','name':'s','fieldName':'added'}],'intervals':['1900-01-01T00:00:00.000Z/3000-01-01T00:00:00.000Z']}"));
    }

    private CalciteAssert.AssertQuery checkSelectDistinctWiki(URL url, String tableName) {
        String sql = "select distinct \"countryName\"\nfrom \"" + tableName + "\"\nwhere \"page\" = 'Jeremy Corbyn'";
        String druidQuery = "{'queryType':'groupBy','dataSource':'wikiticker','granularity':'all','dimensions':['countryName'],'limitSpec':{'type':'default'},'filter':{'type':'selector','dimension':'page','value':'Jeremy Corbyn'},'aggregations':[{'type':'longSum','name':'dummy_agg','fieldName':'dummy_agg'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}";
        return this.sql(sql, url).returnsUnordered(new String[]{"countryName=United Kingdom", "countryName=null"}).queryContains(DruidAdapterIT.druidChecker("{'queryType':'groupBy','dataSource':'wikiticker','granularity':'all','dimensions':['countryName'],'limitSpec':{'type':'default'},'filter':{'type':'selector','dimension':'page','value':'Jeremy Corbyn'},'aggregations':[{'type':'longSum','name':'dummy_agg','fieldName':'dummy_agg'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}"));
    }

    @Test
    public void testSelectDistinct() {
        String explain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{30}], aggs=[[]])";
        String sql = "select distinct \"state_province\" from \"foodmart\"";
        String druidQuery = "{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':['state_province'],'limitSpec':{'type':'default'},'aggregations':[{'type':'longSum','name':'dummy_agg','fieldName':'dummy_agg'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}";
        this.sql("select distinct \"state_province\" from \"foodmart\"").returnsUnordered(new String[]{"state_province=CA", "state_province=OR", "state_province=WA"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{30}], aggs=[[]])").queryContains(DruidAdapterIT.druidChecker("{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':['state_province'],'limitSpec':{'type':'default'},'aggregations':[{'type':'longSum','name':'dummy_agg','fieldName':'dummy_agg'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}"));
    }

    @Ignore(value="TODO: fix invalid cast from Integer to Long")
    @Test
    public void testSelectGroupBySum() {
        String explain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], projects=[[$29, CAST($88):INTEGER]], groups=[{0}], aggs=[[SUM($1)]])";
        String sql = "select \"state_province\", sum(cast(\"unit_sales\" as integer)) as u\nfrom \"foodmart\"\ngroup by \"state_province\"";
        this.sql("select \"state_province\", sum(cast(\"unit_sales\" as integer)) as u\nfrom \"foodmart\"\ngroup by \"state_province\"").returnsUnordered(new String[]{"state_province=CA; U=74748", "state_province=OR; U=67659", "state_province=WA; U=124366"}).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], projects=[[$29, CAST($88):INTEGER]], groups=[{0}], aggs=[[SUM($1)]])");
    }

    @Test
    public void testSelectCount() {
        String sql = "select count(*) as c from \"foodmart\"";
        this.sql("select count(*) as c from \"foodmart\"").returns((Function)new Function<ResultSet, Void>(){

            public Void apply(ResultSet input) {
                try {
                    Assert.assertThat((Object)input.next(), (Matcher)CoreMatchers.is((Object)true));
                    Assert.assertThat((Object)input.getInt(1), (Matcher)CoreMatchers.is((Object)86829));
                    Assert.assertThat((Object)input.getLong(1), (Matcher)CoreMatchers.is((Object)86829L));
                    Assert.assertThat((Object)input.getString(1), (Matcher)CoreMatchers.is((Object)"86829"));
                    Assert.assertThat((Object)input.wasNull(), (Matcher)CoreMatchers.is((Object)false));
                    Assert.assertThat((Object)input.next(), (Matcher)CoreMatchers.is((Object)false));
                    return null;
                }
                catch (SQLException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        });
    }

    @Test
    public void testSort() {
        String explain = "PLAN=EnumerableInterpreter\n  BindableSort(sort0=[$1], sort1=[$0], dir0=[ASC], dir1=[DESC])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$39, $30]], groups=[{0, 1}], aggs=[[]])";
        String sql = "select distinct \"gender\", \"state_province\"\nfrom \"foodmart\" order by 2, 1 desc";
        this.sql("select distinct \"gender\", \"state_province\"\nfrom \"foodmart\" order by 2, 1 desc").returnsOrdered(new String[]{"gender=M; state_province=CA", "gender=F; state_province=CA", "gender=M; state_province=OR", "gender=F; state_province=OR", "gender=M; state_province=WA", "gender=F; state_province=WA"}).explainContains("PLAN=EnumerableInterpreter\n  BindableSort(sort0=[$1], sort1=[$0], dir0=[ASC], dir1=[DESC])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$39, $30]], groups=[{0, 1}], aggs=[[]])");
    }

    @Test
    public void testSortLimit() {
        String explain = "PLAN=EnumerableInterpreter\n  BindableSort(sort0=[$1], sort1=[$0], dir0=[ASC], dir1=[DESC], offset=[2], fetch=[3])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$39, $30]], groups=[{0, 1}], aggs=[[]])";
        String sql = "select distinct \"gender\", \"state_province\"\nfrom \"foodmart\"\norder by 2, 1 desc offset 2 rows fetch next 3 rows only";
        this.sql("select distinct \"gender\", \"state_province\"\nfrom \"foodmart\"\norder by 2, 1 desc offset 2 rows fetch next 3 rows only").returnsOrdered(new String[]{"gender=M; state_province=OR", "gender=F; state_province=OR", "gender=M; state_province=WA"}).explainContains("PLAN=EnumerableInterpreter\n  BindableSort(sort0=[$1], sort1=[$0], dir0=[ASC], dir1=[DESC], offset=[2], fetch=[3])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$39, $30]], groups=[{0, 1}], aggs=[[]])");
    }

    @Test
    public void testOffsetLimit() {
        String sql = "select \"state_province\", \"product_name\"\nfrom \"foodmart\"\noffset 2 fetch next 3 rows only";
        String druidQuery = "{'queryType':'select','dataSource':'foodmart','descending':false,'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'dimensions':['state_province','product_name'],'metrics':[],'granularity':'all','pagingSpec':{'threshold':16384},'context':{'druid.query.fetch':false}}";
        this.sql("select \"state_province\", \"product_name\"\nfrom \"foodmart\"\noffset 2 fetch next 3 rows only").runs().queryContains(DruidAdapterIT.druidChecker("{'queryType':'select','dataSource':'foodmart','descending':false,'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'dimensions':['state_province','product_name'],'metrics':[],'granularity':'all','pagingSpec':{'threshold':16384},'context':{'druid.query.fetch':false}}"));
    }

    @Test
    public void testLimit() {
        String sql = "select \"gender\", \"state_province\"\nfrom \"foodmart\" fetch next 3 rows only";
        String druidQuery = "{'queryType':'select','dataSource':'foodmart','descending':false,'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'dimensions':['gender','state_province'],'metrics':[],'granularity':'all','pagingSpec':{'threshold':3},'context':{'druid.query.fetch':true}}";
        this.sql("select \"gender\", \"state_province\"\nfrom \"foodmart\" fetch next 3 rows only").runs().queryContains(DruidAdapterIT.druidChecker("{'queryType':'select','dataSource':'foodmart','descending':false,'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'dimensions':['gender','state_province'],'metrics':[],'granularity':'all','pagingSpec':{'threshold':3},'context':{'druid.query.fetch':true}}"));
    }

    @Test
    public void testGroupByLimit() {
        String sql = "select distinct \"gender\", \"state_province\"\nfrom \"foodmart\" fetch next 3 rows only";
        String druidQuery = "{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':['gender','state_province'],'limitSpec':{'type':'default'},'aggregations':[{'type':'longSum','name':'dummy_agg','fieldName':'dummy_agg'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}";
        String explain = "PLAN=EnumerableLimit(fetch=[3])\n  EnumerableInterpreter\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$39, $30]], groups=[{0, 1}], aggs=[[]])";
        this.sql("select distinct \"gender\", \"state_province\"\nfrom \"foodmart\" fetch next 3 rows only").runs().explainContains("PLAN=EnumerableLimit(fetch=[3])\n  EnumerableInterpreter\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$39, $30]], groups=[{0, 1}], aggs=[[]])").queryContains(DruidAdapterIT.druidChecker("{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':['gender','state_province'],'limitSpec':{'type':'default'},'aggregations':[{'type':'longSum','name':'dummy_agg','fieldName':'dummy_agg'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}"));
    }

    @Test
    public void testFilterSortDesc() {
        String sql = "select * from \"foodmart\"\nwhere \"product_id\" BETWEEN 1500 AND 1502\norder by \"state_province\" desc, \"product_id\"";
        String druidQuery = "{'queryType':'select','dataSource':'foodmart','descending':false,'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'filter':{'type':'and','fields':[{'type':'bound','dimension':'product_id','lower':'1500','lowerStrict':false,'alphaNumeric':false},{'type':'bound','dimension':'product_id','upper':'1502','upperStrict':false,'alphaNumeric':false}]},'dimensions':['product_id','brand_name','product_name','SKU','SRP','gross_weight','net_weight','recyclable_package','low_fat','units_per_case','cases_per_pallet','shelf_width','shelf_height','shelf_depth','product_class_id','product_subcategory','product_category','product_department','product_family','customer_id','account_num','lname','fname','mi','address1','address2','address3','address4','city','state_province','postal_code','country','customer_region_id','phone1','phone2','birthdate','marital_status','yearly_income','gender','total_children','num_children_at_home','education','date_accnt_opened','member_card','occupation','houseowner','num_cars_owned','fullname','promotion_id','promotion_district_id','promotion_name','media_type','cost','start_date','end_date','store_id','store_type','region_id','store_name','store_number','store_street_address','store_city','store_state','store_postal_code','store_country','store_manager','store_phone','store_fax','first_opened_date','last_remodel_date','store_sqft','grocery_sqft','frozen_sqft','meat_sqft','coffee_bar','video_store','salad_bar','prepared_food','florist','time_id','the_day','the_month','the_year','day_of_month','week_of_year','month_of_year','quarter','fiscal_period'],'metrics':['unit_sales','store_sales','store_cost'],'granularity':'all','pagingSpec':{'threshold':16384},'context':{'druid.query.fetch':false}}";
        this.sql("select * from \"foodmart\"\nwhere \"product_id\" BETWEEN 1500 AND 1502\norder by \"state_province\" desc, \"product_id\"").limit(4).returns((Function)new Function<ResultSet, Void>(){

            public Void apply(ResultSet resultSet) {
                try {
                    for (int i = 0; i < 4; ++i) {
                        Assert.assertTrue((boolean)resultSet.next());
                        Assert.assertThat((Object)resultSet.getString("product_name"), (Matcher)CoreMatchers.is((Object)"Fort West Dried Apricots"));
                    }
                    Assert.assertFalse((boolean)resultSet.next());
                    return null;
                }
                catch (SQLException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }).queryContains(DruidAdapterIT.druidChecker("{'queryType':'select','dataSource':'foodmart','descending':false,'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'filter':{'type':'and','fields':[{'type':'bound','dimension':'product_id','lower':'1500','lowerStrict':false,'alphaNumeric':false},{'type':'bound','dimension':'product_id','upper':'1502','upperStrict':false,'alphaNumeric':false}]},'dimensions':['product_id','brand_name','product_name','SKU','SRP','gross_weight','net_weight','recyclable_package','low_fat','units_per_case','cases_per_pallet','shelf_width','shelf_height','shelf_depth','product_class_id','product_subcategory','product_category','product_department','product_family','customer_id','account_num','lname','fname','mi','address1','address2','address3','address4','city','state_province','postal_code','country','customer_region_id','phone1','phone2','birthdate','marital_status','yearly_income','gender','total_children','num_children_at_home','education','date_accnt_opened','member_card','occupation','houseowner','num_cars_owned','fullname','promotion_id','promotion_district_id','promotion_name','media_type','cost','start_date','end_date','store_id','store_type','region_id','store_name','store_number','store_street_address','store_city','store_state','store_postal_code','store_country','store_manager','store_phone','store_fax','first_opened_date','last_remodel_date','store_sqft','grocery_sqft','frozen_sqft','meat_sqft','coffee_bar','video_store','salad_bar','prepared_food','florist','time_id','the_day','the_month','the_year','day_of_month','week_of_year','month_of_year','quarter','fiscal_period'],'metrics':['unit_sales','store_sales','store_cost'],'granularity':'all','pagingSpec':{'threshold':16384},'context':{'druid.query.fetch':false}}"));
    }

    @Test
    public void testFilterOutEverything() {
        String sql = "select * from \"foodmart\"\nwhere \"product_id\" = -1";
        String druidQuery = "{'queryType':'select','dataSource':'foodmart','descending':false,'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'filter':{'type':'selector','dimension':'product_id','value':'-1'},'dimensions':['product_id','brand_name','product_name','SKU','SRP','gross_weight','net_weight','recyclable_package','low_fat','units_per_case','cases_per_pallet','shelf_width','shelf_height','shelf_depth','product_class_id','product_subcategory','product_category','product_department','product_family','customer_id','account_num','lname','fname','mi','address1','address2','address3','address4','city','state_province','postal_code','country','customer_region_id','phone1','phone2','birthdate','marital_status','yearly_income','gender','total_children','num_children_at_home','education','date_accnt_opened','member_card','occupation','houseowner','num_cars_owned','fullname','promotion_id','promotion_district_id','promotion_name','media_type','cost','start_date','end_date','store_id','store_type','region_id','store_name','store_number','store_street_address','store_city','store_state','store_postal_code','store_country','store_manager','store_phone','store_fax','first_opened_date','last_remodel_date','store_sqft','grocery_sqft','frozen_sqft','meat_sqft','coffee_bar','video_store','salad_bar','prepared_food','florist','time_id','the_day','the_month','the_year','day_of_month','week_of_year','month_of_year','quarter','fiscal_period'],'metrics':['unit_sales','store_sales','store_cost'],'granularity':'all','pagingSpec':{'threshold':16384},'context':{'druid.query.fetch':false}}";
        this.sql("select * from \"foodmart\"\nwhere \"product_id\" = -1").limit(4).returnsUnordered(new String[0]).queryContains(DruidAdapterIT.druidChecker("{'queryType':'select','dataSource':'foodmart','descending':false,'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'filter':{'type':'selector','dimension':'product_id','value':'-1'},'dimensions':['product_id','brand_name','product_name','SKU','SRP','gross_weight','net_weight','recyclable_package','low_fat','units_per_case','cases_per_pallet','shelf_width','shelf_height','shelf_depth','product_class_id','product_subcategory','product_category','product_department','product_family','customer_id','account_num','lname','fname','mi','address1','address2','address3','address4','city','state_province','postal_code','country','customer_region_id','phone1','phone2','birthdate','marital_status','yearly_income','gender','total_children','num_children_at_home','education','date_accnt_opened','member_card','occupation','houseowner','num_cars_owned','fullname','promotion_id','promotion_district_id','promotion_name','media_type','cost','start_date','end_date','store_id','store_type','region_id','store_name','store_number','store_street_address','store_city','store_state','store_postal_code','store_country','store_manager','store_phone','store_fax','first_opened_date','last_remodel_date','store_sqft','grocery_sqft','frozen_sqft','meat_sqft','coffee_bar','video_store','salad_bar','prepared_food','florist','time_id','the_day','the_month','the_year','day_of_month','week_of_year','month_of_year','quarter','fiscal_period'],'metrics':['unit_sales','store_sales','store_cost'],'granularity':'all','pagingSpec':{'threshold':16384},'context':{'druid.query.fetch':false}}"));
    }

    @Test
    public void testNonPushableFilterSortDesc() {
        String sql = "select * from \"foodmart\"\nwhere cast(\"product_id\" as integer) - 1500 BETWEEN 0 AND 2\norder by \"state_province\" desc, \"product_id\"";
        String druidQuery = "{'queryType':'select','dataSource':'foodmart','descending':false,'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'dimensions':['product_id','brand_name','product_name','SKU','SRP','gross_weight','net_weight','recyclable_package','low_fat','units_per_case','cases_per_pallet','shelf_width','shelf_height','shelf_depth','product_class_id','product_subcategory','product_category','product_department','product_family','customer_id','account_num','lname','fname','mi','address1','address2','address3','address4','city','state_province','postal_code','country','customer_region_id','phone1','phone2','birthdate','marital_status','yearly_income','gender','total_children','num_children_at_home','education','date_accnt_opened','member_card','occupation','houseowner','num_cars_owned','fullname','promotion_id','promotion_district_id','promotion_name','media_type','cost','start_date','end_date','store_id','store_type','region_id','store_name','store_number','store_street_address','store_city','store_state','store_postal_code','store_country','store_manager','store_phone','store_fax','first_opened_date','last_remodel_date','store_sqft','grocery_sqft','frozen_sqft','meat_sqft','coffee_bar','video_store','salad_bar','prepared_food','florist','time_id','the_day','the_month','the_year','day_of_month','week_of_year','month_of_year','quarter','fiscal_period'],'metrics':['unit_sales','store_sales','store_cost'],'granularity':'all','pagingSpec':{'threshold':16384},'context':{'druid.query.fetch':false}}";
        this.sql("select * from \"foodmart\"\nwhere cast(\"product_id\" as integer) - 1500 BETWEEN 0 AND 2\norder by \"state_province\" desc, \"product_id\"").limit(4).returns((Function)new Function<ResultSet, Void>(){

            public Void apply(ResultSet resultSet) {
                try {
                    for (int i = 0; i < 4; ++i) {
                        Assert.assertTrue((boolean)resultSet.next());
                        Assert.assertThat((Object)resultSet.getString("product_name"), (Matcher)CoreMatchers.is((Object)"Fort West Dried Apricots"));
                    }
                    Assert.assertFalse((boolean)resultSet.next());
                    return null;
                }
                catch (SQLException e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        }).queryContains(DruidAdapterIT.druidChecker("{'queryType':'select','dataSource':'foodmart','descending':false,'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'dimensions':['product_id','brand_name','product_name','SKU','SRP','gross_weight','net_weight','recyclable_package','low_fat','units_per_case','cases_per_pallet','shelf_width','shelf_height','shelf_depth','product_class_id','product_subcategory','product_category','product_department','product_family','customer_id','account_num','lname','fname','mi','address1','address2','address3','address4','city','state_province','postal_code','country','customer_region_id','phone1','phone2','birthdate','marital_status','yearly_income','gender','total_children','num_children_at_home','education','date_accnt_opened','member_card','occupation','houseowner','num_cars_owned','fullname','promotion_id','promotion_district_id','promotion_name','media_type','cost','start_date','end_date','store_id','store_type','region_id','store_name','store_number','store_street_address','store_city','store_state','store_postal_code','store_country','store_manager','store_phone','store_fax','first_opened_date','last_remodel_date','store_sqft','grocery_sqft','frozen_sqft','meat_sqft','coffee_bar','video_store','salad_bar','prepared_food','florist','time_id','the_day','the_month','the_year','day_of_month','week_of_year','month_of_year','quarter','fiscal_period'],'metrics':['unit_sales','store_sales','store_cost'],'granularity':'all','pagingSpec':{'threshold':16384},'context':{'druid.query.fetch':false}}"));
    }

    @Test
    public void testUnionPlan() {
        String sql = "select distinct \"gender\" from \"foodmart\"\nunion all\nselect distinct \"marital_status\" from \"foodmart\"";
        String explain = "PLAN=EnumerableInterpreter\n  BindableUnion(all=[true])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{39}], aggs=[[]])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{37}], aggs=[[]])";
        this.sql("select distinct \"gender\" from \"foodmart\"\nunion all\nselect distinct \"marital_status\" from \"foodmart\"").explainContains("PLAN=EnumerableInterpreter\n  BindableUnion(all=[true])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{39}], aggs=[[]])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{37}], aggs=[[]])").returnsUnordered(new String[]{"gender=F", "gender=M", "gender=M", "gender=S"});
    }

    @Test
    public void testFilterUnionPlan() {
        String sql = "select * from (\n  select distinct \"gender\" from \"foodmart\"\n  union all\n  select distinct \"marital_status\" from \"foodmart\")\nwhere \"gender\" = 'M'";
        String explain = "PLAN=EnumerableInterpreter\n  BindableFilter(condition=[=($0, 'M')])\n    BindableUnion(all=[true])\n      DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{39}], aggs=[[]])\n      DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{37}], aggs=[[]])";
        this.sql("select * from (\n  select distinct \"gender\" from \"foodmart\"\n  union all\n  select distinct \"marital_status\" from \"foodmart\")\nwhere \"gender\" = 'M'").explainContains("PLAN=EnumerableInterpreter\n  BindableFilter(condition=[=($0, 'M')])\n    BindableUnion(all=[true])\n      DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{39}], aggs=[[]])\n      DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{37}], aggs=[[]])").returnsUnordered(new String[]{"gender=M", "gender=M"});
    }

    @Test
    public void testCountGroupByEmpty() {
        String druidQuery = "{'queryType':'timeseries','dataSource':'foodmart','descending':false,'granularity':'all','aggregations':[{'type':'count','name':'EXPR$0'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}";
        String explain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[]], groups=[{}], aggs=[[COUNT()]])";
        String sql = "select count(*) from \"foodmart\"";
        this.sql("select count(*) from \"foodmart\"").returns("EXPR$0=86829\n").queryContains(DruidAdapterIT.druidChecker("{'queryType':'timeseries','dataSource':'foodmart','descending':false,'granularity':'all','aggregations':[{'type':'count','name':'EXPR$0'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}")).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[]], groups=[{}], aggs=[[COUNT()]])");
    }

    @Test
    public void testGroupByOneColumnNotProjected() {
        String sql = "select count(*) as c from \"foodmart\"\ngroup by \"state_province\" order by 1";
        this.sql("select count(*) as c from \"foodmart\"\ngroup by \"state_province\" order by 1").returnsOrdered(new String[]{"C=21610", "C=24441", "C=40778"});
    }

    @Test
    public void testGroupByTimeAndOneColumnNotProjected() {
        String sql = "select count(*) as \"c\", floor(\"timestamp\" to MONTH) as \"month\"\nfrom \"foodmart\"\ngroup by floor(\"timestamp\" to MONTH), \"state_province\"\norder by \"c\" desc limit 3";
        this.sql("select count(*) as \"c\", floor(\"timestamp\" to MONTH) as \"month\"\nfrom \"foodmart\"\ngroup by floor(\"timestamp\" to MONTH), \"state_province\"\norder by \"c\" desc limit 3").returnsOrdered(new String[]{"c=3072; month=1997-01-01 00:00:00", "c=2231; month=1997-01-01 00:00:00", "c=1730; month=1997-01-01 00:00:00"}).queryContains(DruidAdapterIT.druidChecker("'queryType':'topN'"));
    }

    @Test
    public void testOrderByOneColumnNotProjected() {
        String sql = "select count(*) as c from \"foodmart\"\ngroup by \"state_province\" order by \"state_province\"";
        this.sql("select count(*) as c from \"foodmart\"\ngroup by \"state_province\" order by \"state_province\"").returnsOrdered(new String[]{"C=24441", "C=21610", "C=40778"});
    }

    @Test
    public void testGroupByOneColumn() {
        String sql = "select \"state_province\", count(*) as c\nfrom \"foodmart\"\ngroup by \"state_province\"\norder by \"state_province\"";
        String explain = "PLAN=EnumerableInterpreter\n  BindableSort(sort0=[$0], dir0=[ASC])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{30}], aggs=[[COUNT()]])";
        this.sql("select \"state_province\", count(*) as c\nfrom \"foodmart\"\ngroup by \"state_province\"\norder by \"state_province\"").limit(2).returnsOrdered(new String[]{"state_province=CA; C=24441", "state_province=OR; C=21610"}).explainContains(explain);
    }

    @Test
    public void testGroupByOneColumnReversed() {
        String sql = "select count(*) as c, \"state_province\"\nfrom \"foodmart\"\ngroup by \"state_province\"\norder by \"state_province\"";
        this.sql("select count(*) as c, \"state_province\"\nfrom \"foodmart\"\ngroup by \"state_province\"\norder by \"state_province\"").limit(2).returnsOrdered(new String[]{"C=24441; state_province=CA", "C=21610; state_province=OR"});
    }

    @Test
    public void testGroupByAvgSumCount() {
        String sql = "select \"state_province\",\n avg(\"unit_sales\") as a,\n sum(\"unit_sales\") as s,\n count(\"store_sqft\") as c,\n count(*) as c0\nfrom \"foodmart\"\ngroup by \"state_province\"\norder by 1";
        String druidQuery = "'aggregations':[{'type':'longSum','name':'$f1','fieldName':'unit_sales'},{'type':'count','name':'$f2','fieldName':'unit_sales'},{'type':'count','name':'C','fieldName':'store_sqft'},{'type':'count','name':'C0'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}";
        this.sql("select \"state_province\",\n avg(\"unit_sales\") as a,\n sum(\"unit_sales\") as s,\n count(\"store_sqft\") as c,\n count(*) as c0\nfrom \"foodmart\"\ngroup by \"state_province\"\norder by 1").limit(2).returnsUnordered(new String[]{"state_province=CA; A=3; S=74748; C=24441; C0=24441", "state_province=OR; A=3; S=67659; C=21610; C0=21610"}).queryContains(DruidAdapterIT.druidChecker(druidQuery));
    }

    @Test
    public void testGroupByMonthGranularity() {
        String sql = "select sum(\"unit_sales\") as s,\n count(\"store_sqft\") as c\nfrom \"foodmart\"\ngroup by floor(\"timestamp\" to MONTH)";
        String druidQuery = "{'queryType':'timeseries','dataSource':'foodmart','descending':false,'granularity':'MONTH','aggregations':[{'type':'longSum','name':'S','fieldName':'unit_sales'},{'type':'count','name':'C','fieldName':'store_sqft'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}";
        this.sql("select sum(\"unit_sales\") as s,\n count(\"store_sqft\") as c\nfrom \"foodmart\"\ngroup by floor(\"timestamp\" to MONTH)").limit(3).returnsUnordered(new String[]{"S=20957; C=6844", "S=21628; C=7033", "S=23706; C=7710"}).queryContains(DruidAdapterIT.druidChecker(druidQuery));
    }

    @Test
    public void testGroupByDayGranularity() {
        String sql = "select sum(\"unit_sales\") as s,\n count(\"store_sqft\") as c\nfrom \"foodmart\"\ngroup by floor(\"timestamp\" to DAY)";
        String druidQuery = "{'queryType':'timeseries','dataSource':'foodmart','descending':false,'granularity':'DAY','aggregations':[{'type':'longSum','name':'S','fieldName':'unit_sales'},{'type':'count','name':'C','fieldName':'store_sqft'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}";
        this.sql("select sum(\"unit_sales\") as s,\n count(\"store_sqft\") as c\nfrom \"foodmart\"\ngroup by floor(\"timestamp\" to DAY)").limit(3).returnsUnordered(new String[]{"S=348; C=117", "S=589; C=189", "S=635; C=206"}).queryContains(DruidAdapterIT.druidChecker(druidQuery));
    }

    @Test
    public void testGroupByMonthGranularityFiltered() {
        String sql = "select sum(\"unit_sales\") as s,\n count(\"store_sqft\") as c\nfrom \"foodmart\"\nwhere \"timestamp\" >= '1996-01-01 00:00:00' and  \"timestamp\" < '1998-01-01 00:00:00'\ngroup by floor(\"timestamp\" to MONTH)";
        String druidQuery = "{'queryType':'timeseries','dataSource':'foodmart','descending':false,'granularity':'MONTH','aggregations':[{'type':'longSum','name':'S','fieldName':'unit_sales'},{'type':'count','name':'C','fieldName':'store_sqft'}],'intervals':['1996-01-01T00:00:00.000Z/1998-01-01T00:00:00.000Z']}";
        this.sql("select sum(\"unit_sales\") as s,\n count(\"store_sqft\") as c\nfrom \"foodmart\"\nwhere \"timestamp\" >= '1996-01-01 00:00:00' and  \"timestamp\" < '1998-01-01 00:00:00'\ngroup by floor(\"timestamp\" to MONTH)").limit(3).returnsUnordered(new String[]{"S=20957; C=6844", "S=21628; C=7033", "S=23706; C=7710"}).queryContains(DruidAdapterIT.druidChecker(druidQuery));
    }

    @Test
    public void testTopNMonthGranularity() {
        String sql = "select sum(\"unit_sales\") as s,\nmax(\"unit_sales\") as m,\n\"state_province\" as p\nfrom \"foodmart\"\ngroup by \"state_province\", floor(\"timestamp\" to MONTH)\norder by s desc limit 3";
        String explain = "PLAN=EnumerableInterpreter\n  BindableProject(S=[$2], M=[$3], P=[$0])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$30, FLOOR($0, FLAG(MONTH)), $89]], groups=[{0, 1}], aggs=[[SUM($2), MAX($2)]], sort0=[2], dir0=[DESC], fetch=[3])";
        String druidQuery = "{'queryType':'topN','dataSource':'foodmart','granularity':'MONTH','dimension':'state_province','metric':'S','aggregations':[{'type':'longSum','name':'S','fieldName':'unit_sales'},{'type':'longMax','name':'M','fieldName':'unit_sales'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'threshold':3}";
        this.sql("select sum(\"unit_sales\") as s,\nmax(\"unit_sales\") as m,\n\"state_province\" as p\nfrom \"foodmart\"\ngroup by \"state_province\", floor(\"timestamp\" to MONTH)\norder by s desc limit 3").returnsOrdered(new String[]{"S=9342; M=6; P=WA", "S=6909; M=6; P=OR", "S=5377; M=7; P=CA"}).explainContains("PLAN=EnumerableInterpreter\n  BindableProject(S=[$2], M=[$3], P=[$0])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$30, FLOOR($0, FLAG(MONTH)), $89]], groups=[{0, 1}], aggs=[[SUM($2), MAX($2)]], sort0=[2], dir0=[DESC], fetch=[3])").queryContains(DruidAdapterIT.druidChecker("{'queryType':'topN','dataSource':'foodmart','granularity':'MONTH','dimension':'state_province','metric':'S','aggregations':[{'type':'longSum','name':'S','fieldName':'unit_sales'},{'type':'longMax','name':'M','fieldName':'unit_sales'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'threshold':3}"));
    }

    @Test
    public void testTopNDayGranularityFiltered() {
        String sql = "select sum(\"unit_sales\") as s,\nmax(\"unit_sales\") as m,\n\"state_province\" as p\nfrom \"foodmart\"\nwhere \"timestamp\" >= '1997-01-01 00:00:00' and  \"timestamp\" < '1997-09-01 00:00:00'\ngroup by \"state_province\", floor(\"timestamp\" to DAY)\norder by s desc limit 3";
        String explain = "PLAN=EnumerableInterpreter\n  BindableProject(S=[$2], M=[$3], P=[$0])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1997-01-01T00:00:00.000Z/1997-09-01T00:00:00.000Z]], projects=[[$30, FLOOR($0, FLAG(DAY)), $89]], groups=[{0, 1}], aggs=[[SUM($2), MAX($2)]], sort0=[2], dir0=[DESC], fetch=[3])";
        String druidQuery = "{'queryType':'topN','dataSource':'foodmart','granularity':'DAY','dimension':'state_province','metric':'S','aggregations':[{'type':'longSum','name':'S','fieldName':'unit_sales'},{'type':'longMax','name':'M','fieldName':'unit_sales'}],'intervals':['1997-01-01T00:00:00.000Z/1997-09-01T00:00:00.000Z'],'threshold':3}";
        this.sql("select sum(\"unit_sales\") as s,\nmax(\"unit_sales\") as m,\n\"state_province\" as p\nfrom \"foodmart\"\nwhere \"timestamp\" >= '1997-01-01 00:00:00' and  \"timestamp\" < '1997-09-01 00:00:00'\ngroup by \"state_province\", floor(\"timestamp\" to DAY)\norder by s desc limit 3").returnsOrdered(new String[]{"S=348; M=5; P=CA"}).explainContains("PLAN=EnumerableInterpreter\n  BindableProject(S=[$2], M=[$3], P=[$0])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1997-01-01T00:00:00.000Z/1997-09-01T00:00:00.000Z]], projects=[[$30, FLOOR($0, FLAG(DAY)), $89]], groups=[{0, 1}], aggs=[[SUM($2), MAX($2)]], sort0=[2], dir0=[DESC], fetch=[3])").queryContains(DruidAdapterIT.druidChecker("{'queryType':'topN','dataSource':'foodmart','granularity':'DAY','dimension':'state_province','metric':'S','aggregations':[{'type':'longSum','name':'S','fieldName':'unit_sales'},{'type':'longMax','name':'M','fieldName':'unit_sales'}],'intervals':['1997-01-01T00:00:00.000Z/1997-09-01T00:00:00.000Z'],'threshold':3}"));
    }

    @Test
    public void testGroupByHaving() {
        String sql = "select \"state_province\" as s, count(*) as c\nfrom \"foodmart\"\ngroup by \"state_province\" having count(*) > 23000 order by 1";
        String explain = "PLAN=EnumerableInterpreter\n  BindableSort(sort0=[$0], dir0=[ASC])\n    BindableFilter(condition=[>($1, 23000)])\n      DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{30}], aggs=[[COUNT()]])";
        this.sql("select \"state_province\" as s, count(*) as c\nfrom \"foodmart\"\ngroup by \"state_province\" having count(*) > 23000 order by 1").returnsOrdered(new String[]{"S=CA; C=24441", "S=WA; C=40778"}).explainContains("PLAN=EnumerableInterpreter\n  BindableSort(sort0=[$0], dir0=[ASC])\n    BindableFilter(condition=[>($1, 23000)])\n      DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{30}], aggs=[[COUNT()]])");
    }

    @Test
    public void testGroupComposite() {
        String sql = "select count(*) as c, \"state_province\", \"city\"\nfrom \"foodmart\"\ngroup by \"state_province\", \"city\"\norder by c desc limit 2";
        String explain = "PLAN=EnumerableInterpreter\n  BindableProject(C=[$2], state_province=[$1], city=[$0])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{29, 30}], aggs=[[COUNT()]], sort0=[2], dir0=[DESC], fetch=[2])";
        this.sql("select count(*) as c, \"state_province\", \"city\"\nfrom \"foodmart\"\ngroup by \"state_province\", \"city\"\norder by c desc limit 2").returnsOrdered(new String[]{"C=7394; state_province=WA; city=Spokane", "C=3958; state_province=WA; city=Olympia"}).explainContains("PLAN=EnumerableInterpreter\n  BindableProject(C=[$2], state_province=[$1], city=[$0])\n    DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{29, 30}], aggs=[[COUNT()]], sort0=[2], dir0=[DESC], fetch=[2])");
    }

    @Test
    public void testDistinctCount() {
        String sql = "select \"state_province\",\n floor(count(distinct \"city\")) as cdc\nfrom \"foodmart\"\ngroup by \"state_province\"\norder by 2 desc limit 2";
        String explain = "PLAN=EnumerableInterpreter\n  BindableSort(sort0=[$1], dir0=[DESC], fetch=[2])\n    BindableProject(state_province=[$0], CDC=[FLOOR($1)])\n      BindableAggregate(group=[{1}], agg#0=[COUNT($0)])\n        DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{29, 30}], aggs=[[]])";
        this.sql("select \"state_province\",\n floor(count(distinct \"city\")) as cdc\nfrom \"foodmart\"\ngroup by \"state_province\"\norder by 2 desc limit 2").explainContains("PLAN=EnumerableInterpreter\n  BindableSort(sort0=[$1], dir0=[DESC], fetch=[2])\n    BindableProject(state_province=[$0], CDC=[FLOOR($1)])\n      BindableAggregate(group=[{1}], agg#0=[COUNT($0)])\n        DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], groups=[{29, 30}], aggs=[[]])").returnsUnordered(new String[]{"state_province=CA; CDC=45", "state_province=WA; CDC=22"});
    }

    @Test
    public void testProject() {
        String sql = "select \"product_name\", 0 as zero\nfrom \"foodmart\"\norder by \"product_name\"";
        String explain = "PLAN=EnumerableInterpreter\n  BindableProject(product_name=[$0], ZERO=[0])\n    BindableSort(sort0=[$0], dir0=[ASC])\n      DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$3]])";
        this.sql("select \"product_name\", 0 as zero\nfrom \"foodmart\"\norder by \"product_name\"").limit(2).explainContains("PLAN=EnumerableInterpreter\n  BindableProject(product_name=[$0], ZERO=[0])\n    BindableSort(sort0=[$0], dir0=[ASC])\n      DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], projects=[[$3]])").returnsUnordered(new String[]{"product_name=ADJ Rosy Sunglasses; ZERO=0", "product_name=ADJ Rosy Sunglasses; ZERO=0"});
    }

    @Test
    public void testFilterDistinct() {
        String sql = "select distinct \"state_province\", \"city\",\n  \"product_name\"\nfrom \"foodmart\"\nwhere \"product_name\" = 'High Top Dried Mushrooms'\nand \"quarter\" in ('Q2', 'Q3')\nand \"state_province\" = 'WA'";
        String druidQuery = "{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':['state_province','city','product_name'],'limitSpec':{'type':'default'},'filter':{'type':'and','fields':[{'type':'selector','dimension':'product_name','value':'High Top Dried Mushrooms'},{'type':'or','fields':[{'type':'selector','dimension':'quarter','value':'Q2'},{'type':'selector','dimension':'quarter','value':'Q3'}]},{'type':'selector','dimension':'state_province','value':'WA'}]},'aggregations':[{'type':'longSum','name':'dummy_agg','fieldName':'dummy_agg'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}";
        String explain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[AND(=(CAST($3):VARCHAR(24) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\", 'High Top Dried Mushrooms'), OR(=($87, 'Q2'), =($87, 'Q3')), =(CAST($30):VARCHAR(2) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\", 'WA'))], projects=[[$30, $29, $3]], groups=[{0, 1, 2}], aggs=[[]])\n";
        this.sql("select distinct \"state_province\", \"city\",\n  \"product_name\"\nfrom \"foodmart\"\nwhere \"product_name\" = 'High Top Dried Mushrooms'\nand \"quarter\" in ('Q2', 'Q3')\nand \"state_province\" = 'WA'").queryContains(DruidAdapterIT.druidChecker("{'queryType':'groupBy','dataSource':'foodmart','granularity':'all','dimensions':['state_province','city','product_name'],'limitSpec':{'type':'default'},'filter':{'type':'and','fields':[{'type':'selector','dimension':'product_name','value':'High Top Dried Mushrooms'},{'type':'or','fields':[{'type':'selector','dimension':'quarter','value':'Q2'},{'type':'selector','dimension':'quarter','value':'Q3'}]},{'type':'selector','dimension':'state_province','value':'WA'}]},'aggregations':[{'type':'longSum','name':'dummy_agg','fieldName':'dummy_agg'}],'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z']}")).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[AND(=(CAST($3):VARCHAR(24) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\", 'High Top Dried Mushrooms'), OR(=($87, 'Q2'), =($87, 'Q3')), =(CAST($30):VARCHAR(2) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\", 'WA'))], projects=[[$30, $29, $3]], groups=[{0, 1, 2}], aggs=[[]])\n").returnsUnordered(new String[]{"state_province=WA; city=Bremerton; product_name=High Top Dried Mushrooms", "state_province=WA; city=Everett; product_name=High Top Dried Mushrooms", "state_province=WA; city=Kirkland; product_name=High Top Dried Mushrooms", "state_province=WA; city=Lynnwood; product_name=High Top Dried Mushrooms", "state_province=WA; city=Olympia; product_name=High Top Dried Mushrooms", "state_province=WA; city=Port Orchard; product_name=High Top Dried Mushrooms", "state_province=WA; city=Puyallup; product_name=High Top Dried Mushrooms", "state_province=WA; city=Spokane; product_name=High Top Dried Mushrooms", "state_province=WA; city=Tacoma; product_name=High Top Dried Mushrooms", "state_province=WA; city=Yakima; product_name=High Top Dried Mushrooms"});
    }

    @Test
    public void testFilter() {
        String sql = "select \"state_province\", \"city\",\n  \"product_name\"\nfrom \"foodmart\"\nwhere \"product_name\" = 'High Top Dried Mushrooms'\nand \"quarter\" in ('Q2', 'Q3')\nand \"state_province\" = 'WA'";
        String druidQuery = "{'queryType':'select','dataSource':'foodmart','descending':false,'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'filter':{'type':'and','fields':[{'type':'selector','dimension':'product_name','value':'High Top Dried Mushrooms'},{'type':'or','fields':[{'type':'selector','dimension':'quarter','value':'Q2'},{'type':'selector','dimension':'quarter','value':'Q3'}]},{'type':'selector','dimension':'state_province','value':'WA'}]},'dimensions':['state_province','city','product_name'],'metrics':[],'granularity':'all','pagingSpec':{'threshold':16384},'context':{'druid.query.fetch':false}}";
        String explain = "PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[AND(=(CAST($3):VARCHAR(24) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\", 'High Top Dried Mushrooms'), OR(=($87, 'Q2'), =($87, 'Q3')), =(CAST($30):VARCHAR(2) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\", 'WA'))], projects=[[$30, $29, $3]])\n";
        this.sql("select \"state_province\", \"city\",\n  \"product_name\"\nfrom \"foodmart\"\nwhere \"product_name\" = 'High Top Dried Mushrooms'\nand \"quarter\" in ('Q2', 'Q3')\nand \"state_province\" = 'WA'").queryContains(DruidAdapterIT.druidChecker("{'queryType':'select','dataSource':'foodmart','descending':false,'intervals':['1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z'],'filter':{'type':'and','fields':[{'type':'selector','dimension':'product_name','value':'High Top Dried Mushrooms'},{'type':'or','fields':[{'type':'selector','dimension':'quarter','value':'Q2'},{'type':'selector','dimension':'quarter','value':'Q3'}]},{'type':'selector','dimension':'state_province','value':'WA'}]},'dimensions':['state_province','city','product_name'],'metrics':[],'granularity':'all','pagingSpec':{'threshold':16384},'context':{'druid.query.fetch':false}}")).explainContains("PLAN=EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[AND(=(CAST($3):VARCHAR(24) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\", 'High Top Dried Mushrooms'), OR(=($87, 'Q2'), =($87, 'Q3')), =(CAST($30):VARCHAR(2) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\", 'WA'))], projects=[[$30, $29, $3]])\n").returnsUnordered(new String[]{"state_province=WA; city=Bremerton; product_name=High Top Dried Mushrooms", "state_province=WA; city=Bremerton; product_name=High Top Dried Mushrooms", "state_province=WA; city=Everett; product_name=High Top Dried Mushrooms", "state_province=WA; city=Kirkland; product_name=High Top Dried Mushrooms", "state_province=WA; city=Lynnwood; product_name=High Top Dried Mushrooms", "state_province=WA; city=Olympia; product_name=High Top Dried Mushrooms", "state_province=WA; city=Port Orchard; product_name=High Top Dried Mushrooms", "state_province=WA; city=Puyallup; product_name=High Top Dried Mushrooms", "state_province=WA; city=Puyallup; product_name=High Top Dried Mushrooms", "state_province=WA; city=Spokane; product_name=High Top Dried Mushrooms", "state_province=WA; city=Spokane; product_name=High Top Dried Mushrooms", "state_province=WA; city=Spokane; product_name=High Top Dried Mushrooms", "state_province=WA; city=Tacoma; product_name=High Top Dried Mushrooms", "state_province=WA; city=Yakima; product_name=High Top Dried Mushrooms", "state_province=WA; city=Yakima; product_name=High Top Dried Mushrooms", "state_province=WA; city=Yakima; product_name=High Top Dried Mushrooms"});
    }

    @Test
    public void testFilterTimestamp() {
        String sql = "select count(*) as c\nfrom \"foodmart\"\nwhere extract(year from \"timestamp\") = 1997\nand extract(month from \"timestamp\") in (4, 6)\n";
        String explain = "EnumerableInterpreter\n  BindableAggregate(group=[{}], C=[COUNT()])\n    BindableFilter(condition=[AND(>=(/INT(Reinterpret($0), 86400000), 1997-01-01), <(/INT(Reinterpret($0), 86400000), 1998-01-01), >=(/INT(Reinterpret($0), 86400000), 1997-04-01), <(/INT(Reinterpret($0), 86400000), 1997-05-01))])\n      DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]])";
        this.sql(sql).explainContains("EnumerableInterpreter\n  BindableAggregate(group=[{}], C=[COUNT()])\n    BindableFilter(condition=[AND(>=(/INT(Reinterpret($0), 86400000), 1997-01-01), <(/INT(Reinterpret($0), 86400000), 1998-01-01), >=(/INT(Reinterpret($0), 86400000), 1997-04-01), <(/INT(Reinterpret($0), 86400000), 1997-05-01))])\n      DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]])").returnsUnordered(new String[]{"C=6588"});
    }

    @Test
    public void testFilterSwapped() {
        String sql = "select \"state_province\"\nfrom \"foodmart\"\nwhere 'High Top Dried Mushrooms' = \"product_name\"";
        String explain = "EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[=('High Top Dried Mushrooms', CAST($3):VARCHAR(24) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\")], projects=[[$30]])";
        String druidQuery = "'filter':{'type':'selector','dimension':'product_name','value':'High Top Dried Mushrooms'}";
        this.sql(sql).explainContains("EnumerableInterpreter\n  DruidQuery(table=[[foodmart, foodmart]], intervals=[[1900-01-09T00:00:00.000Z/2992-01-10T00:00:00.000Z]], filter=[=('High Top Dried Mushrooms', CAST($3):VARCHAR(24) CHARACTER SET \"ISO-8859-1\" COLLATE \"ISO-8859-1$en_US$primary\")], projects=[[$30]])").queryContains(DruidAdapterIT.druidChecker("'filter':{'type':'selector','dimension':'product_name','value':'High Top Dried Mushrooms'}"));
    }

    @Test
    public void testWhereGroupBy() {
        String sql = "select \"wikiticker\".\"countryName\" as \"c0\",\n sum(\"wikiticker\".\"count\") as \"m1\",\n sum(\"wikiticker\".\"deleted\") as \"m2\",\n sum(\"wikiticker\".\"delta\") as \"m3\"\nfrom \"wiki\" as \"wikiticker\"\nwhere (\"wikiticker\".\"countryName\" in ('Colombia', 'France',\n 'Germany', 'India', 'Italy', 'Russia', 'United Kingdom',\n 'United States') or \"wikiticker\".\"countryName\" is null)\ngroup by \"wikiticker\".\"countryName\"";
        this.sql(sql, WIKI).returnsCount(9);
    }
}

