/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.util.HashMap;
import java.util.List;
import org.apache.calcite.adapter.druid.DruidDateTimeUtils;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.rel.rules.DateRangeRules;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.test.RexImplicationCheckerTest;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class DruidDateRangeRulesTest {
    @Test
    public void testExtractYearAndMonthFromDateColumn() {
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.and(new RexNode[]{f.eq(f.exYear, (RexNode)f.literal(2014)), f.eq(f.exMonth, (RexNode)f.literal(6))}), (Matcher<String>)Is.is((Object)"[2014-06-01T00:00:00.000Z/2014-07-01T00:00:00.000Z]"));
    }

    @Test
    public void testExtractYearAndDayFromDateColumn() {
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.and(new RexNode[]{f.eq(f.exYear, (RexNode)f.literal(2010)), f.eq(f.exDay, (RexNode)f.literal(31))}), (Matcher<String>)Is.is((Object)"[2010-01-31T00:00:00.000Z/2010-02-01T00:00:00.000Z, 2010-03-31T00:00:00.000Z/2010-04-01T00:00:00.000Z, 2010-05-31T00:00:00.000Z/2010-06-01T00:00:00.000Z, 2010-07-31T00:00:00.000Z/2010-08-01T00:00:00.000Z, 2010-08-31T00:00:00.000Z/2010-09-01T00:00:00.000Z, 2010-10-31T00:00:00.000Z/2010-11-01T00:00:00.000Z, 2010-12-31T00:00:00.000Z/2011-01-01T00:00:00.000Z]"));
    }

    @Test
    public void testExtractYearMonthDayFromDateColumn() {
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.and(new RexNode[]{f.gt(f.exYear, (RexNode)f.literal(2010)), f.lt(f.exYear, (RexNode)f.literal(2020)), f.eq(f.exMonth, (RexNode)f.literal(2)), f.eq(f.exDay, (RexNode)f.literal(29))}), (Matcher<String>)Is.is((Object)"[2012-02-29T00:00:00.000Z/2012-03-01T00:00:00.000Z, 2016-02-29T00:00:00.000Z/2016-03-01T00:00:00.000Z]"));
    }

    @Test
    public void testExtractYearMonthDayFromTimestampColumn() {
        Fixture2 f = new Fixture2();
        this.checkDateRange(f, f.and(new RexNode[]{f.gt(f.exYearTs, (RexNode)f.literal(2010)), f.lt(f.exYearTs, (RexNode)f.literal(2020)), f.eq(f.exMonthTs, (RexNode)f.literal(2)), f.eq(f.exDayTs, (RexNode)f.literal(29))}), (Matcher<String>)Is.is((Object)"[2012-02-29T00:00:00.000Z/2012-03-01T00:00:00.000Z, 2016-02-29T00:00:00.000Z/2016-03-01T00:00:00.000Z]"));
    }

    private void checkDateRange(RexImplicationCheckerTest.Fixture f, RexNode e, Matcher<String> intervalMatcher) {
        HashMap operandRanges = new HashMap();
        List timeUnits = Ordering.natural().sortedCopy((Iterable)DateRangeRules.extractTimeUnits((RexNode)e));
        for (TimeUnitRange timeUnit : timeUnits) {
            e = (RexNode)e.accept((RexVisitor)new DateRangeRules.ExtractShuttle(f.rexBuilder, timeUnit, operandRanges));
        }
        RexNode e2 = RexUtil.simplify((RexBuilder)f.rexBuilder, (RexNode)e);
        List intervals = DruidDateTimeUtils.createInterval((RelDataType)f.timeStampDataType, (RexNode)e2);
        if (intervals == null) {
            throw new AssertionError((Object)"null interval");
        }
        Assert.assertThat((Object)intervals.toString(), intervalMatcher);
    }

    private static class Fixture2
    extends RexImplicationCheckerTest.Fixture {
        private final RexNode exYear;
        private final RexNode exMonth;
        private final RexNode exDay;
        private final RexNode exYearTs;
        private final RexNode exMonthTs;
        private final RexNode exDayTs;

        Fixture2() {
            this.exYear = this.rexBuilder.makeCall(this.intRelDataType, (SqlOperator)SqlStdOperatorTable.EXTRACT_DATE, (List)ImmutableList.of((Object)this.rexBuilder.makeFlag((Enum)TimeUnitRange.YEAR), (Object)this.dt));
            this.exMonth = this.rexBuilder.makeCall(this.intRelDataType, (SqlOperator)SqlStdOperatorTable.EXTRACT_DATE, (List)ImmutableList.of((Object)this.rexBuilder.makeFlag((Enum)TimeUnitRange.MONTH), (Object)this.dt));
            this.exDay = this.rexBuilder.makeCall(this.intRelDataType, (SqlOperator)SqlStdOperatorTable.EXTRACT_DATE, (List)ImmutableList.of((Object)this.rexBuilder.makeFlag((Enum)TimeUnitRange.DAY), (Object)this.dt));
            this.exYearTs = this.rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EXTRACT, (List)ImmutableList.of((Object)this.rexBuilder.makeFlag((Enum)TimeUnitRange.YEAR), (Object)this.ts));
            this.exMonthTs = this.rexBuilder.makeCall(this.intRelDataType, (SqlOperator)SqlStdOperatorTable.EXTRACT, (List)ImmutableList.of((Object)this.rexBuilder.makeFlag((Enum)TimeUnitRange.MONTH), (Object)this.ts));
            this.exDayTs = this.rexBuilder.makeCall(this.intRelDataType, (SqlOperator)SqlStdOperatorTable.EXTRACT, (List)ImmutableList.of((Object)this.rexBuilder.makeFlag((Enum)TimeUnitRange.DAY), (Object)this.ts));
        }
    }
}

