/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.druid;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.calcite.adapter.druid.DruidConnection;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.adapter.druid.QueryType;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.interpreter.Row;
import org.apache.calcite.interpreter.Sink;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.prepare.CalcitePrepareImpl;
import org.apache.calcite.runtime.HttpUtils;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Holder;
import org.joda.time.Interval;

class DruidConnectionImpl
implements DruidConnection {
    private final String url;
    private final String coordinatorUrl;
    private static final String DEFAULT_RESPONSE_TIMESTAMP_COLUMN = "timestamp";
    private static final SimpleDateFormat UTC_TIMESTAMP_FORMAT;

    DruidConnectionImpl(String url, String coordinatorUrl) {
        this.url = (String)Preconditions.checkNotNull((Object)url);
        this.coordinatorUrl = (String)Preconditions.checkNotNull((Object)coordinatorUrl);
    }

    public void request(QueryType queryType, String data, Sink sink, List<String> fieldNames, List<ColumnMetaData.Rep> fieldTypes, Page page) {
        String url = this.url + "/druid/v2/?pretty";
        ImmutableMap requestHeaders = ImmutableMap.of((Object)"Content-Type", (Object)"application/json");
        if (CalcitePrepareImpl.DEBUG) {
            System.out.println(data);
        }
        try (InputStream in0 = HttpUtils.post((String)url, (CharSequence)data, (Map)requestHeaders, (int)10000, (int)1800000);
             InputStream in = this.traceResponse(in0);){
            this.parse(queryType, in, sink, fieldNames, fieldTypes, page);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while processing druid request [" + data + "]", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parse(QueryType queryType, InputStream in, Sink sink, List<String> fieldNames, List<ColumnMetaData.Rep> fieldTypes, Page page) {
        JsonFactory factory = new JsonFactory();
        Row.RowBuilder rowBuilder = Row.newBuilder((int)fieldNames.size());
        if (CalcitePrepareImpl.DEBUG) {
            try {
                byte[] bytes = AvaticaUtils.readFullyToBytes((InputStream)in);
                System.out.println("Response: " + new String(bytes));
                in = new ByteArrayInputStream(bytes);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        int posTimestampField = -1;
        for (int i = 0; i < fieldTypes.size(); ++i) {
            if (fieldTypes.get(i) != ColumnMetaData.Rep.JAVA_SQL_TIMESTAMP) continue;
            posTimestampField = i;
            break;
        }
        try (JsonParser parser = factory.createParser(in);){
            switch (queryType) {
                case TIMESERIES: {
                    Long timeValue;
                    if (parser.nextToken() != JsonToken.START_ARRAY) return;
                    while (parser.nextToken() == JsonToken.START_OBJECT) {
                        timeValue = this.extractTimestampField(parser);
                        if (parser.nextToken() == JsonToken.FIELD_NAME && parser.getCurrentName().equals("result") && parser.nextToken() == JsonToken.START_OBJECT) {
                            if (posTimestampField != -1) {
                                rowBuilder.set(posTimestampField, (Object)timeValue);
                            }
                            this.parseFields(fieldNames, fieldTypes, rowBuilder, parser);
                            sink.send(rowBuilder.build());
                            rowBuilder.reset();
                        }
                        this.expect(parser, JsonToken.END_OBJECT);
                    }
                    return;
                }
                case TOP_N: {
                    if (parser.nextToken() != JsonToken.START_ARRAY) return;
                    if (parser.nextToken() != JsonToken.START_OBJECT) return;
                    Long timeValue = this.extractTimestampField(parser);
                    if (parser.nextToken() != JsonToken.FIELD_NAME) return;
                    if (!parser.getCurrentName().equals("result")) return;
                    if (parser.nextToken() != JsonToken.START_ARRAY) return;
                    while (parser.nextToken() == JsonToken.START_OBJECT) {
                        if (posTimestampField != -1) {
                            rowBuilder.set(posTimestampField, (Object)timeValue);
                        }
                        this.parseFields(fieldNames, fieldTypes, rowBuilder, parser);
                        sink.send(rowBuilder.build());
                        rowBuilder.reset();
                    }
                    return;
                }
                case SELECT: {
                    if (parser.nextToken() != JsonToken.START_ARRAY) return;
                    if (parser.nextToken() != JsonToken.START_OBJECT) return;
                    page.pagingIdentifier = null;
                    page.offset = -1;
                    page.totalRowCount = 0;
                    this.expectScalarField(parser, DEFAULT_RESPONSE_TIMESTAMP_COLUMN);
                    if (parser.nextToken() != JsonToken.FIELD_NAME) return;
                    if (!parser.getCurrentName().equals("result")) return;
                    if (parser.nextToken() != JsonToken.START_OBJECT) return;
                    if (parser.nextToken() == JsonToken.FIELD_NAME && parser.getCurrentName().equals("pagingIdentifiers") && parser.nextToken() == JsonToken.START_OBJECT) {
                        JsonToken token = parser.nextToken();
                        while (parser.getCurrentToken() == JsonToken.FIELD_NAME) {
                            page.pagingIdentifier = parser.getCurrentName();
                            if (parser.nextToken() == JsonToken.VALUE_NUMBER_INT) {
                                page.offset = parser.getIntValue();
                            }
                            token = parser.nextToken();
                        }
                        this.expect(token, JsonToken.END_OBJECT);
                    }
                    if (parser.nextToken() != JsonToken.FIELD_NAME) return;
                    if (!parser.getCurrentName().equals("events")) return;
                    if (parser.nextToken() != JsonToken.START_ARRAY) return;
                    while (true) {
                        if (parser.nextToken() != JsonToken.START_OBJECT) {
                            parser.nextToken();
                            return;
                        }
                        this.expectScalarField(parser, "segmentId");
                        this.expectScalarField(parser, "offset");
                        if (parser.nextToken() == JsonToken.FIELD_NAME && parser.getCurrentName().equals("event") && parser.nextToken() == JsonToken.START_OBJECT) {
                            this.parseFields(fieldNames, fieldTypes, posTimestampField, rowBuilder, parser);
                            sink.send(rowBuilder.build());
                            rowBuilder.reset();
                            ++page.totalRowCount;
                        }
                        this.expect(parser, JsonToken.END_OBJECT);
                    }
                }
                case GROUP_BY: {
                    Long timeValue;
                    if (parser.nextToken() != JsonToken.START_ARRAY) return;
                    while (parser.nextToken() == JsonToken.START_OBJECT) {
                        this.expectScalarField(parser, "version");
                        timeValue = this.extractTimestampField(parser);
                        if (parser.nextToken() == JsonToken.FIELD_NAME && parser.getCurrentName().equals("event") && parser.nextToken() == JsonToken.START_OBJECT) {
                            if (posTimestampField != -1) {
                                rowBuilder.set(posTimestampField, (Object)timeValue);
                            }
                            this.parseFields(fieldNames, fieldTypes, rowBuilder, parser);
                            sink.send(rowBuilder.build());
                            rowBuilder.reset();
                        }
                        this.expect(parser, JsonToken.END_OBJECT);
                    }
                    return;
                }
            }
            return;
        }
        catch (IOException | InterruptedException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void parseFields(List<String> fieldNames, List<ColumnMetaData.Rep> fieldTypes, Row.RowBuilder rowBuilder, JsonParser parser) throws IOException {
        this.parseFields(fieldNames, fieldTypes, -1, rowBuilder, parser);
    }

    private void parseFields(List<String> fieldNames, List<ColumnMetaData.Rep> fieldTypes, int posTimestampField, Row.RowBuilder rowBuilder, JsonParser parser) throws IOException {
        while (parser.nextToken() == JsonToken.FIELD_NAME) {
            this.parseField(fieldNames, fieldTypes, posTimestampField, rowBuilder, parser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseField(List<String> fieldNames, List<ColumnMetaData.Rep> fieldTypes, int posTimestampField, Row.RowBuilder rowBuilder, JsonParser parser) throws IOException {
        String fieldName = parser.getCurrentName();
        JsonToken token = parser.nextToken();
        if (fieldName.equals(DEFAULT_RESPONSE_TIMESTAMP_COLUMN)) {
            try {
                Date parse;
                SimpleDateFormat simpleDateFormat = UTC_TIMESTAMP_FORMAT;
                synchronized (simpleDateFormat) {
                    parse = UTC_TIMESTAMP_FORMAT.parse(parser.getText());
                }
                if (posTimestampField != -1) {
                    rowBuilder.set(posTimestampField, (Object)parse.getTime());
                }
            }
            catch (ParseException e) {
                // empty catch block
            }
            return;
        }
        int i = fieldNames.indexOf(fieldName);
        if (i < 0) {
            return;
        }
        ColumnMetaData.Rep type = fieldTypes.get(i);
        switch (token) {
            case VALUE_NUMBER_INT: {
                if (type == null) {
                    type = ColumnMetaData.Rep.INTEGER;
                }
            }
            case VALUE_NUMBER_FLOAT: {
                if (type == null) {
                    type = ColumnMetaData.Rep.DOUBLE;
                }
                switch (type) {
                    case BYTE: {
                        rowBuilder.set(i, (Object)parser.getByteValue());
                        break;
                    }
                    case SHORT: {
                        rowBuilder.set(i, (Object)parser.getShortValue());
                        break;
                    }
                    case INTEGER: {
                        rowBuilder.set(i, (Object)parser.getIntValue());
                        break;
                    }
                    case LONG: {
                        rowBuilder.set(i, (Object)parser.getLongValue());
                        break;
                    }
                    case DOUBLE: {
                        rowBuilder.set(i, (Object)parser.getDoubleValue());
                    }
                }
                break;
            }
            case VALUE_TRUE: {
                rowBuilder.set(i, (Object)true);
                break;
            }
            case VALUE_FALSE: {
                rowBuilder.set(i, (Object)false);
                break;
            }
            case VALUE_NULL: {
                break;
            }
            default: {
                rowBuilder.set(i, (Object)parser.getText());
            }
        }
    }

    private void expect(JsonParser parser, JsonToken token) throws IOException {
        this.expect(parser.nextToken(), token);
    }

    private void expect(JsonToken token, JsonToken expected) throws IOException {
        if (token != expected) {
            throw new RuntimeException("expected " + expected + ", got " + token);
        }
    }

    private void expectScalarField(JsonParser parser, String name) throws IOException {
        this.expect(parser, JsonToken.FIELD_NAME);
        if (!parser.getCurrentName().equals(name)) {
            throw new RuntimeException("expected field " + name + ", got " + parser.getCurrentName());
        }
        JsonToken t = parser.nextToken();
        switch (t) {
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: 
            case VALUE_TRUE: 
            case VALUE_FALSE: 
            case VALUE_NULL: 
            case VALUE_STRING: {
                break;
            }
            default: {
                throw new RuntimeException("expected scalar field, got  " + t);
            }
        }
    }

    private void expectObjectField(JsonParser parser, String name) throws IOException {
        this.expect(parser, JsonToken.FIELD_NAME);
        if (!parser.getCurrentName().equals(name)) {
            throw new RuntimeException("expected field " + name + ", got " + parser.getCurrentName());
        }
        this.expect(parser, JsonToken.START_OBJECT);
        while (parser.nextToken() != JsonToken.END_OBJECT) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long extractTimestampField(JsonParser parser) throws IOException {
        this.expect(parser, JsonToken.FIELD_NAME);
        if (!parser.getCurrentName().equals(DEFAULT_RESPONSE_TIMESTAMP_COLUMN)) {
            throw new RuntimeException("expected field timestamp, got " + parser.getCurrentName());
        }
        parser.nextToken();
        try {
            Date parse;
            SimpleDateFormat simpleDateFormat = UTC_TIMESTAMP_FORMAT;
            synchronized (simpleDateFormat) {
                parse = UTC_TIMESTAMP_FORMAT.parse(parser.getText());
            }
            return parse.getTime();
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public Enumerable<Row> enumerable(final QueryType queryType, final String request, final List<String> fieldNames, final ExecutorService service) throws IOException {
        return new AbstractEnumerable<Row>(){

            public Enumerator<Row> enumerator() {
                final BlockingQueueEnumerator<Row> enumerator = new BlockingQueueEnumerator<Row>();
                RunnableQueueSink sink = new RunnableQueueSink(){

                    public void send(Row row) throws InterruptedException {
                        enumerator.queue.put(row);
                    }

                    public void end() {
                        enumerator.done.set(true);
                    }

                    public void setSourceEnumerable(Enumerable<Row> enumerable) throws InterruptedException {
                        for (Row row : enumerable) {
                            this.send(row);
                        }
                        this.end();
                    }

                    @Override
                    public void run() {
                        try {
                            Page page = new Page();
                            List<Object> fieldTypes = Collections.nCopies(fieldNames.size(), null);
                            DruidConnectionImpl.this.request(queryType, request, this, fieldNames, fieldTypes, page);
                            enumerator.done.set(true);
                        }
                        catch (Throwable e) {
                            enumerator.throwableHolder.set((Object)e);
                            enumerator.done.set(true);
                        }
                    }
                };
                service.execute(sink);
                return enumerator;
            }
        };
    }

    void metadata(String dataSourceName, String timestampColumnName, List<Interval> intervals, Map<String, SqlTypeName> fieldBuilder, Set<String> metricNameBuilder) {
        String url = this.url + "/druid/v2/?pretty";
        ImmutableMap requestHeaders = ImmutableMap.of((Object)"Content-Type", (Object)"application/json");
        String data = DruidQuery.metadataQuery(dataSourceName, intervals);
        if (CalcitePrepareImpl.DEBUG) {
            System.out.println("Druid: " + data);
        }
        try (InputStream in0 = HttpUtils.post((String)url, (CharSequence)data, (Map)requestHeaders, (int)10000, (int)1800000);
             InputStream in = this.traceResponse(in0);){
            ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            CollectionType listType = mapper.getTypeFactory().constructCollectionType(List.class, JsonSegmentMetadata.class);
            List list = (List)mapper.readValue(in, (JavaType)listType);
            in.close();
            fieldBuilder.put(timestampColumnName, SqlTypeName.TIMESTAMP);
            for (JsonSegmentMetadata o : list) {
                for (Map.Entry<String, JsonColumn> entry : o.columns.entrySet()) {
                    DruidType druidType;
                    if (entry.getKey().equals("__time")) continue;
                    try {
                        druidType = DruidType.valueOf(entry.getValue().type);
                    }
                    catch (IllegalArgumentException e) {
                        continue;
                    }
                    fieldBuilder.put(entry.getKey(), druidType.sqlType);
                }
                if (o.aggregators == null) continue;
                for (Map.Entry<String, Object> entry : o.aggregators.entrySet()) {
                    if (!fieldBuilder.containsKey(entry.getKey())) continue;
                    metricNameBuilder.add(entry.getKey());
                }
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    Set<String> tableNames() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private InputStream traceResponse(InputStream in) {
        if (CalcitePrepareImpl.DEBUG) {
            try {
                byte[] bytes = AvaticaUtils.readFullyToBytes((InputStream)in);
                in.close();
                System.out.println("Response: " + new String(bytes));
                in = new ByteArrayInputStream(bytes);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return in;
    }

    static {
        TimeZone utc = TimeZone.getTimeZone("UTC");
        UTC_TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        UTC_TIMESTAMP_FORMAT.setTimeZone(utc);
    }

    static enum DruidType {
        LONG(SqlTypeName.BIGINT),
        FLOAT(SqlTypeName.DOUBLE),
        STRING(SqlTypeName.VARCHAR),
        hyperUnique(SqlTypeName.VARBINARY);

        public final SqlTypeName sqlType;

        private DruidType(SqlTypeName sqlType) {
            this.sqlType = sqlType;
        }
    }

    private static class JsonAggregator {
        public String type;
        public String name;
        public String fieldName;

        private JsonAggregator() {
        }

        DruidType druidType() {
            if (this.type.startsWith("long")) {
                return DruidType.LONG;
            }
            if (this.type.startsWith("double")) {
                return DruidType.FLOAT;
            }
            if (this.type.equals("hyperUnique")) {
                return DruidType.hyperUnique;
            }
            throw new AssertionError((Object)("unknown type " + this.type));
        }
    }

    private static class JsonColumn {
        public String type;
        public boolean hasMultipleValues;
        public int size;
        public Integer cardinality;
        public String errorMessage;

        private JsonColumn() {
        }
    }

    private static class JsonSegmentMetadata {
        public String id;
        public List<String> intervals;
        public Map<String, JsonColumn> columns;
        public int size;
        public int numRows;
        public Map<String, JsonAggregator> aggregators;

        private JsonSegmentMetadata() {
        }
    }

    static class Page {
        String pagingIdentifier = null;
        int offset = -1;
        int totalRowCount = 0;

        Page() {
        }

        public String toString() {
            return "{" + this.pagingIdentifier + ": " + this.offset + "}";
        }
    }

    private static class BlockingQueueEnumerator<E>
    implements Enumerator<E> {
        final BlockingQueue<E> queue = new ArrayBlockingQueue(1000);
        final AtomicBoolean done = new AtomicBoolean(false);
        final Holder<Throwable> throwableHolder = Holder.of(null);
        E next;

        private BlockingQueueEnumerator() {
        }

        public E current() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            return this.next;
        }

        public boolean moveNext() {
            do {
                this.next = this.queue.poll();
                if (this.next == null) continue;
                return true;
            } while (!this.done.get());
            this.close();
            return false;
        }

        public void reset() {
        }

        public void close() {
            Throwable throwable = (Throwable)this.throwableHolder.get();
            if (throwable != null) {
                this.throwableHolder.set(null);
                throw Throwables.propagate((Throwable)throwable);
            }
        }
    }

    private static interface RunnableQueueSink
    extends Sink,
    Runnable {
    }
}

