/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.druid;

import com.google.common.base.Function;
import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.TreeRangeSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.calcite.adapter.druid.DruidTable;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.trace.CalciteTrace;
import org.joda.time.Chronology;
import org.joda.time.Interval;
import org.joda.time.chrono.ISOChronology;
import org.slf4j.Logger;

public class DruidDateTimeUtils {
    protected static final Logger LOGGER = CalciteTrace.getPlannerTracer();
    private static final Pattern TIMESTAMP_PATTERN = Pattern.compile("[0-9][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9] [0-9][0-9]:[0-9][0-9]:[0-9][0-9]");

    private DruidDateTimeUtils() {
    }

    public static List<Interval> createInterval(RelDataType type, RexNode e) {
        List<Range<Calendar>> ranges = DruidDateTimeUtils.extractRanges(e, false);
        if (ranges == null) {
            return null;
        }
        TreeRangeSet condensedRanges = TreeRangeSet.create();
        for (Range<Calendar> r : ranges) {
            condensedRanges.add(r);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Inferred ranges on interval : " + condensedRanges);
        }
        return DruidDateTimeUtils.toInterval((List<Range<Calendar>>)ImmutableList.copyOf((Collection)condensedRanges.asRanges()));
    }

    protected static List<Interval> toInterval(List<Range<Calendar>> ranges) {
        List intervals = Lists.transform(ranges, (Function)new Function<Range<Calendar>, Interval>(){

            public Interval apply(Range<Calendar> range) {
                long end;
                if (!range.hasLowerBound() && !range.hasUpperBound()) {
                    return DruidTable.DEFAULT_INTERVAL;
                }
                long start = range.hasLowerBound() ? ((Calendar)range.lowerEndpoint()).getTime().getTime() : DruidTable.DEFAULT_INTERVAL.getStartMillis();
                long l = end = range.hasUpperBound() ? ((Calendar)range.upperEndpoint()).getTime().getTime() : DruidTable.DEFAULT_INTERVAL.getEndMillis();
                if (range.hasLowerBound() && range.lowerBoundType() == BoundType.OPEN) {
                    ++start;
                }
                if (range.hasUpperBound() && range.upperBoundType() == BoundType.CLOSED) {
                    ++end;
                }
                return new Interval(start, end, (Chronology)ISOChronology.getInstanceUTC());
            }
        });
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Converted time ranges " + ranges + " to interval " + intervals);
        }
        return intervals;
    }

    protected static List<Range<Calendar>> extractRanges(RexNode node, boolean withNot) {
        switch (node.getKind()) {
            case EQUALS: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case BETWEEN: 
            case IN: {
                return DruidDateTimeUtils.leafToRanges((RexCall)node, withNot);
            }
            case NOT: {
                return DruidDateTimeUtils.extractRanges((RexNode)((RexCall)node).getOperands().get(0), !withNot);
            }
            case OR: {
                RexCall call = (RexCall)node;
                ArrayList intervals = Lists.newArrayList();
                for (RexNode child : call.getOperands()) {
                    List<Range<Calendar>> extracted = DruidDateTimeUtils.extractRanges(child, withNot);
                    if (extracted == null) continue;
                    intervals.addAll(extracted);
                }
                return intervals;
            }
            case AND: {
                RexCall call = (RexCall)node;
                ArrayList<Object> ranges = new ArrayList<Range<Calendar>>();
                for (RexNode child : call.getOperands()) {
                    List<Range<Calendar>> extractedRanges = DruidDateTimeUtils.extractRanges(child, false);
                    if (extractedRanges == null || extractedRanges.isEmpty()) {
                        return null;
                    }
                    if (ranges.isEmpty()) {
                        ranges.addAll(extractedRanges);
                        continue;
                    }
                    ArrayList<Range> overlapped = new ArrayList<Range>();
                    for (Range range : ranges) {
                        for (Range<Calendar> interval : extractedRanges) {
                            if (!range.isConnected(interval)) continue;
                            overlapped.add(range.intersection(interval));
                        }
                    }
                    ranges = overlapped;
                }
                return ranges;
            }
        }
        return null;
    }

    protected static List<Range<Calendar>> leafToRanges(RexCall call, boolean withNot) {
        switch (call.getKind()) {
            case EQUALS: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                Calendar value;
                if (call.getOperands().get(0) instanceof RexInputRef && DruidDateTimeUtils.literalValue((RexNode)call.getOperands().get(1)) != null) {
                    value = DruidDateTimeUtils.literalValue((RexNode)call.getOperands().get(1));
                } else if (call.getOperands().get(1) instanceof RexInputRef && DruidDateTimeUtils.literalValue((RexNode)call.getOperands().get(0)) != null) {
                    value = DruidDateTimeUtils.literalValue((RexNode)call.getOperands().get(0));
                } else {
                    return null;
                }
                switch (call.getKind()) {
                    case LESS_THAN: {
                        return ImmutableList.of((Object)(withNot ? Range.atLeast((Comparable)value) : Range.lessThan((Comparable)value)));
                    }
                    case LESS_THAN_OR_EQUAL: {
                        return ImmutableList.of((Object)(withNot ? Range.greaterThan((Comparable)value) : Range.atMost((Comparable)value)));
                    }
                    case GREATER_THAN: {
                        return ImmutableList.of((Object)(withNot ? Range.atMost((Comparable)value) : Range.greaterThan((Comparable)value)));
                    }
                    case GREATER_THAN_OR_EQUAL: {
                        return ImmutableList.of((Object)(withNot ? Range.lessThan((Comparable)value) : Range.atLeast((Comparable)value)));
                    }
                }
                if (!withNot) {
                    return ImmutableList.of((Object)Range.closed((Comparable)value, (Comparable)value));
                }
                return ImmutableList.of((Object)Range.lessThan((Comparable)value), (Object)Range.greaterThan((Comparable)value));
            }
            case BETWEEN: {
                boolean inverted;
                if (DruidDateTimeUtils.literalValue((RexNode)call.getOperands().get(2)) == null || DruidDateTimeUtils.literalValue((RexNode)call.getOperands().get(3)) == null) {
                    return null;
                }
                Calendar value1 = DruidDateTimeUtils.literalValue((RexNode)call.getOperands().get(2));
                Calendar value2 = DruidDateTimeUtils.literalValue((RexNode)call.getOperands().get(3));
                boolean bl = inverted = value1.compareTo(value2) > 0;
                if (!withNot) {
                    return ImmutableList.of((Object)(inverted ? Range.closed((Comparable)value2, (Comparable)value1) : Range.closed((Comparable)value1, (Comparable)value2)));
                }
                return ImmutableList.of((Object)Range.lessThan((Comparable)(inverted ? value2 : value1)), (Object)Range.greaterThan((Comparable)(inverted ? value1 : value2)));
            }
            case IN: {
                ImmutableList.Builder ranges = ImmutableList.builder();
                for (RexNode operand : Util.skip((List)call.operands)) {
                    Calendar element = DruidDateTimeUtils.literalValue(operand);
                    if (element == null) {
                        return null;
                    }
                    if (withNot) {
                        ranges.add((Object)Range.lessThan((Comparable)element));
                        ranges.add((Object)Range.greaterThan((Comparable)element));
                        continue;
                    }
                    ranges.add((Object)Range.closed((Comparable)element, (Comparable)element));
                }
                return ranges.build();
            }
        }
        return null;
    }

    private static Calendar literalValue(RexNode node) {
        if (node instanceof RexLiteral) {
            return (Calendar)((RexLiteral)node).getValue();
        }
        return null;
    }

    public static String extractGranularity(RexCall call) {
        if (call.getKind() != SqlKind.FLOOR || call.getOperands().size() != 2) {
            return null;
        }
        RexLiteral flag = (RexLiteral)call.operands.get(1);
        TimeUnitRange timeUnit = (TimeUnitRange)flag.getValue();
        if (timeUnit == null) {
            return null;
        }
        switch (timeUnit) {
            case YEAR: 
            case QUARTER: 
            case MONTH: 
            case WEEK: 
            case DAY: 
            case HOUR: 
            case MINUTE: 
            case SECOND: {
                return timeUnit.name();
            }
        }
        return null;
    }
}

