/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.druid;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.adapter.druid.DruidDateTimeUtils;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.rules.ProjectSortTransposeRule;
import org.apache.calcite.rel.rules.SortProjectTransposeRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.trace.CalciteTrace;
import org.joda.time.Interval;
import org.slf4j.Logger;

public class DruidRules {
    protected static final Logger LOGGER = CalciteTrace.getPlannerTracer();
    public static final DruidFilterRule FILTER = new DruidFilterRule();
    public static final DruidProjectRule PROJECT = new DruidProjectRule();
    public static final DruidAggregateRule AGGREGATE = new DruidAggregateRule();
    public static final DruidProjectAggregateRule PROJECT_AGGREGATE = new DruidProjectAggregateRule();
    public static final DruidSortRule SORT = new DruidSortRule();
    public static final DruidProjectSortRule PROJECT_SORT = new DruidProjectSortRule();
    public static final DruidSortProjectRule SORT_PROJECT = new DruidSortProjectRule();
    public static final List<RelOptRule> RULES = ImmutableList.of((Object)((Object)FILTER), (Object)((Object)PROJECT_AGGREGATE), (Object)((Object)PROJECT), (Object)((Object)AGGREGATE), (Object)((Object)PROJECT_SORT), (Object)((Object)SORT), (Object)((Object)SORT_PROJECT));
    private static final Predicate<AggregateCall> BAD_AGG = new Predicate<AggregateCall>(){

        public boolean apply(AggregateCall aggregateCall) {
            switch (aggregateCall.getAggregation().getKind()) {
                case COUNT: 
                case SUM: 
                case SUM0: 
                case MIN: 
                case MAX: {
                    return false;
                }
            }
            return true;
        }
    };

    private DruidRules() {
    }

    private static boolean checkTimestampRefOnQuery(ImmutableBitSet set, RelNode top, DruidQuery query) {
        if (top instanceof Project) {
            ImmutableBitSet.Builder newSet = ImmutableBitSet.builder();
            Project project = (Project)top;
            Iterator i$ = set.iterator();
            while (i$.hasNext()) {
                int index = (Integer)i$.next();
                RexNode node = (RexNode)project.getProjects().get(index);
                if (node instanceof RexInputRef) {
                    newSet.set(((RexInputRef)node).getIndex());
                    continue;
                }
                if (!(node instanceof RexCall)) continue;
                RexCall call = (RexCall)node;
                assert (DruidDateTimeUtils.extractGranularity(call) != null);
                newSet.set(((RexInputRef)call.getOperands().get(0)).getIndex());
            }
            top = project.getInput();
            set = newSet.build();
        }
        Iterator i$ = set.iterator();
        while (i$.hasNext()) {
            int index = (Integer)i$.next();
            if (!query.druidTable.timestampFieldName.equals(top.getRowType().getFieldNames().get(index))) continue;
            return true;
        }
        return false;
    }

    private static class DruidSortRule
    extends RelOptRule {
        private DruidSortRule() {
            super(DruidSortRule.operand(Sort.class, (RelOptRuleOperand)DruidSortRule.operand(DruidQuery.class, (RelOptRuleOperandChildren)DruidSortRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
        }

        public void onMatch(RelOptRuleCall call) {
            Sort sort = (Sort)call.rel(0);
            DruidQuery query = (DruidQuery)call.rel(1);
            if (!DruidQuery.isValidSignature(query.signature() + 'l')) {
                return;
            }
            if (!DruidSortRule.validSortLimit(sort, query)) {
                return;
            }
            Sort newSort = sort.copy(sort.getTraitSet(), (List)ImmutableList.of((Object)Util.last(query.rels)));
            call.transformTo((RelNode)DruidQuery.extendQuery(query, (RelNode)newSort));
        }

        private static boolean validSortLimit(Sort sort, DruidQuery query) {
            if (sort.offset != null && RexLiteral.intValue((RexNode)sort.offset) != 0) {
                return false;
            }
            if (query.getTopNode() instanceof Aggregate) {
                Aggregate topAgg = (Aggregate)query.getTopNode();
                ImmutableBitSet.Builder positionsReferenced = ImmutableBitSet.builder();
                int metricsRefs = 0;
                for (RelFieldCollation col : sort.collation.getFieldCollations()) {
                    int idx = col.getFieldIndex();
                    if (idx >= topAgg.getGroupCount()) {
                        ++metricsRefs;
                        continue;
                    }
                    positionsReferenced.set(topAgg.getGroupSet().nth(idx));
                }
                boolean refsTimestamp = DruidRules.checkTimestampRefOnQuery(positionsReferenced.build(), topAgg.getInput(), query);
                return !refsTimestamp || metricsRefs == 0;
            }
            return RelOptUtil.isPureLimit((RelNode)sort);
        }
    }

    private static class DruidSortProjectRule
    extends ProjectSortTransposeRule {
        private DruidSortProjectRule() {
            super(DruidSortProjectRule.operand(Project.class, (RelOptRuleOperand)DruidSortProjectRule.operand(Sort.class, (RelOptRuleOperand)DruidSortProjectRule.operand(DruidQuery.class, (RelOptRuleOperandChildren)DruidSortProjectRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
        }
    }

    private static class DruidProjectSortRule
    extends SortProjectTransposeRule {
        private DruidProjectSortRule() {
            super(DruidProjectSortRule.operand(Sort.class, (RelOptRuleOperand)DruidProjectSortRule.operand(Project.class, (RelOptRuleOperand)DruidProjectSortRule.operand(DruidQuery.class, (RelOptRuleOperandChildren)DruidProjectSortRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
        }
    }

    private static class DruidProjectAggregateRule
    extends RelOptRule {
        private DruidProjectAggregateRule() {
            super(DruidProjectAggregateRule.operand(Aggregate.class, (RelOptRuleOperand)DruidProjectAggregateRule.operand(Project.class, (RelOptRuleOperand)DruidProjectAggregateRule.operand(DruidQuery.class, (RelOptRuleOperandChildren)DruidProjectAggregateRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
        }

        public void onMatch(RelOptRuleCall call) {
            Aggregate aggregate = (Aggregate)call.rel(0);
            Project project = (Project)call.rel(1);
            DruidQuery query = (DruidQuery)call.rel(2);
            if (!DruidQuery.isValidSignature(query.signature() + 'p' + 'a')) {
                return;
            }
            int timestampIdx = DruidProjectAggregateRule.validProject(project, query);
            if (timestampIdx == -1) {
                return;
            }
            if (aggregate.indicator || aggregate.getGroupSets().size() != 1 || Iterables.any((Iterable)aggregate.getAggCallList(), (Predicate)BAD_AGG) || !DruidProjectAggregateRule.validAggregate(aggregate, timestampIdx)) {
                return;
            }
            RelNode newProject = project.copy(project.getTraitSet(), (List)ImmutableList.of((Object)Util.last(query.rels)));
            DruidQuery projectDruidQuery = DruidQuery.extendQuery(query, newProject);
            RelNode newAggregate = aggregate.copy(aggregate.getTraitSet(), (List)ImmutableList.of((Object)Util.last(projectDruidQuery.rels)));
            call.transformTo((RelNode)DruidQuery.extendQuery(projectDruidQuery, newAggregate));
        }

        private static int validProject(Project project, DruidQuery query) {
            List nodes = project.getProjects();
            int idxTimestamp = -1;
            for (int i = 0; i < nodes.size(); ++i) {
                RexNode e = (RexNode)nodes.get(i);
                if (e instanceof RexCall) {
                    RexCall call = (RexCall)e;
                    if (DruidDateTimeUtils.extractGranularity(call) == null) {
                        return -1;
                    }
                    if (idxTimestamp != -1) {
                        return -1;
                    }
                    if (!(call.getOperands().get(0) instanceof RexInputRef)) {
                        return -1;
                    }
                    RexInputRef ref = (RexInputRef)call.getOperands().get(0);
                    if (!DruidRules.checkTimestampRefOnQuery(ImmutableBitSet.of((int[])new int[]{ref.getIndex()}), query.getTopNode(), query)) {
                        return -1;
                    }
                    idxTimestamp = i;
                    continue;
                }
                if (!(e instanceof RexInputRef)) {
                    return -1;
                }
                RexInputRef ref = (RexInputRef)e;
                if (!DruidRules.checkTimestampRefOnQuery(ImmutableBitSet.of((int[])new int[]{ref.getIndex()}), query.getTopNode(), query)) continue;
                if (idxTimestamp != -1) {
                    return -1;
                }
                idxTimestamp = i;
            }
            return idxTimestamp;
        }

        private static boolean validAggregate(Aggregate aggregate, int idx) {
            if (!aggregate.getGroupSet().get(idx)) {
                return false;
            }
            for (AggregateCall aggCall : aggregate.getAggCallList()) {
                if (!aggCall.getArgList().contains(idx)) continue;
                return false;
            }
            return true;
        }
    }

    private static class DruidAggregateRule
    extends RelOptRule {
        private DruidAggregateRule() {
            super(DruidAggregateRule.operand(Aggregate.class, (RelOptRuleOperand)DruidAggregateRule.operand(DruidQuery.class, (RelOptRuleOperandChildren)DruidAggregateRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
        }

        public void onMatch(RelOptRuleCall call) {
            Aggregate aggregate = (Aggregate)call.rel(0);
            DruidQuery query = (DruidQuery)call.rel(1);
            if (!DruidQuery.isValidSignature(query.signature() + 'a')) {
                return;
            }
            if (aggregate.indicator || aggregate.getGroupSets().size() != 1 || Iterables.any((Iterable)aggregate.getAggCallList(), (Predicate)BAD_AGG) || !DruidAggregateRule.validAggregate(aggregate, query)) {
                return;
            }
            RelNode newAggregate = aggregate.copy(aggregate.getTraitSet(), (List)ImmutableList.of((Object)Util.last(query.rels)));
            call.transformTo((RelNode)DruidQuery.extendQuery(query, newAggregate));
        }

        private static boolean validAggregate(Aggregate aggregate, DruidQuery query) {
            ImmutableBitSet.Builder builder = ImmutableBitSet.builder();
            for (AggregateCall aggCall : aggregate.getAggCallList()) {
                builder.addAll((Iterable)aggCall.getArgList());
            }
            return !DruidRules.checkTimestampRefOnQuery(builder.build(), query.getTopNode(), query);
        }
    }

    private static class DruidProjectRule
    extends RelOptRule {
        private DruidProjectRule() {
            super(DruidProjectRule.operand(Project.class, (RelOptRuleOperand)DruidProjectRule.operand(DruidQuery.class, (RelOptRuleOperandChildren)DruidProjectRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
        }

        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            DruidQuery query = (DruidQuery)call.rel(1);
            RelOptCluster cluster = project.getCluster();
            RexBuilder rexBuilder = cluster.getRexBuilder();
            if (!DruidQuery.isValidSignature(query.signature() + 'p')) {
                return;
            }
            if (DruidProjectRule.canProjectAll(project.getProjects())) {
                RelNode newProject = project.copy(project.getTraitSet(), (List)ImmutableList.of((Object)Util.last(query.rels)));
                DruidQuery newNode = DruidQuery.extendQuery(query, newProject);
                call.transformTo((RelNode)newNode);
                return;
            }
            Pair<List<RexNode>, List<RexNode>> pair = DruidProjectRule.splitProjects(rexBuilder, (RelNode)query, project.getProjects());
            if (pair == null) {
                return;
            }
            List above = (List)pair.left;
            List below = (List)pair.right;
            RelDataTypeFactory.FieldInfoBuilder builder = cluster.getTypeFactory().builder();
            RelNode input = (RelNode)Util.last(query.rels);
            for (RexNode e : below) {
                String name = e instanceof RexInputRef ? (String)input.getRowType().getFieldNames().get(((RexInputRef)e).getIndex()) : null;
                builder.add(name, e.getType());
            }
            Project newProject = project.copy(project.getTraitSet(), input, below, builder.build());
            DruidQuery newQuery = DruidQuery.extendQuery(query, (RelNode)newProject);
            Project newProject2 = project.copy(project.getTraitSet(), (RelNode)newQuery, above, project.getRowType());
            call.transformTo((RelNode)newProject2);
        }

        private static boolean canProjectAll(List<RexNode> nodes) {
            for (RexNode e : nodes) {
                if (e instanceof RexInputRef) continue;
                return false;
            }
            return true;
        }

        private static Pair<List<RexNode>, List<RexNode>> splitProjects(final RexBuilder rexBuilder, RelNode input, List<RexNode> nodes) {
            RelOptUtil.InputReferencedVisitor visitor = new RelOptUtil.InputReferencedVisitor();
            for (RexNode node : nodes) {
                node.accept((RexVisitor)visitor);
            }
            if (visitor.inputPosReferenced.size() == input.getRowType().getFieldCount()) {
                return null;
            }
            ArrayList<RexInputRef> belowNodes = new ArrayList<RexInputRef>();
            final ArrayList<RelDataType> belowTypes = new ArrayList<RelDataType>();
            final ArrayList positions = Lists.newArrayList((Iterable)visitor.inputPosReferenced);
            Iterator i$ = positions.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                RexInputRef rexInputRef = rexBuilder.makeInputRef(input, i);
                belowNodes.add(rexInputRef);
                belowTypes.add(rexInputRef.getType());
            }
            ArrayList<Object> aboveNodes = new ArrayList<Object>();
            for (RexNode rexNode : nodes) {
                aboveNodes.add(rexNode.accept((RexVisitor)new RexShuttle(){

                    public RexNode visitInputRef(RexInputRef ref) {
                        int index = positions.indexOf(ref.getIndex());
                        return rexBuilder.makeInputRef((RelDataType)belowTypes.get(index), index);
                    }
                }));
            }
            return Pair.of(aboveNodes, belowNodes);
        }
    }

    private static class DruidFilterRule
    extends RelOptRule {
        private DruidFilterRule() {
            super(DruidFilterRule.operand(Filter.class, (RelOptRuleOperand)DruidFilterRule.operand(DruidQuery.class, (RelOptRuleOperandChildren)DruidFilterRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
        }

        public void onMatch(RelOptRuleCall call) {
            Pair<List<RexNode>, List<RexNode>> pair;
            Filter filter = (Filter)call.rel(0);
            DruidQuery query = (DruidQuery)call.rel(1);
            RelOptCluster cluster = filter.getCluster();
            RexBuilder rexBuilder = cluster.getRexBuilder();
            if (!DruidQuery.isValidSignature(query.signature() + 'f') || !query.isValidFilter(filter.getCondition())) {
                return;
            }
            int timestampFieldIdx = -1;
            for (int i = 0; i < query.getRowType().getFieldCount(); ++i) {
                if (!query.druidTable.timestampFieldName.equals(((RelDataTypeField)query.getRowType().getFieldList().get(i)).getName())) continue;
                timestampFieldIdx = i;
                break;
            }
            if ((pair = DruidFilterRule.splitFilters(rexBuilder, query, RexUtil.simplify((RexBuilder)rexBuilder, (RexNode)filter.getCondition(), (boolean)true), timestampFieldIdx)) == null) {
                return;
            }
            List<Interval> intervals = null;
            if (!((List)pair.left).isEmpty() && (intervals = DruidDateTimeUtils.createInterval(((RelDataTypeField)query.getRowType().getFieldList().get(timestampFieldIdx)).getType(), RexUtil.composeConjunction((RexBuilder)rexBuilder, (Iterable)((Iterable)pair.left), (boolean)false))) == null) {
                return;
            }
            DruidQuery newDruidQuery = query;
            if (!((List)pair.right).isEmpty()) {
                Filter newFilter = filter.copy(filter.getTraitSet(), (RelNode)Util.last(query.rels), RexUtil.composeConjunction((RexBuilder)rexBuilder, (Iterable)((Iterable)pair.right), (boolean)false));
                newDruidQuery = DruidQuery.extendQuery(query, (RelNode)newFilter);
            }
            if (intervals != null) {
                newDruidQuery = DruidQuery.extendQuery(newDruidQuery, intervals);
            }
            call.transformTo((RelNode)newDruidQuery);
        }

        private static Pair<List<RexNode>, List<RexNode>> splitFilters(RexBuilder rexBuilder, DruidQuery input, RexNode cond, int timestampFieldIdx) {
            ArrayList<RexNode> timeRangeNodes = new ArrayList<RexNode>();
            ArrayList<RexNode> otherNodes = new ArrayList<RexNode>();
            List conjs = RelOptUtil.conjunctions((RexNode)cond);
            if (conjs.isEmpty()) {
                return null;
            }
            for (RexNode conj : conjs) {
                RelOptUtil.InputReferencedVisitor visitor = new RelOptUtil.InputReferencedVisitor();
                conj.accept((RexVisitor)visitor);
                if (visitor.inputPosReferenced.contains(timestampFieldIdx)) {
                    if (visitor.inputPosReferenced.size() != 1) {
                        return null;
                    }
                    timeRangeNodes.add(conj);
                    continue;
                }
                for (Integer i : visitor.inputPosReferenced) {
                    if (!input.druidTable.metricFieldNames.contains((Object)((RelDataTypeField)input.getRowType().getFieldList().get(i)).getName())) continue;
                    return null;
                }
                otherNodes.add(conj);
            }
            return Pair.of(timeRangeNodes, otherNodes);
        }
    }
}

