/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.druid;

import com.google.common.collect.Iterables;
import java.util.List;
import org.apache.calcite.adapter.druid.DruidExpressions;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.adapter.druid.DruidSqlOperatorConverter;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;

public class UnaryPrefixOperatorConversion
implements DruidSqlOperatorConverter {
    private final SqlOperator operator;
    private final String druidOperator;

    public UnaryPrefixOperatorConversion(SqlOperator operator, String druidOperator) {
        this.operator = operator;
        this.druidOperator = druidOperator;
    }

    @Override
    public SqlOperator calciteOperator() {
        return this.operator;
    }

    @Override
    public String toDruidExpression(RexNode rexNode, RelDataType rowType, DruidQuery druidQuery) {
        RexCall call = (RexCall)rexNode;
        List<String> druidExpressions = DruidExpressions.toDruidExpressions(druidQuery, rowType, call.getOperands());
        if (druidExpressions == null) {
            return null;
        }
        return DruidQuery.format("(%s %s)", this.druidOperator, Iterables.getOnlyElement(druidExpressions));
    }
}

