/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.google.common.collect.ImmutableMap;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;

class ElasticsearchMapping {
    private final String index;
    private final Map<String, Datatype> mapping;

    ElasticsearchMapping(String index, Map<String, String> mapping) {
        this.index = Objects.requireNonNull(index, "index");
        Objects.requireNonNull(mapping, "mapping");
        Map<String, Datatype> transformed = mapping.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new Datatype((String)e.getValue())));
        this.mapping = ImmutableMap.copyOf(transformed);
    }

    Map<String, Datatype> mapping() {
        return this.mapping;
    }

    Optional<JsonNode> missingValueFor(String fieldName) {
        if (!this.mapping().containsKey(fieldName)) {
            String message = String.format(Locale.ROOT, "Field %s not defined for %s", fieldName, this.index);
            throw new IllegalArgumentException(message);
        }
        return this.mapping().get(fieldName).missingValue();
    }

    String index() {
        return this.index;
    }

    static class Datatype {
        private static final JsonNodeFactory FACTORY = JsonNodeFactory.instance;
        private static final Set<JsonNode> MISSING_VALUES = Stream.of("string", "text", "keyword", "date", "long", "integer", "double", "float").map(Datatype::missingValueForType).collect(Collectors.toSet());
        private final String name;
        private final JsonNode missingValue;

        private Datatype(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.missingValue = Datatype.missingValueForType(name);
        }

        private static @Nullable JsonNode missingValueForType(String name) {
            switch (name) {
                case "string": 
                case "text": 
                case "keyword": {
                    return FACTORY.textNode("__MISSING__");
                }
                case "long": {
                    return FACTORY.numberNode(Long.MIN_VALUE);
                }
                case "integer": {
                    return FACTORY.numberNode(Integer.MIN_VALUE);
                }
                case "short": {
                    return FACTORY.numberNode((short)Short.MIN_VALUE);
                }
                case "double": {
                    return FACTORY.numberNode(Double.MIN_VALUE);
                }
                case "float": {
                    return FACTORY.numberNode(Float.MIN_VALUE);
                }
                case "date": {
                    long millisEpoch = LocalDate.of(9999, 12, 31).atStartOfDay().toInstant(ZoneOffset.UTC).toEpochMilli();
                    return FACTORY.numberNode(millisEpoch);
                }
            }
            return null;
        }

        String name() {
            return this.name;
        }

        Optional<JsonNode> missingValue() {
            return Optional.ofNullable(this.missingValue);
        }

        static boolean isMissingValue(JsonNode node) {
            return MISSING_VALUES.contains(node);
        }
    }
}

