/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch5;

import java.lang.reflect.Type;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.tree.Primitive;
import org.elasticsearch.search.SearchHit;

public class Elasticsearch5Enumerator
implements Enumerator<Object> {
    private final Iterator<SearchHit> cursor;
    private final Function1<SearchHit, Object> getter;
    private Object current;

    public Elasticsearch5Enumerator(Iterator<SearchHit> cursor, Function1<SearchHit, Object> getter) {
        this.cursor = cursor;
        this.getter = getter;
    }

    public Object current() {
        return this.current;
    }

    public boolean moveNext() {
        if (this.cursor.hasNext()) {
            SearchHit map = this.cursor.next();
            this.current = this.getter.apply((Object)map);
            return true;
        }
        this.current = null;
        return false;
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }

    private static Function1<SearchHit, Map> mapGetter() {
        return new Function1<SearchHit, Map>(){

            public Map apply(SearchHit searchHitFields) {
                return searchHitFields.getFields();
            }
        };
    }

    private static Function1<SearchHit, Object> singletonGetter(String fieldName, final Class fieldClass) {
        return new Function1<SearchHit, Object>(){

            public Object apply(SearchHit searchHitFields) {
                if (searchHitFields.getFields().isEmpty()) {
                    return Elasticsearch5Enumerator.convert(searchHitFields.getSource(), fieldClass);
                }
                return Elasticsearch5Enumerator.convert(searchHitFields.getFields(), fieldClass);
            }
        };
    }

    private static Function1<SearchHit, Object[]> listGetter(final List<Map.Entry<String, Class>> fields) {
        return new Function1<SearchHit, Object[]>(){

            public Object[] apply(SearchHit searchHitFields) {
                Object[] objects = new Object[fields.size()];
                for (int i = 0; i < fields.size(); ++i) {
                    Map.Entry field = (Map.Entry)fields.get(i);
                    String name = (String)field.getKey();
                    objects[i] = searchHitFields.getFields().isEmpty() ? Elasticsearch5Enumerator.convert(searchHitFields.getSource().get(name), (Class)field.getValue()) : Elasticsearch5Enumerator.convert(searchHitFields.getField(name).getValue(), (Class)field.getValue());
                }
                return objects;
            }
        };
    }

    static Function1<SearchHit, Object> getter(List<Map.Entry<String, Class>> fields) {
        return fields == null ? Elasticsearch5Enumerator.mapGetter() : (fields.size() == 1 ? Elasticsearch5Enumerator.singletonGetter(fields.get(0).getKey(), fields.get(0).getValue()) : Elasticsearch5Enumerator.listGetter(fields));
    }

    private static Object convert(Object o, Class clazz) {
        if (o == null) {
            return null;
        }
        Primitive primitive = Primitive.of((Type)clazz);
        if (primitive != null) {
            clazz = primitive.boxClass;
        } else {
            primitive = Primitive.ofBox((Type)clazz);
        }
        if (clazz.isInstance(o)) {
            return o;
        }
        if (o instanceof Date && primitive != null) {
            o = ((Date)o).getTime() / 86400000L;
        }
        if (o instanceof Number && primitive != null) {
            return primitive.number((Number)o);
        }
        return o;
    }
}

