/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.elasticsearch5;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.calcite.adapter.elasticsearch.AbstractElasticsearchTable;
import org.apache.calcite.adapter.elasticsearch5.Elasticsearch5Enumerator;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.util.Util;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class Elasticsearch5Table
extends AbstractElasticsearchTable {
    private final Client client;

    public Elasticsearch5Table(Client client, String indexName, String typeName) {
        super(indexName, typeName);
        this.client = client;
    }

    protected Enumerable<Object> find(String index, List<String> ops, List<Map.Entry<String, Class>> fields) {
        SearchSourceBuilder searchSourceBuilder;
        final String dbName = index;
        if (ops.isEmpty()) {
            searchSourceBuilder = new SearchSourceBuilder();
        } else {
            String queryString = "{" + Util.toString(ops, (String)"", (String)", ", (String)"") + "}";
            NamedXContentRegistry xContentRegistry = NamedXContentRegistry.EMPTY;
            JsonXContent xContent = JsonXContent.jsonXContent;
            try (XContentParser parser = xContent.createParser(xContentRegistry, queryString);){
                QueryParseContext queryParseContext = new QueryParseContext(parser);
                searchSourceBuilder = SearchSourceBuilder.fromXContent((QueryParseContext)queryParseContext);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        final Function1<SearchHit, Object> getter = Elasticsearch5Enumerator.getter(fields);
        return new AbstractEnumerable<Object>(){

            public Enumerator<Object> enumerator() {
                Iterator cursor = ((SearchResponse)Elasticsearch5Table.this.client.prepareSearch(new String[]{dbName}).setTypes(new String[]{Elasticsearch5Table.this.typeName}).setSource(searchSourceBuilder).execute().actionGet()).getHits().iterator();
                return new Elasticsearch5Enumerator(cursor, (Function1<SearchHit, Object>)getter);
            }
        };
    }
}

