/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.csv;

import au.com.bytecode.opencsv.CSVParser;
import au.com.bytecode.opencsv.CSVReader;
import com.google.common.base.Throwables;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.Queue;
import org.apache.commons.io.input.Tailer;
import org.apache.commons.io.input.TailerListener;
import org.apache.commons.io.input.TailerListenerAdapter;

class CsvStreamReader
extends CSVReader
implements Closeable {
    protected CSVParser parser;
    protected int skipLines;
    protected Tailer tailer;
    protected Queue<String> contentQueue = new ArrayDeque<String>();
    public static final int DEFAULT_SKIP_LINES = 0;
    public static final long DEFAULT_MONITOR_DELAY = 2000L;

    CsvStreamReader(File csvFile) {
        this(csvFile, ',', '\"', '\\', 0, false, true);
    }

    private CsvStreamReader(File csvFile, char separator, char quoteChar, char escape, int line, boolean strictQuotes, boolean ignoreLeadingWhiteSpace) {
        super((Reader)new StringReader(""));
        CsvContentListener listener = new CsvContentListener(this.contentQueue);
        this.tailer = Tailer.create((File)csvFile, (TailerListener)listener, (long)2000L, (boolean)false, (boolean)true, (int)4096);
        this.parser = new CSVParser(separator, quoteChar, escape, strictQuotes, ignoreLeadingWhiteSpace);
        this.skipLines = line;
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public String[] readNext() throws IOException {
        String[] result = null;
        do {
            String nextLine;
            if ((nextLine = this.getNextLine()) == null) {
                return null;
            }
            String[] r = this.parser.parseLineMulti(nextLine);
            if (r.length <= 0) continue;
            if (result == null) {
                result = r;
                continue;
            }
            String[] t = new String[result.length + r.length];
            System.arraycopy(result, 0, t, 0, result.length);
            System.arraycopy(r, 0, t, result.length, r.length);
            result = t;
        } while (this.parser.isPending());
        return result;
    }

    private String getNextLine() throws IOException {
        return this.contentQueue.poll();
    }

    @Override
    public void close() throws IOException {
    }

    private static class CsvContentListener
    extends TailerListenerAdapter {
        final Queue<String> contentQueue;

        CsvContentListener(Queue<String> contentQueue) {
            this.contentQueue = contentQueue;
        }

        public void handle(String line) {
            this.contentQueue.add(line);
        }
    }
}

