/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.csv;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Map;
import org.apache.calcite.adapter.csv.CsvFilterableTable;
import org.apache.calcite.adapter.csv.CsvScannableTable;
import org.apache.calcite.adapter.csv.CsvTable;
import org.apache.calcite.adapter.csv.CsvTranslatableTable;
import org.apache.calcite.adapter.csv.JsonTable;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.util.Source;
import org.apache.calcite.util.Sources;

public class CsvSchema
extends AbstractSchema {
    private final File directoryFile;
    private final CsvTable.Flavor flavor;

    public CsvSchema(File directoryFile, CsvTable.Flavor flavor) {
        this.directoryFile = directoryFile;
        this.flavor = flavor;
    }

    private static String trim(String s, String suffix) {
        String trimmed = CsvSchema.trimOrNull(s, suffix);
        return trimmed != null ? trimmed : s;
    }

    private static String trimOrNull(String s, String suffix) {
        return s.endsWith(suffix) ? s.substring(0, s.length() - suffix.length()) : null;
    }

    protected Map<String, Table> getTableMap() {
        Source baseSource = Sources.of((File)this.directoryFile);
        File[] files = this.directoryFile.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String nameSansGz = CsvSchema.trim(name, ".gz");
                return nameSansGz.endsWith(".csv") || nameSansGz.endsWith(".json");
            }
        });
        if (files == null) {
            System.out.println("directory " + this.directoryFile + " not found");
            files = new File[]{};
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (File file : files) {
            Source source = Sources.of((File)file);
            Source sourceSansGz = source.trim(".gz");
            Source sourceSansJson = sourceSansGz.trimOrNull(".json");
            if (sourceSansJson != null) {
                JsonTable table = new JsonTable(source);
                builder.put((Object)sourceSansJson.relative(baseSource).path(), (Object)table);
                continue;
            }
            Source sourceSansCsv = sourceSansGz.trim(".csv");
            Table table = this.createTable(source);
            builder.put((Object)sourceSansCsv.relative(baseSource).path(), (Object)table);
        }
        return builder.build();
    }

    private Table createTable(Source source) {
        switch (this.flavor) {
            case TRANSLATABLE: {
                return new CsvTranslatableTable(source, null);
            }
            case SCANNABLE: {
                return new CsvScannableTable(source, null);
            }
            case FILTERABLE: {
                return new CsvFilterableTable(source, null);
            }
        }
        throw new AssertionError((Object)("Unknown flavor " + (Object)((Object)this.flavor)));
    }
}

