/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.csv;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Map;
import org.apache.calcite.adapter.csv.CsvFilterableTable;
import org.apache.calcite.adapter.csv.CsvScannableTable;
import org.apache.calcite.adapter.csv.CsvTable;
import org.apache.calcite.adapter.csv.CsvTranslatableTable;
import org.apache.calcite.adapter.csv.JsonTable;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;

public class CsvSchema
extends AbstractSchema {
    final File directoryFile;
    private final CsvTable.Flavor flavor;

    public CsvSchema(File directoryFile, CsvTable.Flavor flavor) {
        this.directoryFile = directoryFile;
        this.flavor = flavor;
    }

    private static String trim(String s, String suffix) {
        String trimmed = CsvSchema.trimOrNull(s, suffix);
        return trimmed != null ? trimmed : s;
    }

    private static String trimOrNull(String s, String suffix) {
        return s.endsWith(suffix) ? s.substring(0, s.length() - suffix.length()) : null;
    }

    protected Map<String, Table> getTableMap() {
        File[] files = this.directoryFile.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String nameSansGz = CsvSchema.trim(name, ".gz");
                return nameSansGz.endsWith(".csv") || nameSansGz.endsWith(".json");
            }
        });
        if (files == null) {
            System.out.println("directory " + this.directoryFile + " not found");
            files = new File[]{};
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (File file : files) {
            JsonTable table;
            String tableName = CsvSchema.trim(file.getName(), ".gz");
            String tableNameSansJson = CsvSchema.trimOrNull(tableName, ".json");
            if (tableNameSansJson != null) {
                table = new JsonTable(file);
                builder.put((Object)tableNameSansJson, (Object)table);
                continue;
            }
            tableName = CsvSchema.trim(tableName, ".csv");
            table = this.createTable(file);
            builder.put((Object)tableName, (Object)table);
        }
        return builder.build();
    }

    private Table createTable(File file) {
        switch (this.flavor) {
            case TRANSLATABLE: {
                return new CsvTranslatableTable(file, null);
            }
            case SCANNABLE: {
                return new CsvScannableTable(file, null);
            }
            case FILTERABLE: {
                return new CsvFilterableTable(file, null);
            }
        }
        throw new AssertionError((Object)("Unknown flavor " + (Object)((Object)this.flavor)));
    }
}

