/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.csv;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Source;

public class JsonEnumerator
implements Enumerator<Object[]> {
    private Enumerator<Object[]> enumerator;

    public JsonEnumerator(List<Object> list) {
        ArrayList<Object[]> objs = new ArrayList<Object[]>();
        for (Object obj : list) {
            if (obj instanceof Collection) {
                List tmp = (List)obj;
                objs.add(tmp.toArray());
                continue;
            }
            if (obj instanceof Map) {
                objs.add(((LinkedHashMap)obj).values().toArray());
                continue;
            }
            objs.add(new Object[]{obj});
        }
        this.enumerator = Linq4j.enumerator(objs);
    }

    static JsonDataConverter deduceRowType(RelDataTypeFactory typeFactory, Source source) {
        ObjectMapper objectMapper = new ObjectMapper();
        List<Object> list = new ArrayList();
        LinkedHashMap jsonFieldMap = new LinkedHashMap(1);
        Object jsonObj = null;
        try {
            objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true).configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true).configure(JsonParser.Feature.ALLOW_COMMENTS, true);
            if (source.file().exists() && source.file().length() > 0L) {
                jsonObj = "file".equals(source.protocol()) ? objectMapper.readValue(source.file(), Object.class) : objectMapper.readValue(source.url(), Object.class);
            }
        }
        catch (MismatchedInputException e) {
            if (!e.getMessage().contains("No content")) {
                throw new RuntimeException(e);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (jsonObj == null) {
            list = new ArrayList();
            jsonFieldMap.put("EmptyFileHasNoColumns", Boolean.TRUE);
        } else if (jsonObj instanceof Collection) {
            list = (List)jsonObj;
            jsonFieldMap = (LinkedHashMap)list.get(0);
        } else if (jsonObj instanceof Map) {
            jsonFieldMap = (LinkedHashMap)jsonObj;
            list = new ArrayList(((LinkedHashMap)jsonObj).values());
        } else {
            jsonFieldMap.put("line", jsonObj);
            list = new ArrayList();
            list.add(0, jsonObj);
        }
        ArrayList<RelDataType> types = new ArrayList<RelDataType>(jsonFieldMap.size());
        ArrayList<String> names = new ArrayList<String>(jsonFieldMap.size());
        for (Object key : jsonFieldMap.keySet()) {
            RelDataType type = typeFactory.createJavaType(jsonFieldMap.get(key).getClass());
            names.add(key.toString());
            types.add(type);
        }
        RelDataType relDataType = typeFactory.createStructType(Pair.zip(names, types));
        return new JsonDataConverter(relDataType, list);
    }

    public Object[] current() {
        return (Object[])this.enumerator.current();
    }

    public boolean moveNext() {
        return this.enumerator.moveNext();
    }

    public void reset() {
        this.enumerator.reset();
    }

    public void close() {
        this.enumerator.close();
    }

    static class JsonDataConverter {
        private final RelDataType relDataType;
        private final List<Object> dataList;

        private JsonDataConverter(RelDataType relDataType, List<Object> dataList) {
            this.relDataType = relDataType;
            this.dataList = dataList;
        }

        RelDataType getRelDataType() {
            return this.relDataType;
        }

        List<Object> getDataList() {
            return this.dataList;
        }
    }
}

