/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.csv;

import java.util.List;
import org.apache.calcite.adapter.csv.CsvTableScan;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;

public class CsvProjectTableScanRule
extends RelOptRule {
    public static final CsvProjectTableScanRule INSTANCE = new CsvProjectTableScanRule();

    private CsvProjectTableScanRule() {
        super(CsvProjectTableScanRule.operand(LogicalProject.class, (RelOptRuleOperand)CsvProjectTableScanRule.operand(CsvTableScan.class, (RelOptRuleOperandChildren)CsvProjectTableScanRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "CsvProjectTableScanRule");
    }

    public void onMatch(RelOptRuleCall call) {
        LogicalProject project = (LogicalProject)call.rel(0);
        CsvTableScan scan = (CsvTableScan)call.rel(1);
        int[] fields = this.getProjectFields(project.getProjects());
        if (fields == null) {
            return;
        }
        call.transformTo((RelNode)new CsvTableScan(scan.getCluster(), scan.getTable(), scan.csvTable, fields));
    }

    private int[] getProjectFields(List<RexNode> exps) {
        int[] fields = new int[exps.size()];
        for (int i = 0; i < exps.size(); ++i) {
            RexNode exp = exps.get(i);
            if (!(exp instanceof RexInputRef)) {
                return null;
            }
            fields[i] = ((RexInputRef)exp).getIndex();
        }
        return fields;
    }
}

