/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.csv;

import java.io.File;
import java.lang.reflect.Type;
import org.apache.calcite.adapter.csv.CsvEnumerator;
import org.apache.calcite.adapter.csv.CsvTable;
import org.apache.calcite.adapter.csv.CsvTableScan;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.TranslatableTable;

public class CsvTranslatableTable
extends CsvTable
implements QueryableTable,
TranslatableTable {
    CsvTranslatableTable(File file, RelProtoDataType protoRowType) {
        super(file, protoRowType);
    }

    public String toString() {
        return "CsvTranslatableTable";
    }

    public Enumerable<Object> project(final int[] fields) {
        return new AbstractEnumerable<Object>(){

            public Enumerator<Object> enumerator() {
                return new CsvEnumerator<Object>(CsvTranslatableTable.this.file, CsvTranslatableTable.this.fieldTypes, fields);
            }
        };
    }

    public Expression getExpression(SchemaPlus schema, String tableName, Class clazz) {
        return Schemas.tableExpression((SchemaPlus)schema, (Type)this.getElementType(), (String)tableName, (Class)clazz);
    }

    public Type getElementType() {
        return Object[].class;
    }

    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        throw new UnsupportedOperationException();
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        int fieldCount = relOptTable.getRowType().getFieldCount();
        int[] fields = CsvEnumerator.identityList(fieldCount);
        return new CsvTableScan(context.getCluster(), relOptTable, this, fields);
    }
}

