/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.csv;

import au.com.bytecode.opencsv.CSVReader;
import com.google.common.base.Throwables;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.GZIPInputStream;
import org.apache.calcite.adapter.csv.CsvFieldType;
import org.apache.calcite.adapter.csv.CsvStreamReader;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Pair;
import org.apache.commons.lang3.time.FastDateFormat;

class CsvEnumerator<E>
implements Enumerator<E> {
    private final CSVReader reader;
    private final String[] filterValues;
    private final AtomicBoolean cancelFlag;
    private final RowConverter<E> rowConverter;
    private E current;
    private static final FastDateFormat TIME_FORMAT_DATE;
    private static final FastDateFormat TIME_FORMAT_TIME;
    private static final FastDateFormat TIME_FORMAT_TIMESTAMP;

    public CsvEnumerator(File file, AtomicBoolean cancelFlag, List<CsvFieldType> fieldTypes) {
        this(file, cancelFlag, fieldTypes, CsvEnumerator.identityList(fieldTypes.size()));
    }

    public CsvEnumerator(File file, AtomicBoolean cancelFlag, List<CsvFieldType> fieldTypes, int[] fields) {
        this(file, cancelFlag, false, null, CsvEnumerator.converter(fieldTypes, fields));
    }

    public CsvEnumerator(File file, AtomicBoolean cancelFlag, boolean stream, String[] filterValues, RowConverter<E> rowConverter) {
        this.cancelFlag = cancelFlag;
        this.rowConverter = rowConverter;
        this.filterValues = filterValues;
        try {
            this.reader = stream ? new CsvStreamReader(file) : CsvEnumerator.openCsv(file);
            this.reader.readNext();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static RowConverter<?> converter(List<CsvFieldType> fieldTypes, int[] fields) {
        if (fields.length == 1) {
            int field = fields[0];
            return new SingleColumnRowConverter(fieldTypes.get(field), field);
        }
        return new ArrayRowConverter(fieldTypes, fields);
    }

    static RelDataType deduceRowType(JavaTypeFactory typeFactory, File file, List<CsvFieldType> fieldTypes) {
        return CsvEnumerator.deduceRowType(typeFactory, file, fieldTypes, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RelDataType deduceRowType(JavaTypeFactory typeFactory, File file, List<CsvFieldType> fieldTypes, Boolean stream) {
        ArrayList<RelDataType> types = new ArrayList<RelDataType>();
        ArrayList<String> names = new ArrayList<String>();
        CSVReader reader = null;
        if (stream.booleanValue()) {
            names.add("ROWTIME");
            types.add(typeFactory.createSqlType(SqlTypeName.TIMESTAMP));
        }
        try {
            String[] strings;
            reader = CsvEnumerator.openCsv(file);
            for (String string : strings = reader.readNext()) {
                CsvFieldType fieldType;
                String name;
                int colon = string.indexOf(58);
                if (colon >= 0) {
                    name = string.substring(0, colon);
                    String typeString = string.substring(colon + 1);
                    fieldType = CsvFieldType.of(typeString);
                    if (fieldType == null) {
                        System.out.println("WARNING: Found unknown type: " + typeString + " in file: " + file.getAbsolutePath() + " for column: " + name + ". Will assume the type of column is string");
                    }
                } else {
                    name = string;
                    fieldType = null;
                }
                RelDataType type = fieldType == null ? typeFactory.createJavaType(String.class) : fieldType.toType(typeFactory);
                names.add(name);
                types.add(type);
                if (fieldTypes == null) continue;
                fieldTypes.add(fieldType);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (names.isEmpty()) {
            names.add("line");
            types.add(typeFactory.createJavaType(String.class));
        }
        return typeFactory.createStructType(Pair.zip(names, types));
    }

    public static CSVReader openCsv(File file) throws IOException {
        InputStreamReader fileReader;
        if (file.getName().endsWith(".gz")) {
            GZIPInputStream inputStream = new GZIPInputStream(new FileInputStream(file));
            fileReader = new InputStreamReader(inputStream);
        } else {
            fileReader = new FileReader(file);
        }
        return new CSVReader((Reader)fileReader);
    }

    public E current() {
        return this.current;
    }

    public boolean moveNext() {
        try {
            String[] strings;
            block4: while (true) {
                if (this.cancelFlag.get()) {
                    return false;
                }
                strings = this.reader.readNext();
                if (strings == null) {
                    if (this.reader instanceof CsvStreamReader) {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException e) {
                            throw Throwables.propagate((Throwable)e);
                        }
                    }
                    this.current = null;
                    this.reader.close();
                    return false;
                }
                if (this.filterValues == null) break;
                for (int i = 0; i < strings.length; ++i) {
                    String filterValue = this.filterValues[i];
                    if (filterValue == null || filterValue.equals(strings[i])) continue;
                    continue block4;
                }
                break;
            }
            this.current = this.rowConverter.convertRow(strings);
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error closing CSV reader", e);
        }
    }

    static int[] identityList(int n) {
        int[] integers = new int[n];
        for (int i = 0; i < n; ++i) {
            integers[i] = i;
        }
        return integers;
    }

    static {
        TimeZone gmt = TimeZone.getTimeZone("GMT");
        TIME_FORMAT_DATE = FastDateFormat.getInstance((String)"yyyy-MM-dd", (TimeZone)gmt);
        TIME_FORMAT_TIME = FastDateFormat.getInstance((String)"HH:mm:ss", (TimeZone)gmt);
        TIME_FORMAT_TIMESTAMP = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss", (TimeZone)gmt);
    }

    private static class SingleColumnRowConverter
    extends RowConverter {
        private final CsvFieldType fieldType;
        private final int fieldIndex;

        private SingleColumnRowConverter(CsvFieldType fieldType, int fieldIndex) {
            this.fieldType = fieldType;
            this.fieldIndex = fieldIndex;
        }

        public Object convertRow(String[] strings) {
            return this.convert(this.fieldType, strings[this.fieldIndex]);
        }
    }

    static class ArrayRowConverter
    extends RowConverter<Object[]> {
        private final CsvFieldType[] fieldTypes;
        private final int[] fields;
        private final boolean stream;

        ArrayRowConverter(List<CsvFieldType> fieldTypes, int[] fields) {
            this.fieldTypes = fieldTypes.toArray(new CsvFieldType[fieldTypes.size()]);
            this.fields = fields;
            this.stream = false;
        }

        ArrayRowConverter(List<CsvFieldType> fieldTypes, int[] fields, boolean stream) {
            this.fieldTypes = fieldTypes.toArray(new CsvFieldType[fieldTypes.size()]);
            this.fields = fields;
            this.stream = stream;
        }

        @Override
        public Object[] convertRow(String[] strings) {
            if (this.stream) {
                return this.convertStreamRow(strings);
            }
            return this.convertNormalRow(strings);
        }

        public Object[] convertNormalRow(String[] strings) {
            Object[] objects = new Object[this.fields.length];
            for (int i = 0; i < this.fields.length; ++i) {
                int field = this.fields[i];
                objects[i] = this.convert(this.fieldTypes[field], strings[field]);
            }
            return objects;
        }

        public Object[] convertStreamRow(String[] strings) {
            Object[] objects = new Object[this.fields.length + 1];
            objects[0] = System.currentTimeMillis();
            for (int i = 0; i < this.fields.length; ++i) {
                int field = this.fields[i];
                objects[i + 1] = this.convert(this.fieldTypes[field], strings[field]);
            }
            return objects;
        }
    }

    static abstract class RowConverter<E> {
        RowConverter() {
        }

        abstract E convertRow(String[] var1);

        protected Object convert(CsvFieldType fieldType, String string) {
            if (fieldType == null) {
                return string;
            }
            switch (fieldType) {
                case BOOLEAN: {
                    if (string.length() == 0) {
                        return null;
                    }
                    return Boolean.parseBoolean(string);
                }
                case BYTE: {
                    if (string.length() == 0) {
                        return null;
                    }
                    return Byte.parseByte(string);
                }
                case SHORT: {
                    if (string.length() == 0) {
                        return null;
                    }
                    return Short.parseShort(string);
                }
                case INT: {
                    if (string.length() == 0) {
                        return null;
                    }
                    return Integer.parseInt(string);
                }
                case LONG: {
                    if (string.length() == 0) {
                        return null;
                    }
                    return Long.parseLong(string);
                }
                case FLOAT: {
                    if (string.length() == 0) {
                        return null;
                    }
                    return Float.valueOf(Float.parseFloat(string));
                }
                case DOUBLE: {
                    if (string.length() == 0) {
                        return null;
                    }
                    return Double.parseDouble(string);
                }
                case DATE: {
                    if (string.length() == 0) {
                        return null;
                    }
                    try {
                        java.util.Date date = TIME_FORMAT_DATE.parse(string);
                        return new Date(date.getTime());
                    }
                    catch (ParseException e) {
                        return null;
                    }
                }
                case TIME: {
                    if (string.length() == 0) {
                        return null;
                    }
                    try {
                        java.util.Date date = TIME_FORMAT_TIME.parse(string);
                        return new Time(date.getTime());
                    }
                    catch (ParseException e) {
                        return null;
                    }
                }
                case TIMESTAMP: {
                    if (string.length() == 0) {
                        return null;
                    }
                    try {
                        java.util.Date date = TIME_FORMAT_TIMESTAMP.parse(string);
                        return new Timestamp(date.getTime());
                    }
                    catch (ParseException e) {
                        return null;
                    }
                }
            }
            return string;
        }
    }
}

