/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.tree;

import java.lang.reflect.Type;
import org.apache.calcite.linq4j.tree.Evaluator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.ExpressionWriter;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.Visitor;

public class BinaryExpression
extends Expression {
    public final Expression expression0;
    public final Expression expression1;
    private final Primitive primitive;

    BinaryExpression(ExpressionType nodeType, Type type, Expression expression0, Expression expression1) {
        super(nodeType, type);
        assert (expression0 != null) : "expression0 should not be null";
        assert (expression1 != null) : "expression1 should not be null";
        this.expression0 = expression0;
        this.expression1 = expression1;
        this.primitive = Primitive.of(expression0.getType());
    }

    public Expression accept(Visitor visitor) {
        visitor = visitor.preVisit(this);
        Expression expression0 = this.expression0.accept(visitor);
        Expression expression1 = this.expression1.accept(visitor);
        return visitor.visit(this, expression0, expression1);
    }

    public Object evaluate(Evaluator evaluator) {
        switch (this.nodeType) {
            case AndAlso: {
                return (Boolean)this.expression0.evaluate(evaluator) != false && (Boolean)this.expression1.evaluate(evaluator) != false;
            }
            case Add: {
                switch (this.primitive) {
                    case INT: {
                        return (Integer)this.expression0.evaluate(evaluator) + (Integer)this.expression1.evaluate(evaluator);
                    }
                    case DOUBLE: {
                        return (Double)this.expression0.evaluate(evaluator) + (Double)this.expression1.evaluate(evaluator);
                    }
                }
                throw this.cannotEvaluate();
            }
            case Divide: {
                switch (this.primitive) {
                    case INT: {
                        return (Integer)this.expression0.evaluate(evaluator) / (Integer)this.expression1.evaluate(evaluator);
                    }
                    case DOUBLE: {
                        return (Double)this.expression0.evaluate(evaluator) / (Double)this.expression1.evaluate(evaluator);
                    }
                }
                throw this.cannotEvaluate();
            }
            case Equal: {
                return this.expression0.evaluate(evaluator).equals(this.expression1.evaluate(evaluator));
            }
            case GreaterThan: {
                switch (this.primitive) {
                    case INT: {
                        return (Integer)this.expression0.evaluate(evaluator) > (Integer)this.expression1.evaluate(evaluator);
                    }
                    case DOUBLE: {
                        return (Double)this.expression0.evaluate(evaluator) > (Double)this.expression1.evaluate(evaluator);
                    }
                }
                throw this.cannotEvaluate();
            }
            case GreaterThanOrEqual: {
                switch (this.primitive) {
                    case INT: {
                        return (Integer)this.expression0.evaluate(evaluator) >= (Integer)this.expression1.evaluate(evaluator);
                    }
                    case DOUBLE: {
                        return (Double)this.expression0.evaluate(evaluator) >= (Double)this.expression1.evaluate(evaluator);
                    }
                }
                throw this.cannotEvaluate();
            }
            case LessThan: {
                switch (this.primitive) {
                    case INT: {
                        return (Integer)this.expression0.evaluate(evaluator) < (Integer)this.expression1.evaluate(evaluator);
                    }
                    case DOUBLE: {
                        return (Double)this.expression0.evaluate(evaluator) < (Double)this.expression1.evaluate(evaluator);
                    }
                }
                throw this.cannotEvaluate();
            }
            case LessThanOrEqual: {
                switch (this.primitive) {
                    case INT: {
                        return (Integer)this.expression0.evaluate(evaluator) <= (Integer)this.expression1.evaluate(evaluator);
                    }
                    case DOUBLE: {
                        return (Double)this.expression0.evaluate(evaluator) <= (Double)this.expression1.evaluate(evaluator);
                    }
                }
                throw this.cannotEvaluate();
            }
            case Multiply: {
                switch (this.primitive) {
                    case INT: {
                        return (Integer)this.expression0.evaluate(evaluator) * (Integer)this.expression1.evaluate(evaluator);
                    }
                    case DOUBLE: {
                        return (Double)this.expression0.evaluate(evaluator) * (Double)this.expression1.evaluate(evaluator);
                    }
                }
                throw this.cannotEvaluate();
            }
            case NotEqual: {
                return !this.expression0.evaluate(evaluator).equals(this.expression1.evaluate(evaluator));
            }
            case OrElse: {
                return (Boolean)this.expression0.evaluate(evaluator) != false || (Boolean)this.expression1.evaluate(evaluator) != false;
            }
            case Subtract: {
                switch (this.primitive) {
                    case INT: {
                        return (Integer)this.expression0.evaluate(evaluator) - (Integer)this.expression1.evaluate(evaluator);
                    }
                    case DOUBLE: {
                        return (Double)this.expression0.evaluate(evaluator) - (Double)this.expression1.evaluate(evaluator);
                    }
                }
                throw this.cannotEvaluate();
            }
        }
        throw this.cannotEvaluate();
    }

    void accept(ExpressionWriter writer, int lprec, int rprec) {
        if (writer.requireParentheses(this, lprec, rprec)) {
            return;
        }
        this.expression0.accept(writer, lprec, this.nodeType.lprec);
        writer.append(this.nodeType.op);
        this.expression1.accept(writer, this.nodeType.rprec, rprec);
    }

    private RuntimeException cannotEvaluate() {
        return new RuntimeException("cannot evaluate " + this + ", nodeType=" + (Object)((Object)this.nodeType) + ", primitive=" + (Object)((Object)this.primitive));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BinaryExpression that = (BinaryExpression)o;
        if (!this.expression0.equals(that.expression0)) {
            return false;
        }
        if (!this.expression1.equals(that.expression1)) {
            return false;
        }
        return this.primitive == that.primitive;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.expression0.hashCode();
        result = 31 * result + this.expression1.hashCode();
        result = 31 * result + (this.primitive != null ? this.primitive.hashCode() : 0);
        return result;
    }
}

