/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.mongodb;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.adapter.mongodb.MongoRel;
import org.apache.calcite.adapter.mongodb.MongoRules;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;

public class MongoProject
extends Project
implements MongoRel {
    public MongoProject(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<? extends RexNode> projects, RelDataType rowType) {
        super(cluster, traitSet, input, projects, rowType);
        assert (this.getConvention() == MongoRel.CONVENTION);
        assert (this.getConvention() == input.getConvention());
    }

    @Deprecated
    public MongoProject(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<RexNode> projects, RelDataType rowType, int flags) {
        this(cluster, traitSet, input, projects, rowType);
        Util.discard((int)flags);
    }

    public Project copy(RelTraitSet traitSet, RelNode input, List<RexNode> projects, RelDataType rowType) {
        return new MongoProject(this.getCluster(), traitSet, input, projects, rowType);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.1);
    }

    @Override
    public void implement(MongoRel.Implementor implementor) {
        implementor.visitChild(0, this.getInput());
        MongoRules.RexToMongoTranslator translator = new MongoRules.RexToMongoTranslator((JavaTypeFactory)this.getCluster().getTypeFactory(), MongoRules.mongoFieldNames(this.getInput().getRowType()));
        ArrayList<String> items = new ArrayList<String>();
        for (Pair pair : this.getNamedProjects()) {
            String name = (String)pair.right;
            String expr = (String)((RexNode)pair.left).accept((RexVisitor)translator);
            items.add(expr.equals("'$" + name + "'") ? MongoRules.maybeQuote(name) + ": 1" : MongoRules.maybeQuote(name) + ": " + expr);
        }
        String findString = Util.toString(items, (String)"{", (String)", ", (String)"}");
        String aggregateString = "{$project: " + findString + "}";
        Pair op = Pair.of((Object)findString, (Object)aggregateString);
        implementor.add((String)op.left, (String)op.right);
    }
}

