/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.mongodb;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.adapter.mongodb.MongoRel;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.Util;

public class MongoSort
extends Sort
implements MongoRel {
    public MongoSort(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RelCollation collation, RexNode offset, RexNode fetch) {
        super(cluster, traitSet, child, collation, offset, fetch);
        assert (this.getConvention() == MongoRel.CONVENTION);
        assert (this.getConvention() == child.getConvention());
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.05);
    }

    public Sort copy(RelTraitSet traitSet, RelNode input, RelCollation newCollation, RexNode offset, RexNode fetch) {
        return new MongoSort(this.getCluster(), traitSet, input, this.collation, offset, fetch);
    }

    @Override
    public void implement(MongoRel.Implementor implementor) {
        implementor.visitChild(0, this.getInput());
        if (!this.collation.getFieldCollations().isEmpty()) {
            ArrayList<String> keys = new ArrayList<String>();
            List fields = this.getRowType().getFieldList();
            for (RelFieldCollation fieldCollation : this.collation.getFieldCollations()) {
                String name = ((RelDataTypeField)fields.get(fieldCollation.getFieldIndex())).getName();
                keys.add(name + ": " + this.direction(fieldCollation));
            }
            implementor.add(null, "{$sort: " + Util.toString(keys, (String)"{", (String)", ", (String)"}") + "}");
        }
        if (this.offset != null) {
            implementor.add(null, "{$skip: " + ((RexLiteral)this.offset).getValue() + "}");
        }
        if (this.fetch != null) {
            implementor.add(null, "{$limit: " + ((RexLiteral)this.fetch).getValue() + "}");
        }
    }

    private int direction(RelFieldCollation fieldCollation) {
        switch (fieldCollation.getDirection()) {
            case DESCENDING: 
            case STRICTLY_DESCENDING: {
                return -1;
            }
        }
        return 1;
    }
}

