/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.mongodb;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.adapter.mongodb.MongoMethod;
import org.apache.calcite.adapter.mongodb.MongoRel;
import org.apache.calcite.adapter.mongodb.MongoRules;
import org.apache.calcite.adapter.mongodb.MongoTable;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.prepare.CalcitePrepareImpl;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterImpl;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Pair;

public class MongoToEnumerableConverter
extends ConverterImpl
implements EnumerableRel {
    protected MongoToEnumerableConverter(RelOptCluster cluster, RelTraitSet traits, RelNode input) {
        super(cluster, (RelTraitDef)ConventionTraitDef.INSTANCE, traits, input);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new MongoToEnumerableConverter(this.getCluster(), traitSet, (RelNode)MongoToEnumerableConverter.sole(inputs));
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.1);
    }

    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockBuilder list = new BlockBuilder();
        MongoRel.Implementor mongoImplementor = new MongoRel.Implementor();
        mongoImplementor.visitChild(0, this.getInput());
        int aggCount = 0;
        int findCount = 0;
        String project = null;
        String filter = null;
        for (Pair<String, String> op : mongoImplementor.list) {
            if (op.left == null) {
                ++aggCount;
            }
            if (((String)op.right).startsWith("{$match:")) {
                filter = (String)op.left;
                ++findCount;
            }
            if (!((String)op.right).startsWith("{$project:")) continue;
            project = (String)op.left;
            ++findCount;
        }
        final RelDataType rowType = this.getRowType();
        final PhysType physType = PhysTypeImpl.of((JavaTypeFactory)implementor.getTypeFactory(), (RelDataType)rowType, (JavaRowFormat)pref.prefer(JavaRowFormat.ARRAY));
        Expression fields = list.append("fields", (Expression)MongoToEnumerableConverter.constantArrayList(Pair.zip(MongoRules.mongoFieldNames(rowType), (List)new AbstractList<Class>(){

            @Override
            public Class get(int index) {
                return physType.fieldClass(index);
            }

            @Override
            public int size() {
                return rowType.getFieldCount();
            }
        }), Pair.class));
        Expression table = list.append("table", mongoImplementor.table.getExpression(MongoTable.MongoQueryable.class));
        List opList = Pair.right(mongoImplementor.list);
        Expression ops = list.append("ops", (Expression)MongoToEnumerableConverter.constantArrayList(opList, String.class));
        Expression enumerable = list.append("enumerable", (Expression)Expressions.call((Expression)table, (Method)MongoMethod.MONGO_QUERYABLE_AGGREGATE.method, (Expression[])new Expression[]{fields, ops}));
        if (CalcitePrepareImpl.DEBUG) {
            System.out.println("Mongo: " + opList);
        }
        Hook.QUERY_PLAN.run((Object)opList);
        list.add((Statement)Expressions.return_(null, (Expression)enumerable));
        return implementor.result(physType, list.toBlock());
    }

    private static <T> MethodCallExpression constantArrayList(List<T> values, Class clazz) {
        return Expressions.call((Method)BuiltInMethod.ARRAYS_AS_LIST.method, (Expression[])new Expression[]{Expressions.newArrayInit((Type)clazz, MongoToEnumerableConverter.constantList(values))});
    }

    private static <T> List<Expression> constantList(List<T> values) {
        return Lists.transform(values, (Function)new Function<T, Expression>(){

            public Expression apply(T a0) {
                return Expressions.constant(a0);
            }
        });
    }
}

