/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.mongodb;

import java.util.AbstractList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.adapter.mongodb.MongoAggregate;
import org.apache.calcite.adapter.mongodb.MongoFilter;
import org.apache.calcite.adapter.mongodb.MongoProject;
import org.apache.calcite.adapter.mongodb.MongoRel;
import org.apache.calcite.adapter.mongodb.MongoSort;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.trace.CalciteTrace;
import org.slf4j.Logger;

public class MongoRules {
    protected static final Logger LOGGER = CalciteTrace.getPlannerTracer();
    public static final RelOptRule[] RULES = new RelOptRule[]{MongoSortRule.INSTANCE, MongoFilterRule.INSTANCE, MongoProjectRule.INSTANCE, MongoAggregateRule.INSTANCE};

    private MongoRules() {
    }

    static String isItem(RexCall call) {
        if (call.getOperator() != SqlStdOperatorTable.ITEM) {
            return null;
        }
        RexNode op0 = (RexNode)call.operands.get(0);
        RexNode op1 = (RexNode)call.operands.get(1);
        if (op0 instanceof RexInputRef && ((RexInputRef)op0).getIndex() == 0 && op1 instanceof RexLiteral && ((RexLiteral)op1).getValue2() instanceof String) {
            return (String)((RexLiteral)op1).getValue2();
        }
        return null;
    }

    static List<String> mongoFieldNames(final RelDataType rowType) {
        return SqlValidatorUtil.uniquify((List)new AbstractList<String>(){

            @Override
            public String get(int index) {
                String name = ((RelDataTypeField)rowType.getFieldList().get(index)).getName();
                return name.startsWith("$") ? "_" + name.substring(2) : name;
            }

            @Override
            public int size() {
                return rowType.getFieldCount();
            }
        }, (SqlValidatorUtil.Suggester)SqlValidatorUtil.EXPR_SUGGESTER, (boolean)true);
    }

    static String maybeQuote(String s) {
        if (!MongoRules.needsQuote(s)) {
            return s;
        }
        return MongoRules.quote(s);
    }

    static String quote(String s) {
        return "'" + s + "'";
    }

    private static boolean needsQuote(String s) {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (Character.isJavaIdentifierPart(c) && c != '$') continue;
            return true;
        }
        return false;
    }

    private static class MongoAggregateRule
    extends MongoConverterRule {
        static final MongoAggregateRule INSTANCE = (MongoAggregateRule)ConverterRule.Config.INSTANCE.withConversion(LogicalAggregate.class, (RelTrait)Convention.NONE, (RelTrait)MongoRel.CONVENTION, "MongoAggregateRule").withRuleFactory(MongoAggregateRule::new).toRule(MongoAggregateRule.class);

        MongoAggregateRule(ConverterRule.Config config) {
            super(config);
        }

        public RelNode convert(RelNode rel) {
            LogicalAggregate agg = (LogicalAggregate)rel;
            RelTraitSet traitSet = agg.getTraitSet().replace((RelTrait)this.out);
            try {
                return new MongoAggregate(rel.getCluster(), traitSet, MongoAggregateRule.convert((RelNode)agg.getInput(), (RelTraitSet)traitSet.simplify()), agg.getGroupSet(), (List<ImmutableBitSet>)agg.getGroupSets(), agg.getAggCallList());
            }
            catch (InvalidRelException e) {
                LOGGER.warn(e.toString());
                return null;
            }
        }
    }

    private static class MongoProjectRule
    extends MongoConverterRule {
        static final MongoProjectRule INSTANCE = (MongoProjectRule)ConverterRule.Config.INSTANCE.withConversion(LogicalProject.class, (RelTrait)Convention.NONE, (RelTrait)MongoRel.CONVENTION, "MongoProjectRule").withRuleFactory(MongoProjectRule::new).toRule(MongoProjectRule.class);

        MongoProjectRule(ConverterRule.Config config) {
            super(config);
        }

        public RelNode convert(RelNode rel) {
            LogicalProject project = (LogicalProject)rel;
            RelTraitSet traitSet = project.getTraitSet().replace((RelTrait)this.out);
            return new MongoProject(project.getCluster(), traitSet, MongoProjectRule.convert((RelNode)project.getInput(), (RelTrait)this.out), project.getProjects(), project.getRowType());
        }
    }

    private static class MongoFilterRule
    extends MongoConverterRule {
        static final MongoFilterRule INSTANCE = (MongoFilterRule)ConverterRule.Config.INSTANCE.withConversion(LogicalFilter.class, (RelTrait)Convention.NONE, (RelTrait)MongoRel.CONVENTION, "MongoFilterRule").withRuleFactory(MongoFilterRule::new).toRule(MongoFilterRule.class);

        MongoFilterRule(ConverterRule.Config config) {
            super(config);
        }

        public RelNode convert(RelNode rel) {
            LogicalFilter filter = (LogicalFilter)rel;
            RelTraitSet traitSet = filter.getTraitSet().replace((RelTrait)this.out);
            return new MongoFilter(rel.getCluster(), traitSet, MongoFilterRule.convert((RelNode)filter.getInput(), (RelTrait)this.out), filter.getCondition());
        }
    }

    private static class MongoSortRule
    extends MongoConverterRule {
        static final MongoSortRule INSTANCE = (MongoSortRule)ConverterRule.Config.INSTANCE.withConversion(Sort.class, (RelTrait)Convention.NONE, (RelTrait)MongoRel.CONVENTION, "MongoSortRule").withRuleFactory(MongoSortRule::new).toRule(MongoSortRule.class);

        MongoSortRule(ConverterRule.Config config) {
            super(config);
        }

        public RelNode convert(RelNode rel) {
            Sort sort = (Sort)rel;
            RelTraitSet traitSet = sort.getTraitSet().replace((RelTrait)this.out).replace((RelTrait)sort.getCollation());
            return new MongoSort(rel.getCluster(), traitSet, MongoSortRule.convert((RelNode)sort.getInput(), (RelTraitSet)traitSet.replace((RelTrait)RelCollations.EMPTY)), sort.getCollation(), sort.offset, sort.fetch);
        }
    }

    static abstract class MongoConverterRule
    extends ConverterRule {
        protected MongoConverterRule(ConverterRule.Config config) {
            super(config);
        }
    }

    static class RexToMongoTranslator
    extends RexVisitorImpl<String> {
        private final JavaTypeFactory typeFactory;
        private final List<String> inFields;
        private static final Map<SqlOperator, String> MONGO_OPERATORS = new HashMap<SqlOperator, String>();

        protected RexToMongoTranslator(JavaTypeFactory typeFactory, List<String> inFields) {
            super(true);
            this.typeFactory = typeFactory;
            this.inFields = inFields;
        }

        public String visitLiteral(RexLiteral literal) {
            if (literal.getValue() == null) {
                return "null";
            }
            return "{$literal: " + RexToLixTranslator.translateLiteral((RexLiteral)literal, (RelDataType)literal.getType(), (JavaTypeFactory)this.typeFactory, (RexImpTable.NullAs)RexImpTable.NullAs.NOT_POSSIBLE) + "}";
        }

        public String visitInputRef(RexInputRef inputRef) {
            return MongoRules.maybeQuote("$" + this.inFields.get(inputRef.getIndex()));
        }

        public String visitCall(RexCall call) {
            RexNode op1;
            String name = MongoRules.isItem(call);
            if (name != null) {
                return "'$" + name + "'";
            }
            List strings = this.visitList((Iterable)call.operands);
            if (call.getKind() == SqlKind.CAST) {
                return (String)strings.get(0);
            }
            String stdOperator = MONGO_OPERATORS.get(call.getOperator());
            if (stdOperator != null) {
                return "{" + stdOperator + ": [" + Util.commaList((List)strings) + "]}";
            }
            if (call.getOperator() == SqlStdOperatorTable.ITEM && (op1 = (RexNode)call.operands.get(1)) instanceof RexLiteral && op1.getType().getSqlTypeName() == SqlTypeName.INTEGER) {
                return "'" + this.stripQuotes((String)strings.get(0)) + "[" + ((RexLiteral)op1).getValue2() + "]'";
            }
            if (call.getOperator() == SqlStdOperatorTable.CASE) {
                StringBuilder sb = new StringBuilder();
                StringBuilder finish = new StringBuilder();
                for (int i = 0; i < strings.size(); i += 2) {
                    sb.append("{$cond:[");
                    finish.append("]}");
                    sb.append((String)strings.get(i));
                    sb.append(',');
                    sb.append((String)strings.get(i + 1));
                    sb.append(',');
                    if (i == strings.size() - 3) {
                        sb.append((String)strings.get(i + 2));
                        break;
                    }
                    if (i != strings.size() - 2) continue;
                    sb.append("null");
                    break;
                }
                sb.append((CharSequence)finish);
                return sb.toString();
            }
            throw new IllegalArgumentException("Translation of " + call.toString() + " is not supported by MongoProject");
        }

        private String stripQuotes(String s) {
            return s.startsWith("'") && s.endsWith("'") ? s.substring(1, s.length() - 1) : s;
        }

        static {
            MONGO_OPERATORS.put((SqlOperator)SqlStdOperatorTable.DIVIDE, "$divide");
            MONGO_OPERATORS.put((SqlOperator)SqlStdOperatorTable.MULTIPLY, "$multiply");
            MONGO_OPERATORS.put((SqlOperator)SqlStdOperatorTable.MOD, "$mod");
            MONGO_OPERATORS.put((SqlOperator)SqlStdOperatorTable.PLUS, "$add");
            MONGO_OPERATORS.put((SqlOperator)SqlStdOperatorTable.MINUS, "$subtract");
            MONGO_OPERATORS.put((SqlOperator)SqlStdOperatorTable.AND, "$and");
            MONGO_OPERATORS.put((SqlOperator)SqlStdOperatorTable.OR, "$or");
            MONGO_OPERATORS.put((SqlOperator)SqlStdOperatorTable.NOT, "$not");
            MONGO_OPERATORS.put((SqlOperator)SqlStdOperatorTable.EQUALS, "$eq");
            MONGO_OPERATORS.put((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, "$ne");
            MONGO_OPERATORS.put((SqlOperator)SqlStdOperatorTable.GREATER_THAN, "$gt");
            MONGO_OPERATORS.put((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, "$gte");
            MONGO_OPERATORS.put((SqlOperator)SqlStdOperatorTable.LESS_THAN, "$lt");
            MONGO_OPERATORS.put((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, "$lte");
        }
    }
}

