/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.mongodb;

import com.mongodb.AuthenticationMechanism;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import java.util.Map;
import org.apache.calcite.adapter.mongodb.MongoSchema;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaFactory;
import org.apache.calcite.schema.SchemaPlus;

public class MongoSchemaFactory
implements SchemaFactory {
    public Schema create(SchemaPlus parentSchema, String name, Map<String, Object> operand) {
        String host = (String)operand.get("host");
        String database = (String)operand.get("database");
        String authMechanismName = (String)operand.get("authMechanism");
        MongoClientOptions.Builder options = MongoClientOptions.builder();
        MongoCredential credential = authMechanismName != null ? this.createCredential(operand) : null;
        return new MongoSchema(host, database, credential, options.build());
    }

    private MongoCredential createCredential(Map<String, Object> map) {
        String authMechanismName = (String)map.get("authMechanism");
        AuthenticationMechanism authenticationMechanism = AuthenticationMechanism.fromMechanismName((String)authMechanismName);
        String username = (String)map.get("username");
        String authDatabase = (String)map.get("authDatabase");
        String password = (String)map.get("password");
        switch (authenticationMechanism) {
            case PLAIN: {
                return MongoCredential.createPlainCredential((String)username, (String)authDatabase, (char[])password.toCharArray());
            }
            case SCRAM_SHA_1: {
                return MongoCredential.createScramSha1Credential((String)username, (String)authDatabase, (char[])password.toCharArray());
            }
            case SCRAM_SHA_256: {
                return MongoCredential.createScramSha256Credential((String)username, (String)authDatabase, (char[])password.toCharArray());
            }
            case GSSAPI: {
                return MongoCredential.createGSSAPICredential((String)username);
            }
            case MONGODB_X509: {
                return MongoCredential.createMongoX509Credential((String)username);
            }
        }
        throw new IllegalArgumentException("Unsupported authentication mechanism " + authMechanismName);
    }
}

