/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.mongodb;

import com.mongodb.client.MongoCursor;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.tree.Primitive;
import org.bson.Document;

class MongoEnumerator
implements Enumerator<Object> {
    private final Iterator<Document> cursor;
    private final Function1<Document, Object> getter;
    private Object current;

    MongoEnumerator(Iterator<Document> cursor, Function1<Document, Object> getter) {
        this.cursor = cursor;
        this.getter = getter;
    }

    public Object current() {
        return this.current;
    }

    public boolean moveNext() {
        try {
            if (this.cursor.hasNext()) {
                Document map = this.cursor.next();
                this.current = this.getter.apply((Object)map);
                return true;
            }
            this.current = null;
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        if (this.cursor instanceof MongoCursor) {
            ((MongoCursor)this.cursor).close();
        }
    }

    static Function1<Document, Map> mapGetter() {
        return a0 -> a0;
    }

    static Function1<Document, Object> singletonGetter(String fieldName, Class fieldClass) {
        return a0 -> MongoEnumerator.convert(a0.get((Object)fieldName), fieldClass);
    }

    static Function1<Document, Object[]> listGetter(List<Map.Entry<String, Class>> fields) {
        return a0 -> {
            Object[] objects = new Object[fields.size()];
            for (int i = 0; i < fields.size(); ++i) {
                Map.Entry field = (Map.Entry)fields.get(i);
                String name = (String)field.getKey();
                objects[i] = MongoEnumerator.convert(a0.get((Object)name), (Class)field.getValue());
            }
            return objects;
        };
    }

    static Function1<Document, Object> getter(List<Map.Entry<String, Class>> fields) {
        return fields == null ? MongoEnumerator.mapGetter() : (fields.size() == 1 ? MongoEnumerator.singletonGetter(fields.get(0).getKey(), fields.get(0).getValue()) : MongoEnumerator.listGetter(fields));
    }

    private static Object convert(Object o, Class clazz) {
        if (o == null) {
            return null;
        }
        Primitive primitive = Primitive.of((Type)clazz);
        if (primitive != null) {
            clazz = primitive.boxClass;
        } else {
            primitive = Primitive.ofBox((Type)clazz);
        }
        if (clazz.isInstance(o)) {
            return o;
        }
        if (o instanceof Date && clazz == Long.class) {
            o = ((Date)o).getTime();
        } else if (o instanceof Date && primitive != null) {
            o = ((Date)o).getTime() / 86400000L;
        }
        if (o instanceof Number && primitive != null) {
            return primitive.number((Number)o);
        }
        return o;
    }
}

