/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.os;

import com.google.common.collect.ImmutableList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.calcite.DataContext;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ImmutableBitSet;

public class StdinTableFunction {
    private StdinTableFunction() {
    }

    public static ScannableTable eval(boolean b) {
        return new ScannableTable(){

            public Enumerable<Object[]> scan(DataContext root) {
                final InputStream is = (InputStream)DataContext.Variable.STDIN.get(root);
                return new AbstractEnumerable<Object[]>(){
                    final InputStreamReader in;
                    final BufferedReader br;
                    {
                        this.in = new InputStreamReader(is, StandardCharsets.UTF_8);
                        this.br = new BufferedReader(this.in);
                    }

                    public Enumerator<Object[]> enumerator() {
                        return new Enumerator<Object[]>(){
                            String line;
                            int i;

                            public Object[] current() {
                                if (this.line == null) {
                                    throw new NoSuchElementException();
                                }
                                return new Object[]{this.i, this.line};
                            }

                            public boolean moveNext() {
                                try {
                                    this.line = br.readLine();
                                    ++this.i;
                                    return this.line != null;
                                }
                                catch (IOException e) {
                                    throw new RuntimeException(e);
                                }
                            }

                            public void reset() {
                                throw new UnsupportedOperationException();
                            }

                            public void close() {
                                try {
                                    br.close();
                                }
                                catch (IOException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                        };
                    }
                };
            }

            public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                return typeFactory.builder().add("ordinal", SqlTypeName.INTEGER).add("line", SqlTypeName.VARCHAR).build();
            }

            public Statistic getStatistic() {
                return Statistics.of((double)1000.0, (List)ImmutableList.of((Object)ImmutableBitSet.of((int[])new int[]{1})));
            }

            public Schema.TableType getJdbcTableType() {
                return Schema.TableType.TABLE;
            }

            public boolean isRolledUp(String column) {
                return false;
            }

            public boolean rolledUpColumnValidInsideAgg(String column, SqlCall call, SqlNode parent, CalciteConnectionConfig config) {
                return true;
            }
        };
    }
}

