/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.os;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.adapter.os.Processes;
import org.apache.calcite.avatica.util.TimeUnit;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PsTableFunction {
    private static final Pattern MINUTE_SECOND_MILLIS_PATTERN = Pattern.compile("([0-9]+):([0-9]+):([0-9]+)");
    private static final Pattern HOUR_MINUTE_SECOND_PATTERN = Pattern.compile("([0-9]+):([0-9]+)\\.([0-9]+)");

    private PsTableFunction() {
    }

    public static ScannableTable eval(boolean b) {
        return new ScannableTable(){

            public Enumerable<@Nullable Object[]> scan(DataContext root) {
                String[] args;
                JavaTypeFactory typeFactory = root.getTypeFactory();
                RelDataType rowType = this.getRowType((RelDataTypeFactory)typeFactory);
                ImmutableList fieldNames = ImmutableList.copyOf((Collection)rowType.getFieldNames());
                String osName = System.getProperty("os.name");
                String osVersion = System.getProperty("os.version");
                Util.discard((Object)osVersion);
                switch (osName) {
                    case "Mac OS X": {
                        args = new String[]{"ps", "ax", "-o", "ppid=,pid=,pgid=,tpgid=,stat=,user=,pcpu=,pmem=,vsz=,rss=,tty=,start=,time=,uid=,ruid=,sess=,comm="};
                        break;
                    }
                    default: {
                        args = new String[]{"ps", "--no-headers", "axo", "ppid,pid,pgrp,tpgid,stat,user,pcpu,pmem,vsz,rss,tty,start_time,time,euid,ruid,sess,comm"};
                    }
                }
                return Processes.processLines(args).select((Function1)new Function1<String, Object[]>((List)fieldNames){
                    final /* synthetic */ List val$fieldNames;
                    {
                        this.val$fieldNames = list;
                    }

                    public Object[] apply(String line) {
                        String[] fields = line.trim().split(" +");
                        Object[] values = new Object[this.val$fieldNames.size()];
                        for (int i = 0; i < values.length; ++i) {
                            try {
                                values[i] = this.field((String)this.val$fieldNames.get(i), fields[i]);
                                continue;
                            }
                            catch (RuntimeException e) {
                                throw new RuntimeException("while parsing value [" + fields[i] + "] of field [" + (String)this.val$fieldNames.get(i) + "] in line [" + line + "]");
                            }
                        }
                        return values;
                    }

                    private Object field(String field, String value) {
                        switch (field) {
                            case "pid": 
                            case "ppid": 
                            case "pgrp": 
                            case "pgid": 
                            case "tpgid": {
                                return Integer.valueOf(value);
                            }
                            case "pcpu": 
                            case "pmem": {
                                return (int)(Float.valueOf(value).floatValue() * 10.0f);
                            }
                            case "time": {
                                Matcher m1 = MINUTE_SECOND_MILLIS_PATTERN.matcher(value);
                                if (m1.matches()) {
                                    long h = Long.parseLong(m1.group(1));
                                    long m = Long.parseLong(m1.group(2));
                                    long s = Long.parseLong(m1.group(3));
                                    return h * 3600000L + m * 60000L + s * 1000L;
                                }
                                Matcher m2 = HOUR_MINUTE_SECOND_PATTERN.matcher(value);
                                if (m2.matches()) {
                                    long m = Long.parseLong(m2.group(1));
                                    long s = Long.parseLong(m2.group(2));
                                    String g3 = m2.group(3);
                                    while (g3.length() < 3) {
                                        g3 = g3 + "0";
                                    }
                                    long millis = Long.parseLong(g3);
                                    return m * 60000L + s * 1000L + millis;
                                }
                                return 0L;
                            }
                        }
                        return value;
                    }
                });
            }

            public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                return typeFactory.builder().add("pid", SqlTypeName.INTEGER).add("ppid", SqlTypeName.INTEGER).add("pgrp", SqlTypeName.INTEGER).add("tpgid", SqlTypeName.INTEGER).add("stat", SqlTypeName.VARCHAR).add("user", SqlTypeName.VARCHAR).add("pcpu", SqlTypeName.DECIMAL, 3, 1).add("pmem", SqlTypeName.DECIMAL, 3, 1).add("vsz", SqlTypeName.INTEGER).add("rss", SqlTypeName.INTEGER).add("tty", SqlTypeName.VARCHAR).add("start_time", SqlTypeName.VARCHAR).add("time", TimeUnit.HOUR, -1, TimeUnit.SECOND, 0).add("euid", SqlTypeName.VARCHAR).add("ruid", SqlTypeName.VARCHAR).add("sess", SqlTypeName.VARCHAR).add("command", SqlTypeName.VARCHAR).build();
            }

            public Statistic getStatistic() {
                return Statistics.of((double)1000.0, (List)ImmutableList.of((Object)ImmutableBitSet.of((int[])new int[]{1})));
            }

            public Schema.TableType getJdbcTableType() {
                return Schema.TableType.TABLE;
            }

            public boolean isRolledUp(String column) {
                return false;
            }

            public boolean rolledUpColumnValidInsideAgg(String column, SqlCall call, @Nullable SqlNode parent, @Nullable CalciteConnectionConfig config) {
                return true;
            }
        };
    }
}

