/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.utils;

import cn.hutool.system.oshi.CpuTicks;
import cn.hutool.system.oshi.OshiUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.NetworkIF;
import oshi.hardware.VirtualMemory;
import oshi.software.os.FileSystem;
import oshi.software.os.OSFileStore;
import oshi.software.os.OperatingSystem;

public class OsQueryTableUtil {
    private static final String IP_ADDRESS_SEPARATOR = "; ";

    private OsQueryTableUtil() {
    }

    public static List<Object[]> getSystemInfo() {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        Object[] objects = new Object[]{OshiUtil.getOs().getNetworkParams().getHostName(), OshiUtil.getSystem().getSerialNumber(), OshiUtil.getProcessor().getProcessorIdentifier().getMicroarchitecture(), OshiUtil.getProcessor().getProcessorIdentifier().getVendor(), OshiUtil.getProcessor().getProcessorIdentifier().getModel(), OshiUtil.getProcessor().getPhysicalProcessorCount(), OshiUtil.getProcessor().getLogicalProcessorCount(), OshiUtil.getProcessor().getPhysicalPackageCount(), OshiUtil.getMemory().getTotal(), OshiUtil.getHardware().getComputerSystem().getFirmware().getManufacturer(), OshiUtil.getHardware().getComputerSystem().getModel(), OshiUtil.getHardware().getComputerSystem().getFirmware().getVersion(), OshiUtil.getHardware().getComputerSystem().getSerialNumber(), OshiUtil.getHardware().getComputerSystem().getBaseboard().getManufacturer(), OshiUtil.getHardware().getComputerSystem().getBaseboard().getModel(), OshiUtil.getHardware().getComputerSystem().getBaseboard().getVersion(), OshiUtil.getHardware().getComputerSystem().getBaseboard().getSerialNumber(), OshiUtil.getOs().getNetworkParams().getDomainName()};
        list.add(objects);
        return list;
    }

    public static List<Object[]> getJavaInfo() {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        Properties props = System.getProperties();
        Object[] objects = new Object[]{props.getProperty("java.version"), props.getProperty("java.vendor"), props.getProperty("java.vendor.url"), props.getProperty("java.home"), props.getProperty("java.vm.specification.version"), props.getProperty("java.vm.specification.vendor"), props.getProperty("java.vm.specification.name"), props.getProperty("java.vm.version"), props.getProperty("java.vm.vendor"), props.getProperty("java.vm.name"), props.getProperty("java.specification.version"), props.getProperty("java.specification.vender"), props.getProperty("java.specification.name"), props.getProperty("java.class.version"), props.getProperty("java.class.path"), props.getProperty("java.io.tmpdir"), props.getProperty("java.ext.dirs"), props.getProperty("java.library.path")};
        list.add(objects);
        return list;
    }

    public static List<Object[]> getOsVersionInfo() {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        OperatingSystem os = OshiUtil.getOs();
        Object[] objects = new Object[]{os.getVersionInfo().toString(), os.getVersionInfo().getCodeName(), os.getVersionInfo().getBuildNumber(), os.getVersionInfo().getCodeName(), os.getSystemBootTime()};
        list.add(objects);
        return list;
    }

    public static List<Object[]> getMemoryInfo() {
        GlobalMemory memory = OshiUtil.getMemory();
        VirtualMemory virtualMemory = memory.getVirtualMemory();
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        Object[] objects = new Object[]{OsQueryTableUtil.getNetFileSizeDescription(memory.getTotal()), OsQueryTableUtil.getNetFileSizeDescription(memory.getAvailable()), OsQueryTableUtil.getNetFileSizeDescription(memory.getTotal() - memory.getAvailable()), OsQueryTableUtil.getNetFileSizeDescription(virtualMemory.getSwapTotal()), OsQueryTableUtil.getNetFileSizeDescription(virtualMemory.getSwapUsed()), OsQueryTableUtil.getNetFileSizeDescription(virtualMemory.getSwapTotal() - virtualMemory.getSwapUsed()), OsQueryTableUtil.getNetFileSizeDescription(virtualMemory.getSwapPagesIn()), OsQueryTableUtil.getNetFileSizeDescription(virtualMemory.getSwapPagesOut())};
        list.add(objects);
        return list;
    }

    public static List<Object[]> getCpuInfo() {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        CentralProcessor processor = OshiUtil.getProcessor();
        Object[] objects = new Object[]{processor.getProcessorIdentifier().getProcessorID(), processor.getProcessorIdentifier().getModel(), processor.getProcessorIdentifier().getMicroarchitecture(), processor.getPhysicalProcessorCount(), processor.getLogicalProcessorCount(), processor.getProcessorIdentifier().isCpu64bit() ? 64 : 32, processor.getMaxFreq(), processor.getPhysicalPackageCount(), processor.getSystemCpuLoad(1000L)};
        list.add(objects);
        return list;
    }

    public static List<Object[]> getCpuTimeInfo() {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        CpuTicks cpuTicks = OshiUtil.getCpuInfo().getTicks();
        Object[] objects = new Object[]{cpuTicks.getIdle(), cpuTicks.getNice(), cpuTicks.getIrq(), cpuTicks.getSoftIrq(), cpuTicks.getSteal(), cpuTicks.getcSys(), cpuTicks.getUser(), cpuTicks.getIoWait()};
        list.add(objects);
        return list;
    }

    public static List<Object[]> getInterfaceAddressesInfo() {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        List networkIFList = OshiUtil.getNetworkIFs();
        for (NetworkIF intf : networkIFList) {
            Object[] objects = new Object[]{intf.getName(), OsQueryTableUtil.getIPAddressesString(intf.getIPv4addr()), OsQueryTableUtil.getIPAddressesString(intf.getIPv6addr()), intf.getMacaddr(), intf.getIfOperStatus().toString().contains("UNKNOWN") ? "" : intf.getIfOperStatus()};
            list.add(objects);
        }
        return list;
    }

    public static List<Object[]> getInterfaceDetailsInfo() {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        List networkIFList = OshiUtil.getNetworkIFs();
        for (NetworkIF intf : networkIFList) {
            Object[] objects = new Object[]{intf.getName(), intf.getMacaddr(), intf.queryNetworkInterface().isVirtual(), intf.getMTU(), intf.getSpeed(), intf.getPacketsRecv(), intf.getPacketsSent(), intf.getBytesRecv(), intf.getBytesSent(), intf.getInErrors(), intf.getOutErrors(), intf.getInDrops(), intf.getCollisions()};
            list.add(objects);
        }
        return list;
    }

    public static List<Object[]> getMountsInfo() {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        FileSystem fileSystem = OshiUtil.getOs().getFileSystem();
        List fileStores = fileSystem.getFileStores();
        for (OSFileStore fileStore : fileStores) {
            Object[] objects = new Object[]{fileStore.getName(), fileStore.getName(), OsQueryTableUtil.getNetFileSizeDescription(fileStore.getTotalSpace()), OsQueryTableUtil.getNetFileSizeDescription(fileStore.getUsableSpace()), OsQueryTableUtil.getNetFileSizeDescription(fileStore.getFreeSpace()), OsQueryTableUtil.getNetFileSizeDescription(fileStore.getTotalInodes()), OsQueryTableUtil.getNetFileSizeDescription(fileStore.getFreeInodes()), fileStore.getMount()};
            list.add(objects);
        }
        return list;
    }

    public static String getIPAddressesString(String[] ipAddressArr) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String ipAddress : ipAddressArr) {
            if (first) {
                first = false;
            } else {
                sb.append(IP_ADDRESS_SEPARATOR);
            }
            sb.append(ipAddress);
        }
        return sb.toString();
    }

    public static String getNetFileSizeDescription(long size) {
        double fileSize;
        String[] units = new String[]{"B", "KB", "MB", "GB"};
        int index = 0;
        for (fileSize = (double)size; fileSize >= 1024.0 && index < units.length - 1; fileSize /= 1024.0, ++index) {
        }
        return String.format(Locale.ROOT, "%.2f%s", fileSize, units[index]);
    }
}

