/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.tpch;

import com.google.common.collect.ImmutableMap;
import io.airlift.tpch.TpchColumn;
import io.airlift.tpch.TpchEntity;
import io.airlift.tpch.TpchTable;
import java.sql.Date;
import java.util.List;
import java.util.Map;
import org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.AbstractTableQueryable;

public class TpchSchema
extends AbstractSchema {
    private final double scaleFactor;
    private final int part;
    private final int partCount;
    private final boolean columnPrefix;
    private final ImmutableMap<String, Table> tableMap;
    private final ImmutableMap<String, String> columnPrefixes;

    public TpchSchema(double scaleFactor, int part, int partCount, boolean columnPrefix) {
        this.scaleFactor = scaleFactor;
        this.part = part;
        this.partCount = partCount;
        this.columnPrefix = columnPrefix;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (TpchTable tpchTable : TpchTable.getTables()) {
            builder.put((Object)tpchTable.getTableName().toUpperCase(), new TpchQueryableTable(tpchTable));
        }
        this.tableMap = builder.build();
        this.columnPrefixes = ImmutableMap.builder().put((Object)"LINEITEM", (Object)"L_").put((Object)"CUSTOMER", (Object)"C_").put((Object)"SUPPLIER", (Object)"S_").put((Object)"PARTSUPP", (Object)"PS_").put((Object)"PART", (Object)"P_").put((Object)"ORDERS", (Object)"O_").put((Object)"NATION", (Object)"N_").put((Object)"REGION", (Object)"R_").build();
    }

    protected Map<String, Table> getTableMap() {
        return this.tableMap;
    }

    private class TpchQueryableTable<E extends TpchEntity>
    extends AbstractQueryableTable {
        private final TpchTable<E> tpchTable;

        TpchQueryableTable(TpchTable<E> tpchTable) {
            super(Object[].class);
            this.tpchTable = tpchTable;
        }

        public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
            return new AbstractTableQueryable<Object[]>(queryProvider, schema, (QueryableTable)this, tableName){

                public Enumerator<Object[]> enumerator() {
                    final Enumerator iterator = Linq4j.iterableEnumerator((Iterable)TpchQueryableTable.this.tpchTable.createGenerator(TpchSchema.this.scaleFactor, TpchSchema.this.part, TpchSchema.this.partCount));
                    return new Enumerator<Object[]>(){

                        public Object[] current() {
                            List columns = TpchQueryableTable.this.tpchTable.getColumns();
                            Object[] objects = new Object[columns.size()];
                            int i = 0;
                            for (TpchColumn column : columns) {
                                objects[i++] = this.value(column, (TpchEntity)iterator.current());
                            }
                            return objects;
                        }

                        private Object value(TpchColumn<E> tpchColumn, E current) {
                            Class type = TpchQueryableTable.this.realType(tpchColumn);
                            if (type == String.class) {
                                return tpchColumn.getString(current);
                            }
                            if (type == Double.class) {
                                return tpchColumn.getDouble(current);
                            }
                            if (type == Date.class) {
                                return Date.valueOf(tpchColumn.getString(current));
                            }
                            return tpchColumn.getLong(current);
                        }

                        public boolean moveNext() {
                            return iterator.moveNext();
                        }

                        public void reset() {
                            iterator.reset();
                        }

                        public void close() {
                        }
                    };
                }
            };
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
            String prefix = "";
            if (TpchSchema.this.columnPrefix) {
                prefix = (String)TpchSchema.this.columnPrefixes.get((Object)this.tpchTable.getTableName().toUpperCase());
                assert (prefix != null) : this.tpchTable.getTableName().toUpperCase();
            }
            for (TpchColumn column : this.tpchTable.getColumns()) {
                builder.add((prefix + column.getColumnName()).toUpperCase(), typeFactory.createJavaType(this.realType(column)));
            }
            return builder.build();
        }

        private Class<?> realType(TpchColumn<E> column) {
            if (column.getColumnName().endsWith("date")) {
                return Date.class;
            }
            return column.getType();
        }
    }
}

