/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.ddl;

import com.google.common.collect.ImmutableList;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.ContextSqlValidator;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.schema.ColumnStrategy;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlDrop;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.ddl.SqlAttributeDefinition;
import org.apache.calcite.sql.ddl.SqlCheckConstraint;
import org.apache.calcite.sql.ddl.SqlColumnDeclaration;
import org.apache.calcite.sql.ddl.SqlCreateForeignSchema;
import org.apache.calcite.sql.ddl.SqlCreateFunction;
import org.apache.calcite.sql.ddl.SqlCreateMaterializedView;
import org.apache.calcite.sql.ddl.SqlCreateSchema;
import org.apache.calcite.sql.ddl.SqlCreateTable;
import org.apache.calcite.sql.ddl.SqlCreateType;
import org.apache.calcite.sql.ddl.SqlCreateView;
import org.apache.calcite.sql.ddl.SqlDropFunction;
import org.apache.calcite.sql.ddl.SqlDropMaterializedView;
import org.apache.calcite.sql.ddl.SqlDropSchema;
import org.apache.calcite.sql.ddl.SqlDropTable;
import org.apache.calcite.sql.ddl.SqlDropType;
import org.apache.calcite.sql.ddl.SqlDropView;
import org.apache.calcite.sql.ddl.SqlKeyConstraint;
import org.apache.calcite.sql.dialect.CalciteSqlDialect;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.pretty.SqlPrettyWriter;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.Planner;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.ValidationException;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;

public class SqlDdlNodes {
    private SqlDdlNodes() {
    }

    public static SqlCreateSchema createSchema(SqlParserPos pos, boolean replace, boolean ifNotExists, SqlIdentifier name) {
        return new SqlCreateSchema(pos, replace, ifNotExists, name);
    }

    public static SqlCreateForeignSchema createForeignSchema(SqlParserPos pos, boolean replace, boolean ifNotExists, SqlIdentifier name, SqlNode type, SqlNode library, SqlNodeList optionList) {
        return new SqlCreateForeignSchema(pos, replace, ifNotExists, name, type, library, optionList);
    }

    public static SqlCreateType createType(SqlParserPos pos, boolean replace, SqlIdentifier name, SqlNodeList attributeList, SqlDataTypeSpec dataTypeSpec) {
        return new SqlCreateType(pos, replace, name, attributeList, dataTypeSpec);
    }

    public static SqlCreateTable createTable(SqlParserPos pos, boolean replace, boolean ifNotExists, SqlIdentifier name, SqlNodeList columnList, SqlNode query) {
        return new SqlCreateTable(pos, replace, ifNotExists, name, columnList, query);
    }

    public static SqlCreateView createView(SqlParserPos pos, boolean replace, SqlIdentifier name, SqlNodeList columnList, SqlNode query) {
        return new SqlCreateView(pos, replace, name, columnList, query);
    }

    public static SqlCreateMaterializedView createMaterializedView(SqlParserPos pos, boolean replace, boolean ifNotExists, SqlIdentifier name, SqlNodeList columnList, SqlNode query) {
        return new SqlCreateMaterializedView(pos, replace, ifNotExists, name, columnList, query);
    }

    public static SqlCreateFunction createFunction(SqlParserPos pos, boolean replace, boolean ifNotExists, SqlIdentifier name, SqlNode className, SqlNodeList usingList) {
        return new SqlCreateFunction(pos, replace, ifNotExists, name, className, usingList);
    }

    public static SqlDropSchema dropSchema(SqlParserPos pos, boolean foreign, boolean ifExists, SqlIdentifier name) {
        return new SqlDropSchema(pos, foreign, ifExists, name);
    }

    public static SqlDropType dropType(SqlParserPos pos, boolean ifExists, SqlIdentifier name) {
        return new SqlDropType(pos, ifExists, name);
    }

    public static SqlDropTable dropTable(SqlParserPos pos, boolean ifExists, SqlIdentifier name) {
        return new SqlDropTable(pos, ifExists, name);
    }

    public static SqlDrop dropView(SqlParserPos pos, boolean ifExists, SqlIdentifier name) {
        return new SqlDropView(pos, ifExists, name);
    }

    public static SqlDrop dropMaterializedView(SqlParserPos pos, boolean ifExists, SqlIdentifier name) {
        return new SqlDropMaterializedView(pos, ifExists, name);
    }

    public static SqlDrop dropFunction(SqlParserPos pos, boolean ifExists, SqlIdentifier name) {
        return new SqlDropFunction(pos, ifExists, name);
    }

    public static SqlNode column(SqlParserPos pos, SqlIdentifier name, SqlDataTypeSpec dataType, SqlNode expression, ColumnStrategy strategy) {
        return new SqlColumnDeclaration(pos, name, dataType, expression, strategy);
    }

    public static SqlNode attribute(SqlParserPos pos, SqlIdentifier name, SqlDataTypeSpec dataType, SqlNode expression, SqlCollation collation) {
        return new SqlAttributeDefinition(pos, name, dataType, expression, collation);
    }

    public static SqlNode check(SqlParserPos pos, SqlIdentifier name, SqlNode expression) {
        return new SqlCheckConstraint(pos, name, expression);
    }

    public static SqlKeyConstraint unique(SqlParserPos pos, SqlIdentifier name, SqlNodeList columnList) {
        return new SqlKeyConstraint(pos, name, columnList);
    }

    public static SqlKeyConstraint primary(SqlParserPos pos, SqlIdentifier name, SqlNodeList columnList) {
        return new SqlKeyConstraint(pos, name, columnList){

            @Override
            public SqlOperator getOperator() {
                return PRIMARY;
            }
        };
    }

    static Pair<CalciteSchema, String> schema(CalcitePrepare.Context context, boolean mutable, SqlIdentifier id) {
        String name;
        List path;
        if (id.isSimple()) {
            path = context.getDefaultSchemaPath();
            name = id.getSimple();
        } else {
            path = Util.skipLast((List)id.names);
            name = (String)Util.last((List)id.names);
        }
        CalciteSchema schema = mutable ? context.getMutableRootSchema() : context.getRootSchema();
        for (String p : path) {
            schema = schema.getSubSchema(p, true);
        }
        return Pair.of((Object)schema, (Object)name);
    }

    static SqlValidator validator(CalcitePrepare.Context context, boolean mutable) {
        return new ContextSqlValidator(context, mutable);
    }

    static SqlNode renameColumns(SqlNodeList columnList, SqlNode query) {
        if (columnList == null) {
            return query;
        }
        SqlParserPos p = query.getParserPosition();
        SqlNodeList selectList = new SqlNodeList((Collection)ImmutableList.of((Object)SqlIdentifier.star((SqlParserPos)p)), p);
        SqlCall from = SqlStdOperatorTable.AS.createCall(p, (List)ImmutableList.builder().add((Object)query).add((Object)new SqlIdentifier("_", p)).addAll((Iterable)columnList).build());
        return new SqlSelect(p, null, selectList, (SqlNode)from, null, null, null, null, null, null, null);
    }

    protected static void populate(SqlIdentifier name, SqlNode query, CalcitePrepare.Context context) {
        FrameworkConfig config = Frameworks.newConfigBuilder().defaultSchema(context.getRootSchema().plus()).build();
        Planner planner = Frameworks.getPlanner((FrameworkConfig)config);
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            SqlPrettyWriter w = new SqlPrettyWriter(CalciteSqlDialect.DEFAULT, false, pw);
            pw.print("INSERT INTO ");
            name.unparse((SqlWriter)w, 0, 0);
            pw.print(" ");
            query.unparse((SqlWriter)w, 0, 0);
            pw.flush();
            String sql = sw.toString();
            SqlNode query1 = planner.parse(sql);
            SqlNode query2 = planner.validate(query1);
            RelRoot r = planner.rel(query2);
            PreparedStatement prepare = context.getRelRunner().prepare(r.rel);
            int rowCount = prepare.executeUpdate();
            Util.discard((int)rowCount);
            prepare.close();
        }
        catch (SQLException | SqlParseException | RelConversionException | ValidationException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum FileType {
        FILE,
        JAR,
        ARCHIVE;

    }
}

