/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.spark;

import java.lang.reflect.Method;
import java.util.List;
import net.hydromatic.linq4j.expressions.BlockBuilder;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.MethodCallExpression;
import net.hydromatic.linq4j.expressions.Statement;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.impl.spark.SparkMethod;
import net.hydromatic.optiq.impl.spark.SparkRel;
import net.hydromatic.optiq.rules.java.EnumerableRel;
import net.hydromatic.optiq.rules.java.JavaRowFormat;
import net.hydromatic.optiq.rules.java.PhysType;
import net.hydromatic.optiq.rules.java.PhysTypeImpl;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.convert.ConverterRelImpl;
import org.eigenbase.relopt.ConventionTraitDef;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptCost;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelTraitDef;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumerableToSparkConverter
extends ConverterRelImpl
implements SparkRel {
    protected EnumerableToSparkConverter(RelOptCluster cluster, RelTraitSet traits, RelNode input) {
        super(cluster, (RelTraitDef)ConventionTraitDef.INSTANCE, traits, input);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new EnumerableToSparkConverter(this.getCluster(), traitSet, (RelNode)EnumerableToSparkConverter.sole(inputs));
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        return super.computeSelfCost(planner).multiplyBy(0.01);
    }

    @Override
    public SparkRel.Result implementSpark(SparkRel.Implementor implementor) {
        BlockBuilder list = new BlockBuilder();
        EnumerableRel child = (EnumerableRel)this.getChild();
        PhysType physType = PhysTypeImpl.of((JavaTypeFactory)implementor.getTypeFactory(), (RelDataType)this.getRowType(), (JavaRowFormat)JavaRowFormat.CUSTOM);
        Object source = null;
        MethodCallExpression sparkContext = Expressions.call((Method)SparkMethod.GET_SPARK_CONTEXT.method, (Expression[])new Expression[]{implementor.getRootExpression()});
        Expression rdd = list.append("rdd", (Expression)Expressions.call((Method)SparkMethod.CREATE_RDD.method, (Expression[])new Expression[]{sparkContext, source}));
        list.add((Statement)Expressions.return_(null, (Expression)rdd));
        return implementor.result(physType, list.toBlock());
    }
}

