/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.spark;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.hydromatic.linq4j.expressions.BlockBuilder;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.Primitive;
import net.hydromatic.linq4j.expressions.Statement;
import net.hydromatic.optiq.BuiltinMethod;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.impl.jdbc.JdbcConvention;
import net.hydromatic.optiq.impl.jdbc.JdbcImplementor;
import net.hydromatic.optiq.impl.jdbc.JdbcRel;
import net.hydromatic.optiq.impl.jdbc.JdbcSchema;
import net.hydromatic.optiq.impl.spark.SparkRel;
import net.hydromatic.optiq.prepare.OptiqPrepareImpl;
import net.hydromatic.optiq.rules.java.JavaRowFormat;
import net.hydromatic.optiq.rules.java.PhysType;
import net.hydromatic.optiq.rules.java.PhysTypeImpl;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.convert.ConverterRelImpl;
import org.eigenbase.relopt.ConventionTraitDef;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptCost;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelTraitDef;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.sql.SqlDialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcToSparkConverter
extends ConverterRelImpl
implements SparkRel {
    protected JdbcToSparkConverter(RelOptCluster cluster, RelTraitSet traits, RelNode input) {
        super(cluster, (RelTraitDef)ConventionTraitDef.INSTANCE, traits, input);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new JdbcToSparkConverter(this.getCluster(), traitSet, (RelNode)JdbcToSparkConverter.sole(inputs));
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        return super.computeSelfCost(planner).multiplyBy(0.1);
    }

    @Override
    public SparkRel.Result implementSpark(SparkRel.Implementor implementor) {
        BlockBuilder list = new BlockBuilder();
        JdbcRel child = (JdbcRel)this.getChild();
        PhysType physType = PhysTypeImpl.of((JavaTypeFactory)implementor.getTypeFactory(), (RelDataType)this.getRowType(), (JavaRowFormat)JavaRowFormat.CUSTOM);
        JdbcConvention jdbcConvention = (JdbcConvention)child.getConvention();
        String sql = this.generateSql(jdbcConvention.dialect);
        if (OptiqPrepareImpl.DEBUG) {
            System.out.println("[" + sql + "]");
        }
        Expression sqlLiteral = list.append("sql", (Expression)Expressions.constant((Object)sql));
        ArrayList<Primitive> primitives = new ArrayList<Primitive>();
        for (int i = 0; i < this.getRowType().getFieldCount(); ++i) {
            Primitive primitive = Primitive.ofBoxOr((Type)physType.fieldClass(i));
            primitives.add(primitive != null ? primitive : Primitive.OTHER);
        }
        Expression primitivesLiteral = list.append("primitives", (Expression)Expressions.constant((Object)primitives.toArray(new Primitive[primitives.size()])));
        Expression enumerable = list.append("enumerable", (Expression)Expressions.call((Method)BuiltinMethod.RESULT_SET_ENUMERABLE_OF.method, (Expression[])new Expression[]{Expressions.call((Expression)Expressions.convert_((Expression)jdbcConvention.expression, JdbcSchema.class), (Method)BuiltinMethod.JDBC_SCHEMA_DATA_SOURCE.method, (Expression[])new Expression[0]), sqlLiteral, primitivesLiteral}));
        list.add((Statement)Expressions.return_(null, (Expression)enumerable));
        return implementor.result(physType, list.toBlock());
    }

    private String generateSql(SqlDialect dialect) {
        JdbcImplementor jdbcImplementor = new JdbcImplementor(dialect, (JavaTypeFactory)this.getCluster().getTypeFactory());
        JdbcImplementor.Result result = jdbcImplementor.visitChild(0, this.getChild());
        return result.asQuery().toSqlString(dialect).getSql();
    }
}

