/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.spark;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.calcite.adapter.enumerable.EnumerableRules;
import org.apache.calcite.adapter.spark.HttpServer;
import org.apache.calcite.adapter.spark.SparkRel;
import org.apache.calcite.adapter.spark.SparkRules;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.linq4j.tree.ClassDeclaration;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.runtime.ArrayBindable;
import org.apache.calcite.util.javac.JaninoCompiler;
import org.apache.spark.api.java.JavaSparkContext;

public class SparkHandlerImpl
implements CalcitePrepare.SparkHandler {
    private final HttpServer classServer;
    private final AtomicInteger classId;
    private final JavaSparkContext sparkContext = new JavaSparkContext("local[1]", "calcite");
    private static SparkHandlerImpl instance;
    private static final File SRC_DIR;
    private static final File CLASS_DIR;

    private SparkHandlerImpl() {
        this.classServer = new HttpServer(CLASS_DIR);
        this.classServer.start();
        System.setProperty("spark.repl.class.uri", this.classServer.uri());
        Calendar calendar = Calendar.getInstance();
        this.classId = new AtomicInteger(calendar.get(11) * 10000 + calendar.get(12) * 100 + calendar.get(13));
    }

    public static CalcitePrepare.SparkHandler instance() {
        if (instance == null) {
            instance = new SparkHandlerImpl();
        }
        return instance;
    }

    public RelNode flattenTypes(RelOptPlanner planner, RelNode rootRel, boolean restructure) {
        RelNode root2 = planner.changeTraits(rootRel, rootRel.getTraitSet().plus((RelTrait)SparkRel.CONVENTION));
        return planner.changeTraits(root2, rootRel.getTraitSet());
    }

    public void registerRules(CalcitePrepare.SparkHandler.RuleSetBuilder builder) {
        for (RelOptRule rule : SparkRules.rules()) {
            builder.addRule(rule);
        }
        builder.removeRule((RelOptRule)EnumerableRules.ENUMERABLE_VALUES_RULE);
    }

    public Object sparkContext() {
        return this.sparkContext;
    }

    public boolean enabled() {
        return true;
    }

    public ArrayBindable compile(ClassDeclaration expr, String s) {
        try {
            String className = "CalciteProgram" + this.classId.getAndIncrement();
            File file = new File(SRC_DIR, className + ".java");
            FileWriter fileWriter = new FileWriter(file, false);
            String source = "public class " + className + "\n" + "    implements " + ArrayBindable.class.getName() + ", " + Serializable.class.getName() + " {\n" + s + "\n" + "}\n";
            System.out.println("======================");
            System.out.println(source);
            System.out.println("======================");
            fileWriter.write(source);
            fileWriter.close();
            JaninoCompiler compiler = new JaninoCompiler();
            compiler.getArgs().setDestdir(CLASS_DIR.getAbsolutePath());
            compiler.getArgs().setSource(source, file.getAbsolutePath());
            compiler.getArgs().setFullClassName(className);
            compiler.compile();
            Class<?> clazz = Class.forName(className);
            Object o = clazz.newInstance();
            return (ArrayBindable)o;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        SRC_DIR = new File("/tmp");
        CLASS_DIR = new File("spark/target/classes");
    }
}

