/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.spark;

import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.spark.SparkRuntime;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SparkMethod {
    AS_ENUMERABLE(SparkRuntime.class, "asEnumerable", JavaRDD.class),
    ARRAY_TO_RDD(SparkRuntime.class, "createRdd", JavaSparkContext.class, Object[].class),
    CREATE_RDD(SparkRuntime.class, "createRdd", JavaSparkContext.class, Enumerable.class),
    GET_SPARK_CONTEXT(SparkRuntime.class, "getSparkContext", DataContext.class),
    RDD_FLAT_MAP(JavaRDD.class, "flatMap", FlatMapFunction.class),
    FLAT_MAP_FUNCTION_CALL(FlatMapFunction.class, "call", Object.class);

    public final Method method;
    private static final HashMap<Method, SparkMethod> MAP;

    private SparkMethod(Class clazz, String methodName, Class ... argumentTypes) {
        this.method = Types.lookupMethod((Class)clazz, (String)methodName, (Class[])argumentTypes);
    }

    public static SparkMethod lookup(Method method) {
        return MAP.get(method);
    }

    static {
        MAP = new HashMap();
        for (SparkMethod method : SparkMethod.values()) {
            MAP.put(method.method, method);
        }
    }
}

