/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.spark;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.adapter.spark.EnumerableToSparkConverter;
import org.apache.calcite.adapter.spark.SparkMethod;
import org.apache.calcite.adapter.spark.SparkRel;
import org.apache.calcite.adapter.spark.SparkRuntime;
import org.apache.calcite.adapter.spark.SparkToEnumerableConverter;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.logical.LogicalCalc;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.FilterToCalcRule;
import org.apache.calcite.rel.rules.ProjectToCalcRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexMultisetUtil;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;

public abstract class SparkRules {
    public static final SparkValuesRule SPARK_VALUES_RULE = new SparkValuesRule();
    public static final SparkCalcRule SPARK_CALC_RULE = new SparkCalcRule();

    private SparkRules() {
    }

    public static List<RelOptRule> rules() {
        return ImmutableList.of((Object)ProjectToCalcRule.INSTANCE, (Object)FilterToCalcRule.INSTANCE, (Object)((Object)EnumerableToSparkConverterRule.INSTANCE), (Object)((Object)SparkToEnumerableConverterRule.INSTANCE), (Object)((Object)SPARK_VALUES_RULE), (Object)((Object)SPARK_CALC_RULE));
    }

    public static void main(String[] args) {
        JavaSparkContext sc = new JavaSparkContext("local[1]", "calcite");
        JavaRDD file = sc.textFile("/usr/share/dict/words");
        System.out.println(file.map((Function & Serializable)s -> s.substring(0, Math.min(s.length(), 1))).distinct().count());
        file.cache();
        String s2 = file.groupBy((Function & Serializable)s1 -> s1.substring(0, Math.min(s1.length(), 1))).map((Function & Serializable)pair -> (String)pair._1() + ":" + Iterables.size((Iterable)((Iterable)pair._2()))).collect().toString();
        System.out.print(s2);
        JavaRDD rdd = sc.parallelize((List)new AbstractList<Integer>(){
            final Random random = new Random();

            @Override
            public Integer get(int index) {
                System.out.println("get(" + index + ")");
                return this.random.nextInt(100);
            }

            @Override
            public int size() {
                System.out.println("size");
                return 10;
            }
        });
        System.out.println(rdd.groupBy((Function & Serializable)integer -> integer % 2).collect().toString());
        System.out.println(file.flatMap((FlatMapFunction & Serializable)x -> {
            if (!x.startsWith("a")) {
                return Collections.emptyIterator();
            }
            return Collections.singletonList(Pair.of((Object)x.toUpperCase(Locale.ROOT), (Object)x.length())).iterator();
        }).take(5).toString());
    }

    public static class SparkCalc
    extends SingleRel
    implements SparkRel {
        private final RexProgram program;

        public SparkCalc(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RexProgram program) {
            super(cluster, traitSet, input);
            assert (this.getConvention() == SparkRel.CONVENTION);
            assert (!program.containsAggs());
            this.program = program;
            this.rowType = program.getOutputRowType();
        }

        @Deprecated
        public SparkCalc(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RexProgram program, int flags) {
            this(cluster, traitSet, input, program);
            Util.discard((int)flags);
        }

        public RelWriter explainTerms(RelWriter pw) {
            return this.program.explainCalc(super.explainTerms(pw));
        }

        public double estimateRowCount(RelMetadataQuery mq) {
            return RelMdUtil.estimateFilteredRows((RelNode)this.getInput(), (RexProgram)this.program, (RelMetadataQuery)mq);
        }

        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            double dRows = mq.getRowCount((RelNode)this);
            double dCpu = mq.getRowCount(this.getInput()) * (double)this.program.getExprCount();
            double dIo = 0.0;
            return planner.getCostFactory().makeCost(dRows, dCpu, dIo);
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new SparkCalc(this.getCluster(), traitSet, (RelNode)SparkCalc.sole(inputs), this.program);
        }

        @Deprecated
        public int getFlags() {
            return 1;
        }

        @Override
        public SparkRel.Result implementSpark(SparkRel.Implementor implementor) {
            JavaTypeFactory typeFactory = implementor.getTypeFactory();
            BlockBuilder builder = new BlockBuilder();
            SparkRel child = (SparkRel)this.getInput();
            SparkRel.Result result = implementor.visitInput(this, 0, child);
            PhysType physType = PhysTypeImpl.of((JavaTypeFactory)typeFactory, (RelDataType)this.getRowType(), (JavaRowFormat)JavaRowFormat.CUSTOM);
            Type outputJavaType = physType.getJavaRowType();
            Type rddType = Types.of(JavaRDD.class, (Type[])new Type[]{outputJavaType});
            Type inputJavaType = result.physType.getJavaRowType();
            Expression inputRdd_ = builder.append("inputRdd", result.block);
            BlockBuilder builder2 = new BlockBuilder();
            ParameterExpression e_ = Expressions.parameter((Type)inputJavaType, (String)"e");
            if (this.program.getCondition() != null) {
                Expression condition = RexToLixTranslator.translateCondition((RexProgram)this.program, (JavaTypeFactory)typeFactory, (BlockBuilder)builder2, (RexToLixTranslator.InputGetter)new RexToLixTranslator.InputGetterImpl(Collections.singletonList(Pair.of((Object)e_, (Object)result.physType))), null);
                builder2.add((Statement)Expressions.ifThen((Expression)Expressions.not((Expression)condition), (Node)Expressions.return_(null, (Expression)Expressions.call((Method)BuiltInMethod.COLLECTIONS_EMPTY_LIST.method, (Expression[])new Expression[0]))));
            }
            List expressions = RexToLixTranslator.translateProjects((RexProgram)this.program, (JavaTypeFactory)typeFactory, (BlockBuilder)builder2, null, (Expression)DataContext.ROOT, (RexToLixTranslator.InputGetter)new RexToLixTranslator.InputGetterImpl(Collections.singletonList(Pair.of((Object)e_, (Object)result.physType))), null);
            builder2.add((Statement)Expressions.return_(null, (Expression)Expressions.convert_((Expression)Expressions.call((Method)BuiltInMethod.COLLECTIONS_SINGLETON_LIST.method, (Expression[])new Expression[]{physType.record(expressions)}), List.class)));
            BlockStatement callBody = builder2.toBlock();
            builder.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Expression)inputRdd_, (Method)SparkMethod.RDD_FLAT_MAP.method, (Expression[])new Expression[]{Expressions.lambda(SparkRuntime.CalciteFlatMapFunction.class, (BlockStatement)callBody, (ParameterExpression[])new ParameterExpression[]{e_})})));
            return implementor.result(physType, builder.toBlock());
        }
    }

    private static class SparkCalcRule
    extends ConverterRule {
        private SparkCalcRule() {
            super(LogicalCalc.class, (RelTrait)Convention.NONE, (RelTrait)SparkRel.CONVENTION, "SparkCalcRule");
        }

        public RelNode convert(RelNode rel) {
            LogicalCalc calc = (LogicalCalc)rel;
            RexProgram program = calc.getProgram();
            if (RexMultisetUtil.containsMultiset((RexProgram)program) || program.containsAggs()) {
                return null;
            }
            return new SparkCalc(rel.getCluster(), rel.getTraitSet().replace((RelTrait)SparkRel.CONVENTION), SparkCalcRule.convert((RelNode)calc.getInput(), (RelTraitSet)calc.getInput().getTraitSet().replace((RelTrait)SparkRel.CONVENTION)), program);
        }
    }

    public static class SparkValues
    extends Values
    implements SparkRel {
        SparkValues(RelOptCluster cluster, RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples, RelTraitSet traitSet) {
            super(cluster, rowType, tuples, traitSet);
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            assert (inputs.isEmpty());
            return new SparkValues(this.getCluster(), this.rowType, (ImmutableList<ImmutableList<RexLiteral>>)this.tuples, traitSet);
        }

        @Override
        public SparkRel.Result implementSpark(SparkRel.Implementor implementor) {
            JavaTypeFactory typeFactory = (JavaTypeFactory)this.getCluster().getTypeFactory();
            BlockBuilder builder = new BlockBuilder();
            PhysType physType = PhysTypeImpl.of((JavaTypeFactory)implementor.getTypeFactory(), (RelDataType)this.getRowType(), (JavaRowFormat)JavaRowFormat.CUSTOM);
            Type rowClass = physType.getJavaRowType();
            ArrayList<Expression> expressions = new ArrayList<Expression>();
            List fields = this.rowType.getFieldList();
            for (List tuple : this.tuples) {
                ArrayList<Expression> literals = new ArrayList<Expression>();
                for (Pair pair : Pair.zip((List)fields, (List)tuple)) {
                    literals.add(RexToLixTranslator.translateLiteral((RexLiteral)((RexLiteral)pair.right), (RelDataType)((RelDataTypeField)pair.left).getType(), (JavaTypeFactory)typeFactory, (RexImpTable.NullAs)RexImpTable.NullAs.NULL));
                }
                expressions.add(physType.record(literals));
            }
            builder.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Method)SparkMethod.ARRAY_TO_RDD.method, (Expression[])new Expression[]{Expressions.call((Method)SparkMethod.GET_SPARK_CONTEXT.method, (Expression[])new Expression[]{implementor.getRootExpression()}), Expressions.newArrayInit((Type)Primitive.box((Type)rowClass), expressions)})));
            return implementor.result(physType, builder.toBlock());
        }
    }

    public static class SparkValuesRule
    extends ConverterRule {
        private SparkValuesRule() {
            super(LogicalValues.class, (RelTrait)Convention.NONE, (RelTrait)SparkRel.CONVENTION, "SparkValuesRule");
        }

        public RelNode convert(RelNode rel) {
            LogicalValues values = (LogicalValues)rel;
            return new SparkValues(values.getCluster(), values.getRowType(), (ImmutableList<ImmutableList<RexLiteral>>)values.getTuples(), values.getTraitSet().replace(this.getOutTrait()));
        }
    }

    static class SparkToEnumerableConverterRule
    extends ConverterRule {
        public static final SparkToEnumerableConverterRule INSTANCE = new SparkToEnumerableConverterRule();

        private SparkToEnumerableConverterRule() {
            super(RelNode.class, (RelTrait)SparkRel.CONVENTION, (RelTrait)EnumerableConvention.INSTANCE, "SparkToEnumerableConverterRule");
        }

        public RelNode convert(RelNode rel) {
            return new SparkToEnumerableConverter(rel.getCluster(), rel.getTraitSet().replace((RelTrait)EnumerableConvention.INSTANCE), rel);
        }
    }

    static class EnumerableToSparkConverterRule
    extends ConverterRule {
        public static final EnumerableToSparkConverterRule INSTANCE = new EnumerableToSparkConverterRule();

        private EnumerableToSparkConverterRule() {
            super(RelNode.class, (RelTrait)EnumerableConvention.INSTANCE, (RelTrait)SparkRel.CONVENTION, "EnumerableToSparkConverterRule");
        }

        public RelNode convert(RelNode rel) {
            return new EnumerableToSparkConverter(rel.getCluster(), rel.getTraitSet().replace((RelTrait)SparkRel.CONVENTION), rel);
        }
    }
}

