/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.spark;

import java.util.Arrays;
import java.util.List;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.spark.SparkHandlerImpl;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.function.Function;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;

public abstract class SparkRuntime {
    private SparkRuntime() {
    }

    public static <T> JavaRDD<T> createRdd(JavaSparkContext sc, T[] ts) {
        List<T> list = Arrays.asList(ts);
        return sc.parallelize(list);
    }

    public static <T> JavaRDD<T> createRdd(JavaSparkContext sc, Enumerable<T> enumerable) {
        List list = enumerable.toList();
        return sc.parallelize(list);
    }

    public static <T> Enumerable<T> asEnumerable(JavaRDD<T> rdd) {
        return Linq4j.asEnumerable((List)rdd.collect());
    }

    public static JavaSparkContext getSparkContext(DataContext root) {
        return (JavaSparkContext)SparkHandlerImpl.instance().sparkContext();
    }

    public static abstract class CalciteFlatMapFunction<T, R>
    extends FlatMapFunction<T, R>
    implements Function {
    }
}

