/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.spark;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.adapter.spark.SparkMethod;
import org.apache.calcite.adapter.spark.SparkRel;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterImpl;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;

public class SparkToEnumerableConverter
extends ConverterImpl
implements EnumerableRel {
    protected SparkToEnumerableConverter(RelOptCluster cluster, RelTraitSet traits, RelNode input) {
        super(cluster, (RelTraitDef)ConventionTraitDef.INSTANCE, traits, input);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new SparkToEnumerableConverter(this.getCluster(), traitSet, (RelNode)SparkToEnumerableConverter.sole(inputs));
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return super.computeSelfCost(planner, mq).multiplyBy(0.01);
    }

    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockBuilder list = new BlockBuilder();
        SparkRel child = (SparkRel)this.getInput();
        PhysType physType = PhysTypeImpl.of((JavaTypeFactory)implementor.getTypeFactory(), (RelDataType)this.getRowType(), (JavaRowFormat)JavaRowFormat.CUSTOM);
        SparkImplementorImpl sparkImplementor = new SparkImplementorImpl(implementor);
        SparkRel.Result result = child.implementSpark(sparkImplementor);
        Expression rdd = list.append("rdd", result.block);
        Expression enumerable = list.append("enumerable", (Expression)Expressions.call((Method)SparkMethod.AS_ENUMERABLE.method, (Expression[])new Expression[]{rdd}));
        list.add((Statement)Expressions.return_(null, (Expression)enumerable));
        return implementor.result(physType, list.toBlock());
    }

    private static class SparkImplementorImpl
    extends SparkRel.Implementor {
        private final EnumerableRelImplementor implementor;

        public SparkImplementorImpl(EnumerableRelImplementor implementor) {
            super(implementor.getRexBuilder());
            this.implementor = implementor;
        }

        @Override
        public SparkRel.Result result(PhysType physType, BlockStatement blockStatement) {
            return new SparkRel.Result(physType, blockStatement);
        }

        @Override
        SparkRel.Result visitInput(SparkRel parent, int ordinal, SparkRel input) {
            if (parent != null) assert (input == parent.getInputs().get(ordinal));
            return input.implementSpark(this);
        }

        public JavaTypeFactory getTypeFactory() {
            return this.implementor.getTypeFactory();
        }
    }
}

