/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.spark;

import java.io.File;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Iterator;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

class HttpServer {
    private static String localIpAddress;
    private final File resourceBase;
    private Server server;
    private int port = -1;

    HttpServer(File resourceBase) {
        this.resourceBase = resourceBase;
    }

    void start() {
        if (this.server != null) {
            throw new RuntimeException("Server is already started");
        }
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setDaemon(true);
        this.server = new Server((ThreadPool)threadPool);
        this.server.manage((Object)threadPool);
        ServerConnector connector = new ServerConnector(this.server);
        connector.setIdleTimeout(60000L);
        connector.setSoLingerTime(-1);
        connector.setPort(0);
        this.server.setConnectors(new Connector[]{connector});
        ResourceHandler resHandler = new ResourceHandler();
        resHandler.setResourceBase(this.resourceBase.getAbsolutePath());
        HandlerList handlerList = new HandlerList();
        handlerList.setHandlers(new Handler[]{resHandler, new DefaultHandler()});
        this.server.setHandler((Handler)handlerList);
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.port = connector.getLocalPort();
    }

    void stop() {
        if (this.server == null) {
            throw new RuntimeException("Server is already stopped");
        }
        try {
            Server server1 = this.server;
            this.port = -1;
            this.server = null;
            server1.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    String uri() {
        if (this.server == null) {
            throw new RuntimeException("Server is not started");
        }
        return "http://" + HttpServer.localIpAddress() + ":" + this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static synchronized String localIpAddress() {
        Class<HttpServer> clazz = HttpServer.class;
        synchronized (HttpServer.class) {
            if (localIpAddress == null) {
                try {
                    localIpAddress = HttpServer.findLocalIpAddress();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return localIpAddress;
        }
    }

    private static String findLocalIpAddress() throws IOException {
        String defaultIpOverride = System.getenv("CALCITE_LOCAL_IP");
        if (defaultIpOverride != null) {
            return defaultIpOverride;
        }
        InetAddress address = InetAddress.getLocalHost();
        if (address.isLoopbackAddress()) {
            for (NetworkInterface ni : HttpServer.iterable(NetworkInterface.getNetworkInterfaces())) {
                for (InterfaceAddress interfaceAddress : ni.getInterfaceAddresses()) {
                    InetAddress addr = interfaceAddress.getAddress();
                    if (addr.isLinkLocalAddress() || addr.isLoopbackAddress() || !(addr instanceof Inet4Address)) continue;
                    HttpServer.logWarning("Your hostname, " + InetAddress.getLocalHost().getHostName() + " resolves to a loopback address: " + address.getHostAddress() + "; using " + addr.getHostAddress() + " instead (on interface " + ni.getName() + ")");
                    HttpServer.logWarning("Set CALCITE_LOCAL_IP if you need to bind to another address");
                    return addr.getHostAddress();
                }
            }
            HttpServer.logWarning("Your hostname, " + InetAddress.getLocalHost().getHostName() + " resolves to a loopback address: " + address.getHostAddress() + ", but we couldn't find any external IP address!");
            HttpServer.logWarning("Set CALCITE_LOCAL_IP if you need to bind to another address");
        }
        return address.getHostAddress();
    }

    private static <E> Iterable<E> iterable(final Enumeration<E> enumeration) {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return new Iterator<E>(){

                    @Override
                    public boolean hasNext() {
                        return enumeration.hasMoreElements();
                    }

                    @Override
                    public E next() {
                        return enumeration.nextElement();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private static void logWarning(String s) {
        System.out.println(s);
    }
}

