/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.splunk;

import java.util.List;
import org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.adapter.splunk.SplunkQuery;
import org.apache.calcite.adapter.splunk.SplunkSchema;
import org.apache.calcite.adapter.splunk.SplunkTableScan;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractTableQueryable;

class SplunkTable
extends AbstractQueryableTable
implements TranslatableTable {
    public static final SplunkTable INSTANCE = new SplunkTable();

    private SplunkTable() {
        super(Object[].class);
    }

    public String toString() {
        return "SplunkTable";
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        RelDataType stringType = ((JavaTypeFactory)typeFactory).createType(String.class);
        return typeFactory.builder().add("source", stringType).add("sourcetype", stringType).add("_extra", stringType).build();
    }

    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return new SplunkTableQueryable(queryProvider, schema, this, tableName);
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        return new SplunkTableScan(context.getCluster(), relOptTable, this, "search", null, null, relOptTable.getRowType().getFieldNames());
    }

    public static class SplunkTableQueryable<T>
    extends AbstractTableQueryable<T> {
        SplunkTableQueryable(QueryProvider queryProvider, SchemaPlus schema, SplunkTable table, String tableName) {
            super(queryProvider, schema, (QueryableTable)table, tableName);
        }

        public Enumerator<T> enumerator() {
            SplunkQuery<T> query = this.createQuery("search", null, null, null);
            return query.enumerator();
        }

        public SplunkQuery<T> createQuery(String search, String earliest, String latest, List<String> fieldList) {
            SplunkSchema splunkSchema = (SplunkSchema)((Object)this.schema.unwrap(SplunkSchema.class));
            return new SplunkQuery(splunkSchema.splunkConnection, search, earliest, latest, fieldList);
        }
    }
}

